/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import java.util.Objects;
import org.eclipse.hono.adapter.client.registry.CredentialsClient;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.service.auth.DeviceUser;
import org.eclipse.hono.service.auth.device.AbstractDeviceCredentials;
import org.eclipse.hono.service.auth.device.DeviceCredentials;
import org.eclipse.hono.service.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CredentialsObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CredentialsApiAuthProvider<T extends AbstractDeviceCredentials>
implements DeviceCredentialsAuthProvider<T> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CredentialsClient credentialsClient;
    private final Tracer tracer;

    public CredentialsApiAuthProvider(CredentialsClient credentialsClient, Tracer tracer) {
        this.credentialsClient = Objects.requireNonNull(credentialsClient);
        this.tracer = Objects.requireNonNull(tracer);
    }

    protected final Future<CredentialsObject> getCredentialsForDevice(DeviceCredentials deviceCredentials, SpanContext spanContext) {
        Objects.requireNonNull(deviceCredentials);
        return this.credentialsClient.get(deviceCredentials.getTenantId(), deviceCredentials.getType(), deviceCredentials.getAuthId(), deviceCredentials.getClientContext(), spanContext);
    }

    @Override
    public final void authenticate(T deviceCredentials, SpanContext spanContext, Handler<AsyncResult<DeviceUser>> resultHandler) {
        Objects.requireNonNull(deviceCredentials);
        Objects.requireNonNull(resultHandler);
        Span currentSpan = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"authenticate device", (String)this.getClass().getSimpleName()).withTag("tenant_id", ((AbstractDeviceCredentials)deviceCredentials).getTenantId()).withTag(TracingHelper.TAG_AUTH_ID.getKey(), ((AbstractDeviceCredentials)deviceCredentials).getAuthId()).start();
        this.getCredentialsForDevice((DeviceCredentials)deviceCredentials, currentSpan.context()).recover(t -> Future.failedFuture((Throwable)CredentialsApiAuthProvider.mapNotFoundToBadCredentialsException(t))).compose(credentialsOnRecord -> this.validateCredentials(deviceCredentials, (CredentialsObject)credentialsOnRecord, currentSpan.context())).map(device -> new DeviceUser(device.getTenantId(), device.getDeviceId())).onComplete(authAttempt -> {
            if (authAttempt.succeeded()) {
                currentSpan.log("successfully authenticated device");
            } else {
                currentSpan.log("authentication of device failed");
                TracingHelper.logError((Span)currentSpan, (Throwable)authAttempt.cause());
            }
            currentSpan.finish();
            resultHandler.handle(authAttempt);
        });
    }

    public static Throwable mapNotFoundToBadCredentialsException(Throwable throwable) {
        return ServiceInvocationException.extractStatusCode((Throwable)throwable) == 404 ? new ClientErrorException(401, "bad credentials") : throwable;
    }

    private Future<Device> validateCredentials(T deviceCredentials, CredentialsObject credentialsOnRecord, SpanContext spanContext) {
        Span currentSpan = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)"validate credentials", (String)this.getClass().getSimpleName()).withTag("tenant_id", ((AbstractDeviceCredentials)deviceCredentials).getTenantId()).withTag(TracingHelper.TAG_AUTH_ID.getKey(), ((AbstractDeviceCredentials)deviceCredentials).getAuthId()).withTag(TracingHelper.TAG_CREDENTIALS_TYPE.getKey(), deviceCredentials.getType()).start();
        Promise result = Promise.promise();
        if (!((AbstractDeviceCredentials)deviceCredentials).getAuthId().equals(credentialsOnRecord.getAuthId())) {
            currentSpan.log(String.format("Credentials service returned wrong credentials-on-record [auth-id: %s]", credentialsOnRecord.getAuthId()));
            result.fail((Throwable)new ServerErrorException(500));
        } else if (!deviceCredentials.getType().equals(credentialsOnRecord.getType())) {
            currentSpan.log(String.format("Credentials service returned wrong credentials-on-record [type: %s]", credentialsOnRecord.getType()));
            result.fail((Throwable)new ServerErrorException(500));
        } else if (!credentialsOnRecord.isEnabled()) {
            currentSpan.log("credentials-on-record are disabled");
            result.fail((Throwable)new ClientErrorException(401));
        } else {
            this.doValidateCredentials(deviceCredentials, credentialsOnRecord).onComplete((Handler)result);
        }
        return result.future().map(device -> {
            currentSpan.log("validation of credentials succeeded");
            currentSpan.finish();
            return device;
        }).recover(t -> {
            currentSpan.log("validation of credentials failed");
            TracingHelper.logError((Span)currentSpan, (Throwable)t);
            currentSpan.finish();
            return Future.failedFuture((Throwable)t);
        });
    }

    protected abstract Future<Device> doValidateCredentials(T var1, CredentialsObject var2);

    public final void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        Object credentials = this.getCredentials(Objects.requireNonNull(authInfo));
        if (credentials == null) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new ClientErrorException(401, "malformed credentials")));
        } else {
            this.authenticate(credentials, TracingHelper.extractSpanContext((Tracer)this.tracer, (JsonObject)authInfo), (Handler<AsyncResult<DeviceUser>>)((Handler)s -> {
                if (s.succeeded()) {
                    resultHandler.handle((Object)Future.succeededFuture((Object)((User)s.result())));
                } else {
                    resultHandler.handle((Object)Future.failedFuture((Throwable)s.cause()));
                }
            }));
        }
    }
}

