/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.eclipse.hono.service.auth.device.AuthHandler;
import org.eclipse.hono.service.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.service.auth.device.ExecutionContextAuthHandler;
import org.eclipse.hono.service.auth.device.PreCredentialsValidationHandler;
import org.eclipse.hono.util.ExecutionContext;

public class ChainAuthHandler<T extends ExecutionContext>
extends ExecutionContextAuthHandler<T> {
    static final String AUTH_PROVIDER_CONTEXT_KEY = ChainAuthHandler.class.getName() + ".provider";
    private final List<AuthHandler<T>> handlerChain = new LinkedList<AuthHandler<T>>();

    public ChainAuthHandler() {
        this(null);
    }

    public ChainAuthHandler(PreCredentialsValidationHandler<T> preCredentialsValidationHandler) {
        super(null, preCredentialsValidationHandler);
    }

    public final ChainAuthHandler<T> append(AuthHandler<T> handler) {
        PreCredentialsValidationHandler nestedPreCredValidationHandler;
        if (handler instanceof ExecutionContextAuthHandler && (nestedPreCredValidationHandler = ((ExecutionContextAuthHandler)handler).getPreCredentialsValidationHandler()) != null && !nestedPreCredValidationHandler.equals(this.getPreCredentialsValidationHandler())) {
            this.log.error("{} has PreCredentialsValidationHandler set - not supported in ChainAuthHandler", handler);
            throw new IllegalArgumentException("handler with a PreCredentialsValidationHandler not supported here");
        }
        this.handlerChain.add(Objects.requireNonNull(handler));
        return this;
    }

    @Override
    public Future<JsonObject> parseCredentials(T context) {
        Promise result = Promise.promise();
        this.parseCredentials(0, context, null, (Handler<AsyncResult<JsonObject>>)result);
        return result.future();
    }

    private void parseCredentials(int idx, T context, Throwable lastException, Handler<AsyncResult<JsonObject>> resultHandler) {
        if (idx >= this.handlerChain.size()) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)lastException));
        } else {
            AuthHandler<T> handler = this.handlerChain.get(idx);
            handler.parseCredentials(context).onComplete(r -> {
                if (r.failed()) {
                    this.parseCredentials(idx + 1, context, r.cause(), resultHandler);
                } else {
                    context.put(AUTH_PROVIDER_CONTEXT_KEY, handler.getAuthProvider(context));
                    resultHandler.handle((Object)Future.succeededFuture((Object)((JsonObject)r.result())));
                }
            });
        }
    }

    @Override
    public DeviceCredentialsAuthProvider<?> getAuthProvider(T context) {
        Object obj = context.get(AUTH_PROVIDER_CONTEXT_KEY);
        if (obj instanceof DeviceCredentialsAuthProvider) {
            this.log.debug("using {}", (Object)obj.getClass().getSimpleName());
            return (DeviceCredentialsAuthProvider)obj;
        }
        if (obj != null) {
            this.log.warn("unsupported auth provider found in context [type: {}]", (Object)obj.getClass().getName());
        }
        return null;
    }
}

