/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.micrometer.core.instrument.Timer;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tags;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.TrustOptions;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.Status;
import io.vertx.proton.ProtonHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.eclipse.hono.adapter.client.command.CommandConsumer;
import org.eclipse.hono.adapter.client.command.CommandConsumerFactory;
import org.eclipse.hono.adapter.client.command.CommandContext;
import org.eclipse.hono.adapter.client.command.CommandResponse;
import org.eclipse.hono.adapter.client.command.CommandResponseSender;
import org.eclipse.hono.adapter.client.command.CommandRouterClient;
import org.eclipse.hono.adapter.client.registry.CredentialsClient;
import org.eclipse.hono.adapter.client.registry.DeviceRegistrationClient;
import org.eclipse.hono.adapter.client.registry.TenantClient;
import org.eclipse.hono.adapter.client.telemetry.EventSender;
import org.eclipse.hono.adapter.client.telemetry.TelemetrySender;
import org.eclipse.hono.adapter.client.util.ServiceClient;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.config.ProtocolAdapterProperties;
import org.eclipse.hono.service.AbstractServiceBase;
import org.eclipse.hono.service.AdapterConnectionsExceededException;
import org.eclipse.hono.service.AdapterDisabledException;
import org.eclipse.hono.service.AuthorizationException;
import org.eclipse.hono.service.ConnectionDurationExceededException;
import org.eclipse.hono.service.DataVolumeExceededException;
import org.eclipse.hono.service.RegistrationAssertionException;
import org.eclipse.hono.service.TenantConnectionsExceededException;
import org.eclipse.hono.service.auth.ValidityBasedTrustOptions;
import org.eclipse.hono.service.limiting.ConnectionLimitManager;
import org.eclipse.hono.service.metric.MetricsTags;
import org.eclipse.hono.service.monitoring.ConnectionEventProducer;
import org.eclipse.hono.service.resourcelimits.NoopResourceLimitChecks;
import org.eclipse.hono.service.resourcelimits.ResourceLimitChecks;
import org.eclipse.hono.service.util.ServiceBaseUtils;
import org.eclipse.hono.util.Constants;
import org.eclipse.hono.util.Lifecycle;
import org.eclipse.hono.util.QoS;
import org.eclipse.hono.util.RegistrationAssertion;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.Strings;
import org.eclipse.hono.util.TelemetryExecutionContext;
import org.eclipse.hono.util.TenantObject;

public abstract class AbstractProtocolAdapterBase<T extends ProtocolAdapterProperties>
extends AbstractServiceBase<T> {
    protected static final String CONTENT_TYPE_OCTET_STREAM = "application/octet-stream";
    protected static final String KEY_MICROMETER_SAMPLE = "micrometer.sample";
    private final ConnectionEventProducer.Context connectionEventProducerContext = new ConnectionEventProducer.Context(){

        @Override
        public EventSender getMessageSenderClient() {
            return AbstractProtocolAdapterBase.this.getEventSender();
        }

        @Override
        public TenantClient getTenantClient() {
            return AbstractProtocolAdapterBase.this.getTenantClient();
        }
    };
    private CommandConsumerFactory commandConsumerFactory;
    private CommandResponseSender commandResponseSender;
    private CommandRouterClient commandRouterClient;
    private ConnectionLimitManager connectionLimitManager;
    private ConnectionEventProducer connectionEventProducer;
    private CredentialsClient credentialsClient;
    private DeviceRegistrationClient registrationClient;
    private EventSender eventSender;
    private ResourceLimitChecks resourceLimitChecks = new NoopResourceLimitChecks();
    private TelemetrySender telemetrySender;
    private TenantClient tenantClient;

    protected static final void addMicrometerSample(CommandContext ctx, Timer.Sample sample) {
        Objects.requireNonNull(ctx);
        ctx.put(KEY_MICROMETER_SAMPLE, (Object)sample);
    }

    protected static final Timer.Sample getMicrometerSample(CommandContext ctx) {
        Objects.requireNonNull(ctx);
        return (Timer.Sample)ctx.get(KEY_MICROMETER_SAMPLE);
    }

    public final void setConfig(T configuration) {
        this.setSpecificConfig(configuration);
    }

    public final void setTenantClient(TenantClient client) {
        this.tenantClient = Objects.requireNonNull(client);
    }

    public final TenantClient getTenantClient() {
        return this.tenantClient;
    }

    public final void setCommandRouterClient(CommandRouterClient client) {
        this.commandRouterClient = Objects.requireNonNull(client);
        this.log.info("using Command Router client [{}]", (Object)client.getClass().getName());
    }

    public final void setTelemetrySender(TelemetrySender sender) {
        this.telemetrySender = Objects.requireNonNull(sender);
    }

    public final TelemetrySender getTelemetrySender() {
        return this.telemetrySender;
    }

    public final void setEventSender(EventSender sender) {
        this.eventSender = Objects.requireNonNull(sender);
    }

    public final EventSender getEventSender() {
        return this.eventSender;
    }

    public final void setRegistrationClient(DeviceRegistrationClient client) {
        this.registrationClient = Objects.requireNonNull(client);
    }

    public final DeviceRegistrationClient getRegistrationClient() {
        return this.registrationClient;
    }

    public final void setCredentialsClient(CredentialsClient client) {
        this.credentialsClient = Objects.requireNonNull(client);
    }

    public final CredentialsClient getCredentialsClient() {
        return this.credentialsClient;
    }

    public void setConnectionEventProducer(ConnectionEventProducer connectionEventProducer) {
        this.connectionEventProducer = Objects.requireNonNull(connectionEventProducer);
        this.log.info("using [{}] for reporting connection events, if applicable for device protocol", (Object)connectionEventProducer);
    }

    public ConnectionEventProducer getConnectionEventProducer() {
        return this.connectionEventProducer;
    }

    protected abstract String getTypeName();

    protected Future<Integer> getTimeUntilDisconnect(TenantObject tenant, Integer deviceTtd) {
        Objects.requireNonNull(tenant);
        if (deviceTtd == null) {
            return Future.succeededFuture();
        }
        return Future.succeededFuture((Object)Math.min(tenant.getMaxTimeUntilDisconnect(this.getTypeName()), deviceTtd));
    }

    public final void setCommandConsumerFactory(CommandConsumerFactory factory) {
        this.commandConsumerFactory = Objects.requireNonNull(factory);
    }

    public final CommandConsumerFactory getCommandConsumerFactory() {
        return this.commandConsumerFactory;
    }

    public final void setCommandResponseSender(CommandResponseSender sender) {
        this.commandResponseSender = Objects.requireNonNull(sender);
    }

    public final void setResourceLimitChecks(ResourceLimitChecks resourceLimitChecks) {
        this.resourceLimitChecks = Objects.requireNonNull(resourceLimitChecks);
    }

    protected final ResourceLimitChecks getResourceLimitChecks() {
        return this.resourceLimitChecks;
    }

    public final void setConnectionLimitManager(ConnectionLimitManager connectionLimitManager) {
        this.connectionLimitManager = connectionLimitManager;
    }

    protected final ConnectionLimitManager getConnectionLimitManager() {
        return this.connectionLimitManager;
    }

    @Override
    protected final Future<Void> startInternal() {
        Promise result = Promise.promise();
        if (Strings.isNullOrEmpty((Object)this.getTypeName())) {
            result.fail((Throwable)new IllegalStateException("adapter does not define a typeName"));
        } else if (this.tenantClient == null) {
            result.fail((Throwable)new IllegalStateException("Tenant client must be set"));
        } else if (this.telemetrySender == null) {
            result.fail((Throwable)new IllegalStateException("Telemetry message sender must be set"));
        } else if (this.eventSender == null) {
            result.fail((Throwable)new IllegalStateException("Event sender must be set"));
        } else if (this.registrationClient == null) {
            result.fail((Throwable)new IllegalStateException("Device Registration client must be set"));
        } else if (this.credentialsClient == null) {
            result.fail((Throwable)new IllegalStateException("Credentials client must be set"));
        } else if (this.commandConsumerFactory == null) {
            result.fail((Throwable)new IllegalStateException("Command & Control consumer factory must be set"));
        } else if (this.commandResponseSender == null) {
            result.fail((Throwable)new IllegalStateException("Command & Control response sender must be set"));
        } else if (this.commandRouterClient == null) {
            result.fail((Throwable)new IllegalStateException("Command Router client must be set"));
        } else {
            this.log.info("using ResourceLimitChecks [{}]", (Object)this.resourceLimitChecks.getClass().getName());
            this.startServiceClient((Lifecycle)this.telemetrySender, "Telemetry");
            this.startServiceClient((Lifecycle)this.eventSender, "Event");
            this.startServiceClient((Lifecycle)this.tenantClient, "Tenant service");
            this.startServiceClient((Lifecycle)this.registrationClient, "Device Registration service");
            this.startServiceClient((Lifecycle)this.credentialsClient, "Credentials service");
            this.startServiceClient((Lifecycle)this.commandConsumerFactory, "Command & Control consumer factory");
            this.startServiceClient((Lifecycle)this.commandResponseSender, "Command & Control response sender");
            this.startServiceClient((Lifecycle)this.commandRouterClient, "Command Router service");
            this.doStart((Promise<Void>)result);
        }
        return result.future();
    }

    protected void doStart(Promise<Void> startPromise) {
        startPromise.complete();
    }

    @Override
    protected final Future<Void> stopInternal() {
        this.log.info("stopping protocol adapter");
        Promise result = Promise.promise();
        this.doStop((Promise<Void>)result);
        return result.future().compose(s -> this.closeServiceClients()).recover(t -> {
            this.log.info("error while stopping protocol adapter", t);
            return Future.failedFuture((Throwable)t);
        }).map(ok -> {
            this.log.info("successfully stopped protocol adapter");
            return null;
        });
    }

    private Future<?> closeServiceClients() {
        ArrayList<Future<Void>> results = new ArrayList<Future<Void>>();
        results.add(this.stopServiceClient((Lifecycle)this.tenantClient));
        results.add(this.stopServiceClient((Lifecycle)this.registrationClient));
        results.add(this.stopServiceClient((Lifecycle)this.credentialsClient));
        results.add(this.stopServiceClient((Lifecycle)this.commandConsumerFactory));
        results.add(this.stopServiceClient((Lifecycle)this.commandResponseSender));
        results.add(this.stopServiceClient((Lifecycle)this.commandRouterClient));
        results.add(this.stopServiceClient((Lifecycle)this.eventSender));
        results.add(this.stopServiceClient((Lifecycle)this.telemetrySender));
        return CompositeFuture.all(results);
    }

    protected final Future<Void> stopServiceClient(Lifecycle client) {
        return Optional.ofNullable(client).map(Lifecycle::stop).orElse(Future.succeededFuture());
    }

    protected void doStop(Promise<Void> stopPromise) {
        stopPromise.complete();
    }

    protected final Future<TenantObject> isAdapterEnabled(TenantObject tenantConfig) {
        Objects.requireNonNull(tenantConfig);
        if (tenantConfig.isAdapterEnabled(this.getTypeName())) {
            this.log.debug("protocol adapter [{}] is enabled for tenant [{}]", (Object)this.getTypeName(), (Object)tenantConfig.getTenantId());
            return Future.succeededFuture((Object)tenantConfig);
        }
        if (!tenantConfig.isEnabled()) {
            this.log.debug("tenant [{}] is disabled", (Object)tenantConfig.getTenantId());
            return Future.failedFuture((Throwable)new ClientErrorException(403, "tenant is disabled"));
        }
        this.log.debug("protocol adapter [{}] is disabled for tenant [{}]", (Object)this.getTypeName(), (Object)tenantConfig.getTenantId());
        return Future.failedFuture((Throwable)new ClientErrorException(403, "adapter disabled for tenant"));
    }

    protected Future<Void> checkConnectionLimit(TenantObject tenantConfig, SpanContext spanContext) {
        Objects.requireNonNull(tenantConfig);
        Future connectionLimitCheckResult = this.resourceLimitChecks.isConnectionLimitReached(tenantConfig, spanContext).recover(t -> Future.succeededFuture((Object)Boolean.FALSE)).compose(isExceeded -> {
            if (isExceeded.booleanValue()) {
                return Future.failedFuture((Throwable)((Object)new TenantConnectionsExceededException(tenantConfig.getTenantId(), null, null)));
            }
            return Future.succeededFuture();
        });
        Future messageLimitCheckResult = this.checkMessageLimit(tenantConfig, 1L, spanContext).recover(t -> {
            if (t instanceof ClientErrorException) {
                return Future.failedFuture((Throwable)((Object)new DataVolumeExceededException(tenantConfig.getTenantId(), null, null)));
            }
            return Future.failedFuture((Throwable)t);
        });
        return CompositeFuture.all((Future)connectionLimitCheckResult, this.checkConnectionDurationLimit(tenantConfig, spanContext), (Future)messageLimitCheckResult).mapEmpty();
    }

    protected Future<Void> checkMessageLimit(TenantObject tenantConfig, long payloadSize, SpanContext spanContext) {
        Objects.requireNonNull(tenantConfig);
        return this.resourceLimitChecks.isMessageLimitReached(tenantConfig, ServiceBaseUtils.calculatePayloadSize(payloadSize, tenantConfig), spanContext).recover(t -> Future.succeededFuture((Object)Boolean.FALSE)).compose(isExceeded -> {
            if (isExceeded.booleanValue()) {
                return Future.failedFuture((Throwable)new ClientErrorException(HttpResponseStatus.TOO_MANY_REQUESTS.code()));
            }
            return Future.succeededFuture();
        });
    }

    protected Future<Void> checkConnectionDurationLimit(TenantObject tenantConfig, SpanContext spanContext) {
        Objects.requireNonNull(tenantConfig);
        return this.resourceLimitChecks.isConnectionDurationLimitReached(tenantConfig, spanContext).recover(t -> Future.succeededFuture((Object)Boolean.FALSE)).compose(isExceeded -> {
            if (isExceeded.booleanValue()) {
                return Future.failedFuture((Throwable)((Object)new ConnectionDurationExceededException(tenantConfig.getTenantId(), null, null)));
            }
            return Future.succeededFuture();
        });
    }

    protected final Future<ResourceIdentifier> validateAddress(ResourceIdentifier address, Device authenticatedDevice) {
        Objects.requireNonNull(address);
        Promise result = Promise.promise();
        if (authenticatedDevice == null) {
            if (Strings.isNullOrEmpty((Object)address.getTenantId()) || Strings.isNullOrEmpty((Object)address.getResourceId())) {
                result.fail((Throwable)new ClientErrorException(400, "unauthenticated client must provide tenant and device ID in message address"));
            } else {
                result.complete((Object)address);
            }
        } else if (!Strings.isNullOrEmpty((Object)address.getTenantId()) && Strings.isNullOrEmpty((Object)address.getResourceId())) {
            result.fail((Throwable)new ClientErrorException(400, "message address must not contain tenant ID only"));
        } else if (!Strings.isNullOrEmpty((Object)address.getTenantId()) && !address.getTenantId().equals(authenticatedDevice.getTenantId())) {
            result.fail((Throwable)new ClientErrorException(403, "can only publish for device of same tenant"));
        } else if (Strings.isNullOrEmpty((Object)address.getTenantId()) && Strings.isNullOrEmpty((Object)address.getResourceId())) {
            ResourceIdentifier resource = ResourceIdentifier.from((ResourceIdentifier)address, (String)authenticatedDevice.getTenantId(), (String)authenticatedDevice.getDeviceId());
            result.complete((Object)resource);
        } else if (Strings.isNullOrEmpty((Object)address.getTenantId())) {
            ResourceIdentifier resource = ResourceIdentifier.from((ResourceIdentifier)address, (String)authenticatedDevice.getTenantId(), (String)address.getResourceId());
            result.complete((Object)resource);
        } else {
            result.complete((Object)address);
        }
        return result.future().recover(t -> {
            this.log.debug("validation failed for address [{}], device [{}]: {}", new Object[]{address, authenticatedDevice, t.getMessage()});
            return Future.failedFuture((Throwable)t);
        });
    }

    protected final Future<Void> checkDeviceRegistration(Device device, SpanContext context) {
        Objects.requireNonNull(device);
        return this.getRegistrationAssertion(device.getTenantId(), device.getDeviceId(), null, context).recover(t -> Future.failedFuture((Throwable)((Object)new RegistrationAssertionException(device.getTenantId(), "failed to assert registration status of " + device, (Throwable)t)))).mapEmpty();
    }

    protected final Future<Void> startServiceClient(Lifecycle serviceClient, String serviceName) {
        Objects.requireNonNull(serviceClient);
        Objects.requireNonNull(serviceName);
        return serviceClient.start().map(c -> {
            this.log.info("{} client [{}] successfully connected", (Object)serviceName, (Object)serviceClient);
            return c;
        }).recover(t -> {
            this.log.warn("{} client [{}] failed to connect", new Object[]{serviceName, serviceClient, t});
            return Future.failedFuture((Throwable)t);
        });
    }

    protected final Future<CommandConsumer> createCommandConsumer(String tenantId, String deviceId, Handler<CommandContext> commandConsumer, SpanContext context) {
        return this.commandConsumerFactory.createCommandConsumer(tenantId, deviceId, commandContext -> {
            Tags.COMPONENT.set(commandContext.getTracingSpan(), this.getTypeName());
            commandConsumer.handle(commandContext);
        }, null, context);
    }

    protected final Future<Void> sendCommandResponse(CommandResponse response, SpanContext context) {
        Objects.requireNonNull(response);
        return this.commandResponseSender.sendCommandResponse(response, context);
    }

    protected final Future<RegistrationAssertion> getRegistrationAssertion(String tenantId, String deviceId, Device authenticatedDevice, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Future<String> gatewayId = this.getGatewayId(tenantId, deviceId, authenticatedDevice);
        return gatewayId.compose(gwId -> this.getRegistrationClient().assertRegistration(tenantId, deviceId, gwId, context)).onSuccess(assertion -> this.updateLastGateway((RegistrationAssertion)assertion, tenantId, deviceId, authenticatedDevice, context).onFailure(t -> this.log.warn("failed to update last gateway [tenantId: {}, deviceId: {}]", new Object[]{tenantId, deviceId, t})));
    }

    @Deprecated
    protected final Future<JsonObject> updateLastGateway(JsonObject registrationAssertion, String tenantId, String deviceId, Device authenticatedDevice, SpanContext context) {
        try {
            return this.updateLastGateway((RegistrationAssertion)registrationAssertion.mapTo(RegistrationAssertion.class), tenantId, deviceId, authenticatedDevice, context).map((Object)registrationAssertion);
        }
        catch (DecodeException e) {
            return Future.failedFuture((Throwable)new ClientErrorException(400, (Throwable)e));
        }
    }

    protected final Future<RegistrationAssertion> updateLastGateway(RegistrationAssertion registrationAssertion, String tenantId, String deviceId, Device authenticatedDevice, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        if (!this.isGatewaySupportedForDevice(registrationAssertion)) {
            return Future.succeededFuture((Object)registrationAssertion);
        }
        return this.getGatewayId(tenantId, deviceId, authenticatedDevice).compose(gwId -> this.commandRouterClient.setLastKnownGatewayForDevice(tenantId, deviceId, Optional.ofNullable(gwId).orElse(deviceId), context)).map((Object)registrationAssertion);
    }

    private boolean isGatewaySupportedForDevice(RegistrationAssertion registrationAssertion) {
        return !registrationAssertion.getAuthorizedGateways().isEmpty();
    }

    private Future<String> getGatewayId(String tenantId, String deviceId, Device authenticatedDevice) {
        Promise result = Promise.promise();
        if (authenticatedDevice == null) {
            result.complete(null);
        } else if (tenantId.equals(authenticatedDevice.getTenantId())) {
            if (deviceId.equals(authenticatedDevice.getDeviceId())) {
                result.complete(null);
            } else {
                result.complete((Object)authenticatedDevice.getDeviceId());
            }
        } else {
            result.fail((Throwable)new ClientErrorException(403, "cannot publish data for device of other tenant"));
        }
        return result.future();
    }

    protected final Future<TenantObject> getTenantConfiguration(String tenantId, SpanContext context) {
        Objects.requireNonNull(tenantId);
        return this.getTenantClient().get(tenantId, context);
    }

    protected final Map<String, Object> getDownstreamMessageProperties(TelemetryExecutionContext context) {
        Map props = Objects.requireNonNull(context).getDownstreamMessageProperties();
        props.put("orig_adapter", this.getTypeName());
        return props;
    }

    @Override
    public void registerReadinessChecks(HealthCheckHandler handler) {
        if (this.commandConsumerFactory instanceof ServiceClient) {
            ((ServiceClient)this.commandConsumerFactory).registerReadinessChecks(handler);
        }
        if (this.commandResponseSender instanceof ServiceClient) {
            ((ServiceClient)this.commandResponseSender).registerReadinessChecks(handler);
        }
        if (this.tenantClient instanceof ServiceClient) {
            ((ServiceClient)this.tenantClient).registerReadinessChecks(handler);
        }
        if (this.registrationClient instanceof ServiceClient) {
            ((ServiceClient)this.registrationClient).registerReadinessChecks(handler);
        }
        if (this.credentialsClient instanceof ServiceClient) {
            ((ServiceClient)this.credentialsClient).registerReadinessChecks(handler);
        }
        if (this.commandRouterClient instanceof ServiceClient) {
            ((ServiceClient)this.commandRouterClient).registerReadinessChecks(handler);
        }
        if (this.telemetrySender instanceof ServiceClient) {
            ((ServiceClient)this.telemetrySender).registerReadinessChecks(handler);
        }
        if (this.eventSender instanceof ServiceClient) {
            ((ServiceClient)this.eventSender).registerReadinessChecks(handler);
        }
    }

    @Override
    public void registerLivenessChecks(HealthCheckHandler handler) {
        this.registerEventLoopBlockedCheck(handler);
        if (this.commandConsumerFactory instanceof ServiceClient) {
            ((ServiceClient)this.commandConsumerFactory).registerLivenessChecks(handler);
        }
        if (this.commandResponseSender instanceof ServiceClient) {
            ((ServiceClient)this.commandResponseSender).registerLivenessChecks(handler);
        }
        if (this.tenantClient instanceof ServiceClient) {
            ((ServiceClient)this.tenantClient).registerLivenessChecks(handler);
        }
        if (this.registrationClient instanceof ServiceClient) {
            ((ServiceClient)this.registrationClient).registerLivenessChecks(handler);
        }
        if (this.credentialsClient instanceof ServiceClient) {
            ((ServiceClient)this.credentialsClient).registerLivenessChecks(handler);
        }
        if (this.commandRouterClient instanceof ServiceClient) {
            ((ServiceClient)this.commandRouterClient).registerLivenessChecks(handler);
        }
        if (this.telemetrySender instanceof ServiceClient) {
            ((ServiceClient)this.telemetrySender).registerLivenessChecks(handler);
        }
        if (this.eventSender instanceof ServiceClient) {
            ((ServiceClient)this.eventSender).registerLivenessChecks(handler);
        }
    }

    protected Future<?> sendConnectedEvent(String remoteId, Device authenticatedDevice) {
        if (this.connectionEventProducer != null) {
            return this.connectionEventProducer.connected(this.connectionEventProducerContext, remoteId, this.getTypeName(), authenticatedDevice, null);
        }
        return Future.succeededFuture();
    }

    protected Future<?> sendDisconnectedEvent(String remoteId, Device authenticatedDevice) {
        if (this.connectionEventProducer != null) {
            return this.connectionEventProducer.disconnected(this.connectionEventProducerContext, remoteId, this.getTypeName(), authenticatedDevice, null);
        }
        return Future.succeededFuture();
    }

    protected final Future<?> sendConnectedTtdEvent(String tenant, String deviceId, Device authenticatedDevice, SpanContext context) {
        return this.sendTtdEvent(tenant, deviceId, authenticatedDevice, -1, context);
    }

    protected final Future<?> sendDisconnectedTtdEvent(String tenant, String deviceId, Device authenticatedDevice, SpanContext context) {
        return this.sendTtdEvent(tenant, deviceId, authenticatedDevice, 0, context);
    }

    protected final Future<?> sendTtdEvent(String tenant, String deviceId, Device authenticatedDevice, Integer ttd, SpanContext context) {
        Objects.requireNonNull(tenant);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(ttd);
        Future<RegistrationAssertion> tokenTracker = this.getRegistrationAssertion(tenant, deviceId, authenticatedDevice, context);
        Future<TenantObject> tenantConfigTracker = this.getTenantConfiguration(tenant, context);
        return CompositeFuture.all(tokenTracker, tenantConfigTracker).compose(ok -> {
            if (((TenantObject)tenantConfigTracker.result()).isAdapterEnabled(this.getTypeName())) {
                HashMap<String, Object> props = new HashMap<String, Object>();
                props.put("orig_adapter", this.getTypeName());
                props.put("qos", QoS.AT_LEAST_ONCE.ordinal());
                props.put("ttd", ttd);
                return this.getEventSender().sendEvent((TenantObject)tenantConfigTracker.result(), (RegistrationAssertion)tokenTracker.result(), "application/vnd.eclipse-hono-empty-notification", null, props, context).onSuccess(s -> this.log.debug("successfully sent TTD notification [tenant: {}, device-id: {}, TTD: {}", new Object[]{tenant, deviceId, ttd})).onFailure(t -> this.log.debug("failed to send TTD notification [tenant: {}, device-id: {}, TTD: {}", new Object[]{tenant, deviceId, ttd, t}));
            }
            return Future.failedFuture((Throwable)new ClientErrorException(403));
        });
    }

    protected boolean isPayloadOfIndicatedType(Buffer payload, String contentType) {
        if (payload == null || payload.length() == 0) {
            return "application/vnd.eclipse-hono-empty-notification".equals(contentType);
        }
        return !"application/vnd.eclipse-hono-empty-notification".equals(contentType);
    }

    protected void registerEventLoopBlockedCheck(HealthCheckHandler handler) {
        handler.register("event-loop-blocked-check", ((ProtocolAdapterProperties)this.getConfig()).getEventLoopBlockedCheckTimeout(), procedure -> {
            Context currentContext = Vertx.currentContext();
            if (currentContext != this.context) {
                this.context.runOnContext(action -> procedure.tryComplete((Object)Status.OK()));
            } else {
                this.log.debug("Protocol Adapter - HealthCheck Server context match. Assume protocol adapter is alive.");
                procedure.tryComplete((Object)Status.OK());
            }
        });
    }

    @Override
    protected TrustOptions getServerTrustOptions() {
        return Optional.ofNullable(((ProtocolAdapterProperties)this.getConfig()).getTrustOptions()).orElseGet(() -> {
            if (((ProtocolAdapterProperties)this.getConfig()).isAuthenticationRequired()) {
                return new ValidityBasedTrustOptions();
            }
            return null;
        });
    }

    public static ErrorCondition getErrorCondition(Throwable t) {
        if (t instanceof AuthorizationException) {
            return ProtonHelper.condition((Symbol)AmqpError.UNAUTHORIZED_ACCESS, (String)t.getMessage());
        }
        if (ServiceInvocationException.class.isInstance(t)) {
            ServiceInvocationException error = (ServiceInvocationException)t;
            switch (error.getErrorCode()) {
                case 400: {
                    return ProtonHelper.condition((Symbol)Constants.AMQP_BAD_REQUEST, (String)error.getMessage());
                }
                case 403: {
                    return ProtonHelper.condition((Symbol)AmqpError.UNAUTHORIZED_ACCESS, (String)error.getMessage());
                }
                case 429: {
                    return ProtonHelper.condition((Symbol)AmqpError.RESOURCE_LIMIT_EXCEEDED, (String)error.getMessage());
                }
            }
            return ProtonHelper.condition((Symbol)AmqpError.PRECONDITION_FAILED, (String)error.getMessage());
        }
        return ProtonHelper.condition((Symbol)AmqpError.PRECONDITION_FAILED, (String)t.getMessage());
    }

    public static MetricsTags.ConnectionAttemptOutcome getOutcome(Throwable e) {
        if (e instanceof AuthorizationException) {
            if (e instanceof AdapterDisabledException) {
                return MetricsTags.ConnectionAttemptOutcome.ADAPTER_DISABLED;
            }
            if (e instanceof AdapterConnectionsExceededException) {
                return MetricsTags.ConnectionAttemptOutcome.ADAPTER_CONNECTIONS_EXCEEDED;
            }
            if (e instanceof ConnectionDurationExceededException) {
                return MetricsTags.ConnectionAttemptOutcome.CONNECTION_DURATION_EXCEEDED;
            }
            if (e instanceof DataVolumeExceededException) {
                return MetricsTags.ConnectionAttemptOutcome.DATA_VOLUME_EXCEEDED;
            }
            if (e instanceof RegistrationAssertionException) {
                return MetricsTags.ConnectionAttemptOutcome.REGISTRATION_ASSERTION_FAILURE;
            }
            if (e instanceof TenantConnectionsExceededException) {
                return MetricsTags.ConnectionAttemptOutcome.TENANT_CONNECTIONS_EXCEEDED;
            }
            return MetricsTags.ConnectionAttemptOutcome.UNAUTHORIZED;
        }
        if (e instanceof ServiceInvocationException) {
            switch (((ServiceInvocationException)e).getErrorCode()) {
                case 401: {
                    return MetricsTags.ConnectionAttemptOutcome.UNAUTHORIZED;
                }
                case 503: {
                    return MetricsTags.ConnectionAttemptOutcome.UNAVAILABLE;
                }
            }
            return MetricsTags.ConnectionAttemptOutcome.UNKNOWN;
        }
        return MetricsTags.ConnectionAttemptOutcome.UNKNOWN;
    }
}

