/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.noop.NoopTracerFactory;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.adapter.client.command.CommandConsumerFactory;
import org.eclipse.hono.adapter.client.command.CommandResponseSender;
import org.eclipse.hono.adapter.client.command.CommandRouterClient;
import org.eclipse.hono.adapter.client.command.DeviceConnectionClient;
import org.eclipse.hono.adapter.client.command.DeviceConnectionClientAdapter;
import org.eclipse.hono.adapter.client.command.amqp.ProtonBasedCommandResponseSender;
import org.eclipse.hono.adapter.client.command.amqp.ProtonBasedCommandRouterClient;
import org.eclipse.hono.adapter.client.command.amqp.ProtonBasedCommandRouterCommandConsumerFactoryImpl;
import org.eclipse.hono.adapter.client.command.amqp.ProtonBasedDelegatingCommandConsumerFactory;
import org.eclipse.hono.adapter.client.command.amqp.ProtonBasedDeviceConnectionClient;
import org.eclipse.hono.adapter.client.registry.CredentialsClient;
import org.eclipse.hono.adapter.client.registry.DeviceRegistrationClient;
import org.eclipse.hono.adapter.client.registry.TenantClient;
import org.eclipse.hono.adapter.client.registry.amqp.ProtonBasedCredentialsClient;
import org.eclipse.hono.adapter.client.registry.amqp.ProtonBasedDeviceRegistrationClient;
import org.eclipse.hono.adapter.client.registry.amqp.ProtonBasedTenantClient;
import org.eclipse.hono.adapter.client.telemetry.EventSender;
import org.eclipse.hono.adapter.client.telemetry.TelemetrySender;
import org.eclipse.hono.adapter.client.telemetry.amqp.ProtonBasedDownstreamSender;
import org.eclipse.hono.cache.CacheProvider;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.RequestResponseClientConfigProperties;
import org.eclipse.hono.client.SendMessageSampler;
import org.eclipse.hono.config.ApplicationConfigProperties;
import org.eclipse.hono.config.AuthenticatingClientConfigProperties;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.config.ProtocolAdapterProperties;
import org.eclipse.hono.config.ServerConfig;
import org.eclipse.hono.config.VertxProperties;
import org.eclipse.hono.service.AbstractProtocolAdapterBase;
import org.eclipse.hono.service.AdapterConfigurationSupport;
import org.eclipse.hono.service.HealthCheckServer;
import org.eclipse.hono.service.VertxBasedHealthCheckServer;
import org.eclipse.hono.service.cache.SpringCacheProvider;
import org.eclipse.hono.service.monitoring.ConnectionEventProducer;
import org.eclipse.hono.service.monitoring.ConnectionEventProducerConfig;
import org.eclipse.hono.service.monitoring.HonoEventConnectionEventProducer;
import org.eclipse.hono.service.monitoring.LoggingConnectionEventProducer;
import org.eclipse.hono.service.resourcelimits.LimitedResource;
import org.eclipse.hono.service.resourcelimits.PrometheusBasedResourceLimitChecks;
import org.eclipse.hono.service.resourcelimits.PrometheusBasedResourceLimitChecksConfig;
import org.eclipse.hono.service.resourcelimits.ResourceLimitChecks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;

public abstract class AbstractAdapterConfig
extends AdapterConfigurationSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAdapterConfig.class);
    @Autowired
    private ApplicationContext context;

    protected void setCollaborators(AbstractProtocolAdapterBase<?> adapter, ProtocolAdapterProperties adapterProperties, SendMessageSampler.Factory samplerFactory, Optional<ResourceLimitChecks> resourceLimitChecks) {
        Objects.requireNonNull(adapter);
        Objects.requireNonNull(adapterProperties);
        Objects.requireNonNull(samplerFactory);
        DeviceRegistrationClient registrationClient = this.registrationClient(samplerFactory, adapterProperties);
        try {
            DeviceConnectionClient deviceConnectionClient = (DeviceConnectionClient)this.context.getBean(DeviceConnectionClient.class);
            adapter.setCommandRouterClient((CommandRouterClient)new DeviceConnectionClientAdapter(deviceConnectionClient));
            adapter.setCommandConsumerFactory(this.commandConsumerFactory(adapterProperties, samplerFactory, deviceConnectionClient, registrationClient));
        }
        catch (BeansException e) {
            CommandRouterClient commandRouterClient = (CommandRouterClient)this.context.getBean(CommandRouterClient.class);
            adapter.setCommandRouterClient(commandRouterClient);
            adapter.setCommandConsumerFactory(this.commandConsumerFactory(adapterProperties, samplerFactory, commandRouterClient));
        }
        adapter.setCommandResponseSender(this.commandResponseSender(samplerFactory, adapterProperties));
        Optional.ofNullable(this.connectionEventProducer()).ifPresent(adapter::setConnectionEventProducer);
        adapter.setCredentialsClient(this.credentialsClient(samplerFactory, adapterProperties));
        adapter.setEventSender(this.downstreamEventSender(samplerFactory, adapterProperties));
        adapter.setHealthCheckServer(this.healthCheckServer());
        adapter.setRegistrationClient(registrationClient);
        adapter.setTelemetrySender(this.downstreamTelemetrySender(samplerFactory, adapterProperties));
        adapter.setTenantClient(this.tenantClient(samplerFactory, adapterProperties));
        adapter.setTracer(this.getTracer());
        resourceLimitChecks.ifPresent(adapter::setResourceLimitChecks);
    }

    @Bean
    public Tracer getTracer() {
        return Optional.ofNullable(TracerResolver.resolveTracer()).orElse((Tracer)NoopTracerFactory.create());
    }

    @Bean
    public Vertx vertx() {
        return Vertx.vertx((VertxOptions)this.vertxProperties().configureVertx(new VertxOptions()));
    }

    @Bean
    @ConfigurationProperties(value="hono.connection-events")
    public ConnectionEventProducerConfig connectionEventProducerConfig() {
        return new ConnectionEventProducerConfig();
    }

    @Bean
    public ConnectionEventProducer connectionEventProducer() {
        ConnectionEventProducerConfig config = this.connectionEventProducerConfig();
        switch (config.getType()) {
            case logging: {
                return new LoggingConnectionEventProducer(config);
            }
            case events: {
                return new HonoEventConnectionEventProducer();
            }
        }
        return null;
    }

    @Qualifier(value="messaging")
    @ConfigurationProperties(prefix="hono.messaging")
    @Bean
    public ClientConfigProperties downstreamSenderConfig() {
        ClientConfigProperties config = Optional.ofNullable(this.getDownstreamSenderConfigDefaults()).orElseGet(ClientConfigProperties::new);
        AbstractAdapterConfig.setConfigServerRoleIfUnknown((AuthenticatingClientConfigProperties)config, "AMQP Messaging Network");
        this.setDefaultConfigNameIfNotSet(config);
        return config;
    }

    protected ClientConfigProperties getDownstreamSenderConfigDefaults() {
        return new ClientConfigProperties();
    }

    @Qualifier(value="messaging")
    @Bean
    @Scope(value="prototype")
    public HonoConnection downstreamConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.downstreamSenderConfig());
    }

    @Qualifier(value="telemetry")
    @Bean
    @Scope(value="prototype")
    public TelemetrySender downstreamTelemetrySender(SendMessageSampler.Factory samplerFactory, ProtocolAdapterProperties adapterConfig) {
        return new ProtonBasedDownstreamSender(this.downstreamConnection(), samplerFactory, adapterConfig);
    }

    @Qualifier(value="event")
    @Bean
    @Scope(value="prototype")
    public EventSender downstreamEventSender(SendMessageSampler.Factory samplerFactory, ProtocolAdapterProperties adapterConfig) {
        return new ProtonBasedDownstreamSender(this.downstreamConnection(), samplerFactory, adapterConfig);
    }

    @Qualifier(value="registration")
    @ConfigurationProperties(prefix="hono.registration")
    @Bean
    public RequestResponseClientConfigProperties registrationClientConfig() {
        RequestResponseClientConfigProperties config = Optional.ofNullable(this.getRegistrationClientConfigDefaults()).orElseGet(RequestResponseClientConfigProperties::new);
        AbstractAdapterConfig.setConfigServerRoleIfUnknown((AuthenticatingClientConfigProperties)config, "Device Registration");
        this.setDefaultConfigNameIfNotSet((ClientConfigProperties)config);
        return config;
    }

    protected RequestResponseClientConfigProperties getRegistrationClientConfigDefaults() {
        return new RequestResponseClientConfigProperties();
    }

    @Bean
    @Qualifier(value="registration")
    @Scope(value="prototype")
    public DeviceRegistrationClient registrationClient(SendMessageSampler.Factory samplerFactory, ProtocolAdapterProperties adapterConfig) {
        return new ProtonBasedDeviceRegistrationClient(this.registrationServiceConnection(), samplerFactory, adapterConfig, this.registrationCacheProvider());
    }

    @Bean
    @Qualifier(value="registration")
    @Scope(value="prototype")
    public HonoConnection registrationServiceConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.registrationClientConfig());
    }

    @Bean
    @Qualifier(value="registration")
    @Scope(value="prototype")
    public CacheProvider registrationCacheProvider() {
        return AbstractAdapterConfig.newCaffeineCache(this.registrationClientConfig());
    }

    @Qualifier(value="credentials")
    @ConfigurationProperties(prefix="hono.credentials")
    @Bean
    public RequestResponseClientConfigProperties credentialsClientConfig() {
        RequestResponseClientConfigProperties config = Optional.ofNullable(this.getCredentialsClientConfigDefaults()).orElseGet(RequestResponseClientConfigProperties::new);
        AbstractAdapterConfig.setConfigServerRoleIfUnknown((AuthenticatingClientConfigProperties)config, "Credentials");
        this.setDefaultConfigNameIfNotSet((ClientConfigProperties)config);
        return config;
    }

    protected RequestResponseClientConfigProperties getCredentialsClientConfigDefaults() {
        return new RequestResponseClientConfigProperties();
    }

    @Bean
    @Qualifier(value="credentials")
    @Scope(value="prototype")
    public CredentialsClient credentialsClient(SendMessageSampler.Factory samplerFactory, ProtocolAdapterProperties adapterConfig) {
        return new ProtonBasedCredentialsClient(this.credentialsServiceConnection(), samplerFactory, adapterConfig, this.credentialsCacheProvider());
    }

    @Bean
    @Qualifier(value="credentials")
    @Scope(value="prototype")
    public HonoConnection credentialsServiceConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.credentialsClientConfig());
    }

    @Bean
    @Qualifier(value="credentials")
    @Scope(value="prototype")
    public CacheProvider credentialsCacheProvider() {
        return AbstractAdapterConfig.newCaffeineCache(this.credentialsClientConfig());
    }

    @Qualifier(value="tenant")
    @ConfigurationProperties(prefix="hono.tenant")
    @Bean
    public RequestResponseClientConfigProperties tenantServiceClientConfig() {
        RequestResponseClientConfigProperties config = Optional.ofNullable(this.getTenantClientConfigDefaults()).orElseGet(RequestResponseClientConfigProperties::new);
        AbstractAdapterConfig.setConfigServerRoleIfUnknown((AuthenticatingClientConfigProperties)config, "Tenant");
        this.setDefaultConfigNameIfNotSet((ClientConfigProperties)config);
        return config;
    }

    protected RequestResponseClientConfigProperties getTenantClientConfigDefaults() {
        return new RequestResponseClientConfigProperties();
    }

    @Bean
    @Qualifier(value="tenant")
    @Scope(value="prototype")
    public TenantClient tenantClient(SendMessageSampler.Factory samplerFactory, ProtocolAdapterProperties adapterConfig) {
        return new ProtonBasedTenantClient(this.tenantServiceConnection(), samplerFactory, adapterConfig, this.tenantCacheProvider());
    }

    @Bean
    @Qualifier(value="tenant")
    @Scope(value="prototype")
    public HonoConnection tenantServiceConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.tenantServiceClientConfig());
    }

    @Bean
    @Qualifier(value="tenant")
    @Scope(value="prototype")
    public CacheProvider tenantCacheProvider() {
        return AbstractAdapterConfig.newCaffeineCache(this.tenantServiceClientConfig());
    }

    @Bean
    @Qualifier(value="device_con")
    @ConfigurationProperties(prefix="hono.device-connection")
    @ConditionalOnProperty(prefix="hono.device-connection", name={"host"})
    public RequestResponseClientConfigProperties deviceConnectionServiceClientConfig() {
        RequestResponseClientConfigProperties config = Optional.ofNullable(this.getDeviceConnectionClientFactoryConfigDefaults()).orElseGet(RequestResponseClientConfigProperties::new);
        AbstractAdapterConfig.setConfigServerRoleIfUnknown((AuthenticatingClientConfigProperties)config, "Device Connection");
        this.setDefaultConfigNameIfNotSet((ClientConfigProperties)config);
        return config;
    }

    protected RequestResponseClientConfigProperties getDeviceConnectionClientFactoryConfigDefaults() {
        return new RequestResponseClientConfigProperties();
    }

    @Bean
    @Qualifier(value="device_con")
    @Scope(value="prototype")
    @ConditionalOnProperty(prefix="hono.device-connection", name={"host"})
    public HonoConnection deviceConnectionServiceConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.deviceConnectionServiceClientConfig());
    }

    @Bean
    @Qualifier(value="device_con")
    @Scope(value="prototype")
    @ConditionalOnProperty(prefix="hono.device-connection", name={"host"})
    public DeviceConnectionClient deviceConnectionClient(SendMessageSampler.Factory samplerFactory, ProtocolAdapterProperties adapterConfig) {
        return new ProtonBasedDeviceConnectionClient(this.deviceConnectionServiceConnection(), samplerFactory, adapterConfig);
    }

    @Bean
    @Qualifier(value="cmd_router")
    @ConfigurationProperties(prefix="hono.command-router")
    @ConditionalOnProperty(prefix="hono.command-router", name={"host"})
    public RequestResponseClientConfigProperties commandRouterServiceClientConfig() {
        RequestResponseClientConfigProperties config = Optional.ofNullable(this.getCommandRouterClientConfigDefaults()).orElseGet(RequestResponseClientConfigProperties::new);
        AbstractAdapterConfig.setConfigServerRoleIfUnknown((AuthenticatingClientConfigProperties)config, "Command Router");
        this.setDefaultConfigNameIfNotSet((ClientConfigProperties)config);
        return config;
    }

    protected RequestResponseClientConfigProperties getCommandRouterClientConfigDefaults() {
        return new RequestResponseClientConfigProperties();
    }

    @Bean
    @Qualifier(value="cmd_router")
    @Scope(value="prototype")
    @ConditionalOnProperty(prefix="hono.command-router", name={"host"})
    public HonoConnection commandRouterServiceConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.commandRouterServiceClientConfig());
    }

    @Bean
    @Qualifier(value="cmd_router")
    @Scope(value="prototype")
    @ConditionalOnProperty(prefix="hono.command-router", name={"host"})
    public CommandRouterClient commandRouterClient(SendMessageSampler.Factory samplerFactory, ProtocolAdapterProperties adapterConfig) {
        return new ProtonBasedCommandRouterClient(this.commandRouterServiceConnection(), samplerFactory, adapterConfig);
    }

    @Qualifier(value="command")
    @ConfigurationProperties(prefix="hono.command")
    @Bean
    public ClientConfigProperties commandConsumerFactoryConfig() {
        ClientConfigProperties config = Optional.ofNullable(this.getCommandConsumerFactoryConfigDefaults()).orElseGet(ClientConfigProperties::new);
        AbstractAdapterConfig.setConfigServerRoleIfUnknown((AuthenticatingClientConfigProperties)config, "Command & Control");
        this.setDefaultConfigNameIfNotSet(config);
        return config;
    }

    protected ClientConfigProperties getCommandConsumerFactoryConfigDefaults() {
        return new ClientConfigProperties();
    }

    @Bean
    @Scope(value="prototype")
    public HonoConnection commandConsumerConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.commandConsumerFactoryConfig());
    }

    CommandConsumerFactory commandConsumerFactory(ProtocolAdapterProperties adapterProperties, SendMessageSampler.Factory samplerFactory, DeviceConnectionClient deviceConnectionClient, DeviceRegistrationClient registrationClient) {
        LOG.debug("using Device Connection service client, configuring CommandConsumerFactory [{}]", (Object)ProtonBasedDelegatingCommandConsumerFactory.class.getName());
        return new ProtonBasedDelegatingCommandConsumerFactory(this.commandConsumerConnection(), samplerFactory, adapterProperties, deviceConnectionClient, registrationClient, this.getTracer());
    }

    CommandConsumerFactory commandConsumerFactory(ProtocolAdapterProperties adapterProperties, SendMessageSampler.Factory samplerFactory, CommandRouterClient commandRouterClient) {
        LOG.debug("using Command Router service client, configuring CommandConsumerFactory [{}}]", (Object)ProtonBasedCommandRouterCommandConsumerFactoryImpl.class.getName());
        return new ProtonBasedCommandRouterCommandConsumerFactoryImpl(this.commandConsumerConnection(), samplerFactory, adapterProperties, commandRouterClient);
    }

    @Bean
    @Scope(value="prototype")
    public CommandResponseSender commandResponseSender(SendMessageSampler.Factory samplerFactory, ProtocolAdapterProperties adapterConfig) {
        return new ProtonBasedCommandResponseSender(this.commandConsumerConnection(), samplerFactory, adapterConfig);
    }

    @ConfigurationProperties(value="hono.vertx")
    @Bean
    public VertxProperties vertxProperties() {
        return new VertxProperties();
    }

    private static CacheProvider newCaffeineCache(RequestResponseClientConfigProperties config) {
        return AbstractAdapterConfig.newCaffeineCache(config.getResponseCacheMinSize(), config.getResponseCacheMaxSize());
    }

    private static CacheProvider newCaffeineCache(int minCacheSize, long maxCacheSize) {
        if (maxCacheSize <= 0L) {
            return null;
        }
        Caffeine caffeine = Caffeine.newBuilder().initialCapacity(minCacheSize).maximumSize(Math.max((long)minCacheSize, maxCacheSize));
        CaffeineCacheManager manager = new CaffeineCacheManager();
        manager.setAllowNullValues(false);
        manager.setCaffeine(caffeine);
        return new SpringCacheProvider((CacheManager)manager);
    }

    @Bean
    @ConfigurationProperties(prefix="hono.app")
    public ApplicationConfigProperties applicationConfigProperties() {
        return new ApplicationConfigProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hono.health-check")
    public ServerConfig healthCheckConfigProperties() {
        return new ServerConfig();
    }

    @Bean
    public HealthCheckServer healthCheckServer() {
        return new VertxBasedHealthCheckServer(this.vertx(), this.healthCheckConfigProperties());
    }

    @Bean
    @ConfigurationProperties(prefix="hono.resource-limits.prometheus-based")
    @ConditionalOnClass(name={"io.micrometer.prometheus.PrometheusMeterRegistry"})
    @ConditionalOnProperty(name={"hono.resource-limits.prometheus-based.host"})
    public PrometheusBasedResourceLimitChecksConfig resourceLimitChecksConfig() {
        return new PrometheusBasedResourceLimitChecksConfig();
    }

    @Bean
    @ConditionalOnBean(value={PrometheusBasedResourceLimitChecksConfig.class})
    public ResourceLimitChecks resourceLimitChecks() {
        PrometheusBasedResourceLimitChecksConfig config = this.resourceLimitChecksConfig();
        Objects.requireNonNull(config);
        Caffeine builder = Caffeine.newBuilder().initialCapacity(config.getCacheMinSize()).maximumSize(config.getCacheMaxSize()).expireAfterWrite(Duration.ofSeconds(config.getCacheTimeout()));
        WebClientOptions webClientOptions = new WebClientOptions();
        webClientOptions.setDefaultHost(config.getHost());
        webClientOptions.setDefaultPort(config.getPort());
        webClientOptions.setTrustOptions(config.getTrustOptions());
        webClientOptions.setKeyCertOptions(config.getKeyCertOptions());
        webClientOptions.setSsl(config.isTlsEnabled());
        return new PrometheusBasedResourceLimitChecks(WebClient.create((Vertx)this.vertx(), (WebClientOptions)webClientOptions), config, (AsyncCache<String, LimitedResource<Long>>)builder.buildAsync(), (AsyncCache<String, LimitedResource<Duration>>)builder.buildAsync(), (AsyncCache<String, LimitedResource<Long>>)builder.buildAsync(), this.getTracer());
    }
}

