/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.monitoring;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.service.monitoring.ConnectionEventProducer;
import org.eclipse.hono.service.monitoring.ConnectionEventProducerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggingConnectionEventProducer
implements ConnectionEventProducer {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingConnectionEventProducer.class);
    private final ConnectionEventProducerConfig config;

    public LoggingConnectionEventProducer(ConnectionEventProducerConfig config) {
        this.config = Objects.requireNonNull(config);
    }

    @Override
    public Future<?> connected(ConnectionEventProducer.Context context, String remoteId, String protocolAdapter, Device authenticatedDevice, JsonObject data) {
        return this.log(String.format("   Connected - ID: %s, Protocol Adapter: %s, Device: %s, Data: %s", remoteId, protocolAdapter, authenticatedDevice, data));
    }

    @Override
    public Future<?> disconnected(ConnectionEventProducer.Context context, String remoteId, String protocolAdapter, Device authenticatedDevice, JsonObject data) {
        return this.log(String.format("Disconnected - ID: %s, Protocol Adapter: %s, Device: %s, Data: %s", remoteId, protocolAdapter, authenticatedDevice, data));
    }

    private Future<?> log(String msg) {
        if (this.config.isDebugLogLevel()) {
            LOG.debug(msg);
        } else {
            LOG.info(msg);
        }
        return Future.succeededFuture();
    }

    public String toString() {
        return String.format("Log4j based implementation logging at %s level", this.config.getLogLevel());
    }
}

