/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.monitoring;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.function.BiFunction;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.DownstreamSender;
import org.eclipse.hono.client.DownstreamSenderFactory;
import org.eclipse.hono.client.TenantClientFactory;
import org.eclipse.hono.service.monitoring.ConnectionEventProducer;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.QoS;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.TenantObject;

public abstract class AbstractMessageSenderConnectionEventProducer
implements ConnectionEventProducer {
    private final BiFunction<DownstreamSenderFactory, String, Future<DownstreamSender>> messageSenderSource;

    protected AbstractMessageSenderConnectionEventProducer(BiFunction<DownstreamSenderFactory, String, Future<DownstreamSender>> messageSenderSource) {
        Objects.requireNonNull(messageSenderSource);
        this.messageSenderSource = messageSenderSource;
    }

    @Override
    public Future<?> connected(ConnectionEventProducer.Context context, String remoteId, String protocolAdapter, Device authenticatedDevice, JsonObject data) {
        return this.sendNotificationEvent(context, authenticatedDevice, protocolAdapter, remoteId, "connected", data);
    }

    @Override
    public Future<?> disconnected(ConnectionEventProducer.Context context, String remoteId, String protocolAdapter, Device authenticatedDevice, JsonObject data) {
        return this.sendNotificationEvent(context, authenticatedDevice, protocolAdapter, remoteId, "disconnected", data);
    }

    private Future<?> sendNotificationEvent(ConnectionEventProducer.Context context, Device authenticatedDevice, String protocolAdapter, String remoteId, String cause, JsonObject data) {
        if (authenticatedDevice == null) {
            return Future.succeededFuture();
        }
        String tenantId = authenticatedDevice.getTenantId();
        String deviceId = authenticatedDevice.getDeviceId();
        Future<TenantObject> tenantObject = this.getTenant(context.getTenantClientFactory(), tenantId);
        Future<DownstreamSender> downstreamSender = this.getOrCreateSender(context.getMessageSenderClient(), tenantId);
        return CompositeFuture.all(tenantObject, downstreamSender).map((Object)((TenantObject)tenantObject.result())).map(tenant -> {
            JsonObject payload = new JsonObject();
            payload.put("cause", cause);
            payload.put("remote-id", remoteId);
            payload.put("source", protocolAdapter);
            if (data != null) {
                payload.put("data", data);
            }
            ResourceIdentifier target = ResourceIdentifier.from((String)"event", (String)tenantId, (String)deviceId);
            return MessageHelper.newMessage((QoS)QoS.AT_LEAST_ONCE, (ResourceIdentifier)target, (String)"application/vnd.eclipse-hono-dc-notification+json", (Buffer)payload.toBuffer(), (TenantObject)tenant, null, (String)protocolAdapter);
        }).compose(msg -> ((DownstreamSender)downstreamSender.result()).send(msg));
    }

    private Future<TenantObject> getTenant(TenantClientFactory factory, String tenant) {
        return factory.getOrCreateTenantClient().compose(client -> client.get(tenant));
    }

    private Future<DownstreamSender> getOrCreateSender(DownstreamSenderFactory messageSenderClient, String tenant) {
        return this.messageSenderSource.apply(messageSenderClient, tenant);
    }
}

