/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.impl.AuthHandlerImpl;
import io.vertx.ext.web.handler.impl.HttpStatusException;
import java.security.cert.Certificate;
import java.util.Objects;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.eclipse.hono.service.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.service.auth.device.SubjectDnCredentials;
import org.eclipse.hono.service.auth.device.X509Authentication;
import org.eclipse.hono.service.http.AuthHandlerTools;
import org.eclipse.hono.service.http.TracingHandler;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509AuthHandler
extends AuthHandlerImpl {
    private static final Logger LOG = LoggerFactory.getLogger(X509AuthHandler.class);
    private static final HttpStatusException UNAUTHORIZED = new HttpStatusException(401);
    private final X509Authentication auth;
    private final Tracer tracer;

    public X509AuthHandler(X509Authentication clientAuth, DeviceCredentialsAuthProvider<SubjectDnCredentials> authProvider, Tracer tracer) {
        super(authProvider);
        this.auth = Objects.requireNonNull(clientAuth);
        this.tracer = tracer;
    }

    public final void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(handler);
        if (context.request().isSSL()) {
            try {
                Certificate[] path = context.request().sslSession().getPeerCertificates();
                this.auth.validateClientCertificate(path, TracingHandler.serverSpanContext(context)).onComplete(ar -> {
                    if (ar.succeeded()) {
                        TracingHelper.injectSpanContext((Tracer)this.tracer, (SpanContext)TracingHandler.serverSpanContext(context), (JsonObject)((JsonObject)ar.result()));
                    }
                    handler.handle(ar);
                });
            }
            catch (SSLPeerUnverifiedException e) {
                LOG.debug("could not retrieve client certificate from request: {}", (Object)e.getMessage());
                handler.handle((Object)Future.failedFuture((Throwable)UNAUTHORIZED));
            }
        } else {
            handler.handle((Object)Future.failedFuture((Throwable)UNAUTHORIZED));
        }
    }

    protected void processException(RoutingContext ctx, Throwable exception) {
        if (ctx.response().ended()) {
            return;
        }
        AuthHandlerTools.processException(ctx, exception, null);
    }
}

