/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.DecodeException;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.CorsHandler;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.AbstractEndpoint;
import org.eclipse.hono.service.http.HttpEndpoint;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractHttpEndpoint<T extends ServiceConfigProperties>
extends AbstractEndpoint
implements HttpEndpoint {
    protected static final String KEY_REQUEST_BODY = "KEY_REQUEST_BODY";
    protected static final String PARAM_TENANT_ID = "tenant_id";
    protected static final String PARAM_DEVICE_ID = "device_id";
    protected static final String KEY_RESOURCE_VERSION = "KEY_RESOURCE_VERSION";
    protected static final Function<String, Integer> CONVERTER_INT = s -> {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("value is not a an integer");
        }
    };
    protected T config;

    public AbstractHttpEndpoint(Vertx vertx) {
        super(vertx);
    }

    @Qualifier(value="http")
    @Autowired(required=false)
    public final void setConfiguration(T props) {
        this.config = (ServiceConfigProperties)Objects.requireNonNull(props);
    }

    protected final void extractRequiredJson(RoutingContext ctx, Function<RoutingContext, Object> payloadExtractor) {
        Objects.requireNonNull(payloadExtractor);
        MIMEHeader contentType = ctx.parsedHeaders().contentType();
        if (contentType == null) {
            ctx.fail((Throwable)new ClientErrorException(400, "Missing Content-Type header"));
        } else if (!"application/json".equalsIgnoreCase(contentType.value())) {
            ctx.fail((Throwable)new ClientErrorException(400, "Unsupported Content-Type"));
        } else {
            try {
                if (ctx.getBody() != null) {
                    Object payload = payloadExtractor.apply(ctx);
                    if (payload != null) {
                        ctx.put(KEY_REQUEST_BODY, payload);
                        ctx.next();
                    } else {
                        ctx.fail((Throwable)new ClientErrorException(400, "Null body"));
                    }
                } else {
                    ctx.fail((Throwable)new ClientErrorException(400, "Empty body"));
                }
            }
            catch (DecodeException e) {
                ctx.fail((Throwable)new ClientErrorException(400, "Invalid JSON", (Throwable)e));
            }
        }
    }

    protected final void extractRequiredJsonPayload(RoutingContext ctx) {
        this.extractRequiredJson(ctx, RoutingContext::getBodyAsJson);
    }

    protected final void extractOptionalJsonPayload(RoutingContext ctx) {
        if (ctx.getBody() == null || ctx.getBody().length() == 0) {
            ctx.next();
        } else {
            this.extractRequiredJson(ctx, RoutingContext::getBodyAsJson);
        }
    }

    protected final void extractRequiredJsonArrayPayload(RoutingContext ctx) {
        this.extractRequiredJson(ctx, body -> body.getBodyAsJsonArray());
    }

    protected final String getTenantParam(RoutingContext ctx) {
        return ctx.request().params().get(PARAM_TENANT_ID);
    }

    protected final String getDeviceIdParam(RoutingContext ctx) {
        return ctx.request().params().get(PARAM_DEVICE_ID);
    }

    protected final Future<String> getRequestParameter(RoutingContext ctx, String paramName, Predicate<String> validator) {
        return this.getRequestParameter(ctx, paramName, null, s -> s, validator);
    }

    protected final <C> Future<C> getRequestParameter(RoutingContext ctx, String paramName, C defaultValue, Function<String, C> converter, Predicate<C> validator) {
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(paramName);
        Objects.requireNonNull(converter);
        Objects.requireNonNull(validator);
        Promise result = Promise.promise();
        String value = ctx.request().params().get(paramName);
        try {
            C typedValue = Optional.ofNullable(value).map(converter).orElse(defaultValue);
            if (validator.test(typedValue)) {
                result.complete(typedValue);
            } else {
                result.fail((Throwable)new ClientErrorException(400, String.format("request parameter [name: %s, value: %s] failed validation", paramName, value)));
            }
        }
        catch (IllegalArgumentException e) {
            result.fail((Throwable)new ClientErrorException(400, String.format("request parameter [name: %s, value: %s] failed validation: %s", paramName, value, e.getMessage()), (Throwable)e));
        }
        return result.future();
    }

    protected final void failRequest(RoutingContext ctx, Throwable error, Span span) {
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(error);
        Objects.requireNonNull(span);
        String msg = "error processing request";
        this.logger.debug("error processing request", error);
        TracingHelper.logError((Span)span, (String)"error processing request", (Throwable)error);
        Tags.HTTP_STATUS.set(span, Integer.valueOf(ServiceInvocationException.extractStatusCode((Throwable)error)));
        ctx.fail(error);
    }

    protected void extractIfMatchVersionParam(RoutingContext ctx) {
        String ifMatchHeader = ctx.request().getHeader(HttpHeaders.IF_MATCH);
        if (!Strings.isNullOrEmpty((Object)ifMatchHeader)) {
            ctx.put(KEY_RESOURCE_VERSION, (Object)ifMatchHeader);
        }
        ctx.next();
    }

    protected final CorsHandler createDefaultCorsHandler(String allowedOrigin) {
        return this.createCorsHandler(allowedOrigin, EnumSet.of(HttpMethod.POST, HttpMethod.GET, HttpMethod.PUT, HttpMethod.DELETE));
    }

    protected final CorsHandler createCorsHandler(String allowedOrigin, Set<HttpMethod> methods) {
        return CorsHandler.create((String)allowedOrigin).allowedMethods(methods).allowedHeader(HttpHeaders.CONTENT_TYPE.toString()).allowedHeader(HttpHeaders.AUTHORIZATION.toString()).allowedHeader(HttpHeaders.IF_MATCH.toString()).exposedHeader(HttpHeaders.ETAG.toString());
    }
}

