/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import java.util.Objects;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.Lifecycle;
import org.eclipse.hono.service.http.AbstractHttpEndpoint;

public abstract class AbstractDelegatingHttpEndpoint<S, T extends ServiceConfigProperties>
extends AbstractHttpEndpoint<T> {
    protected S service;

    public AbstractDelegatingHttpEndpoint(Vertx vertx, S service) {
        super(vertx);
        Objects.requireNonNull(service);
        this.logger.debug("using service instance: {}", service);
        this.service = service;
    }

    protected final S getService() {
        return this.service;
    }

    @Override
    protected void doStart(Promise<Void> startPromise) {
        if (this.service instanceof Lifecycle) {
            ((Lifecycle)this.service).start().onComplete(startPromise);
        } else {
            startPromise.complete();
        }
    }

    @Override
    protected void doStop(Promise<Void> stopPromise) {
        if (this.service instanceof Lifecycle) {
            ((Lifecycle)this.service).stop().onComplete(stopPromise);
        } else {
            stopPromise.complete();
        }
    }
}

