/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.metric;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.util.Hostnames;
import org.eclipse.hono.util.Strings;

public final class MetricsTags {
    static final String TAG_COMPONENT_NAME = "component-name";
    static final String TAG_HOST = "host";
    static final String TAG_TENANT = "tenant";
    static final String TAG_TYPE = "type";

    private MetricsTags() {
    }

    public static Tags forProtocolAdapter(String name) {
        return Tags.of((Tag[])new Tag[]{Tag.of((String)TAG_HOST, (String)Hostnames.getHostname()), ComponentType.ADAPTER.asTag(), Tag.of((String)TAG_COMPONENT_NAME, (String)name)});
    }

    public static Tags forService(String name) {
        return Tags.of((Tag[])new Tag[]{Tag.of((String)TAG_HOST, (String)Hostnames.getHostname()), ComponentType.SERVICE.asTag(), Tag.of((String)TAG_COMPONENT_NAME, (String)name)});
    }

    public static Tag getTenantTag(String tenant) {
        return Tag.of((String)TAG_TENANT, (String)(Strings.isNullOrEmpty((Object)tenant) ? "UNKNOWN" : tenant));
    }

    public static enum Direction {
        ONE_WAY("one-way"),
        REQUEST("request"),
        RESPONSE("response");

        static final String TAG_NAME = "direction";
        private final Tag tag;

        private Direction(String tagValue) {
            this.tag = Tag.of((String)TAG_NAME, (String)tagValue);
        }

        public Tag asTag() {
            return this.tag;
        }
    }

    public static enum QoS {
        UNKNOWN("unknown"),
        AT_MOST_ONCE("0"),
        AT_LEAST_ONCE("1");

        static final String TAG_NAME = "qos";
        private Tag tag;

        private QoS() {
            this.tag = null;
        }

        private QoS(String tagValue) {
            this.tag = Tag.of((String)TAG_NAME, (String)tagValue);
        }

        public static QoS from(int level) {
            switch (level) {
                case 0: {
                    return AT_MOST_ONCE;
                }
                case 1: {
                    return AT_LEAST_ONCE;
                }
            }
            return UNKNOWN;
        }

        public Tag asTag() {
            return this.tag;
        }
    }

    public static enum TtdStatus {
        NONE("none"),
        EXPIRED("expired"),
        COMMAND("command");

        static final String TAG_NAME = "ttd";
        private final Tag tag;

        private TtdStatus() {
            this.tag = null;
        }

        private TtdStatus(String tagValue) {
            this.tag = Tag.of((String)TAG_NAME, (String)tagValue);
        }

        public Tag asTag() {
            return this.tag;
        }
    }

    public static enum ProcessingOutcome {
        FORWARDED("forwarded"),
        UNDELIVERABLE("undeliverable"),
        UNPROCESSABLE("unprocessable");

        static final String TAG_NAME = "status";
        private final Tag tag;

        private ProcessingOutcome(String tagValue) {
            this.tag = Tag.of((String)TAG_NAME, (String)tagValue);
        }

        public static ProcessingOutcome from(Throwable t) {
            if (t instanceof ClientErrorException) {
                return UNPROCESSABLE;
            }
            return UNDELIVERABLE;
        }

        public Tag asTag() {
            return this.tag;
        }
    }

    public static enum ComponentType {
        SERVICE,
        ADAPTER;

        static final String TAG_NAME = "component-type";
        private final Tag tag = Tag.of((String)"component-type", (String)this.name().toLowerCase());

        public Tag asTag() {
            return this.tag;
        }
    }

    public static enum EndpointType {
        TELEMETRY("telemetry"),
        EVENT("event"),
        COMMAND("command"),
        COMMAND_RESPONSE("command_response"),
        UNKNOWN("unknown");

        static final String TAG_NAME = "type";
        private final String canonicalName;
        private final Tag tag;

        private EndpointType(String canonicalName) {
            this.canonicalName = canonicalName;
            this.tag = Tag.of((String)"type", (String)canonicalName);
        }

        public Tag asTag() {
            return this.tag;
        }

        public String getCanonicalName() {
            return this.canonicalName;
        }

        public static EndpointType fromString(String name) {
            switch (name) {
                case "telemetry": 
                case "t": {
                    return TELEMETRY;
                }
                case "event": 
                case "e": {
                    return EVENT;
                }
                case "command": 
                case "c": {
                    return COMMAND;
                }
                case "command_response": {
                    return COMMAND_RESPONSE;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum ConnectionAttemptOutcome {
        ADAPTER_CONNECTIONS_EXCEEDED("adapter-connections-exceeded"),
        ADAPTER_DISABLED("adapter-disabled"),
        CONNECTION_DURATION_EXCEEDED("connection-duration-exceeded"),
        DATA_VOLUME_EXCEEDED("data-volume-exceeded"),
        REGISTRATION_ASSERTION_FAILURE("registration-assertion-failure"),
        SUCCEEDED("succeeded"),
        TENANT_CONNECTIONS_EXCEEDED("tenant-connections-exceeded"),
        UNAUTHORIZED("unauthorized"),
        UNAVAILABLE("unavailable"),
        UNKNOWN("unknown");

        static final String TAG_NAME = "outcome";
        private final Tag tag;

        private ConnectionAttemptOutcome(String tagValue) {
            this.tag = Tag.of((String)TAG_NAME, (String)tagValue);
        }

        public Tag asTag() {
            return this.tag;
        }
    }
}

