/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.opentracing.SpanContext;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.service.auth.DeviceUser;
import org.eclipse.hono.service.metric.MetricsTags;
import org.eclipse.hono.util.QoS;
import org.eclipse.hono.util.Strings;
import org.eclipse.hono.util.TelemetryExecutionContext;

public final class HttpContext
implements TelemetryExecutionContext {
    private final RoutingContext routingContext;
    private SpanContext spanContext;

    private HttpContext(RoutingContext routingContext) {
        this.routingContext = Objects.requireNonNull(routingContext);
    }

    public static HttpContext from(RoutingContext routingContext) {
        return new HttpContext(routingContext);
    }

    public RoutingContext getRoutingContext() {
        return this.routingContext;
    }

    public <T> T get(String key) {
        return (T)this.routingContext.get(key);
    }

    public <T> T get(String key, T defaultValue) {
        Object value = this.routingContext.get(key);
        return (T)(value != null ? value : defaultValue);
    }

    public void put(String key, Object value) {
        this.routingContext.put(key, value);
    }

    public void setTracingContext(SpanContext spanContext) {
        this.spanContext = spanContext;
    }

    public SpanContext getTracingContext() {
        return this.spanContext;
    }

    public QoS getRequestedQos() {
        int qosLevel;
        String qos = this.routingContext.request().getHeader("QoS-Level");
        if (Strings.isNullOrEmpty((Object)qos)) {
            return QoS.AT_MOST_ONCE;
        }
        try {
            qosLevel = Integer.parseInt(qos);
        }
        catch (NumberFormatException e) {
            return QoS.UNKNOWN;
        }
        switch (qosLevel) {
            case 0: {
                return QoS.AT_MOST_ONCE;
            }
            case 1: {
                return QoS.AT_LEAST_ONCE;
            }
        }
        return QoS.UNKNOWN;
    }

    public HttpServerRequest request() {
        return this.routingContext.request();
    }

    public HttpServerResponse response() {
        return this.routingContext.response();
    }

    public void fail(Throwable throwable) {
        this.routingContext.fail(throwable);
    }

    public String getContentType() {
        return this.routingContext.parsedHeaders().contentType().value();
    }

    public Duration getTimeToLive() {
        try {
            return Optional.ofNullable(this.routingContext.request().getHeader("hono-ttl")).map(ttlInHeader -> Long.parseLong(ttlInHeader)).map(ttl -> Duration.ofSeconds(ttl)).orElse(Optional.ofNullable(this.routingContext.request().getParam("hono-ttl")).map(ttlInParam -> Long.parseLong(ttlInParam)).map(ttl -> Duration.ofSeconds(ttl)).orElse(null));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Device getAuthenticatedDevice() {
        return Optional.ofNullable(this.routingContext.user()).map(user -> {
            if (DeviceUser.class.isInstance(user)) {
                return (Device)user;
            }
            return null;
        }).orElse(null);
    }

    public Integer getTimeTillDisconnect() {
        try {
            Optional<String> timeTilDisconnectHeader = Optional.ofNullable(this.request().getHeader("hono-ttd"));
            if (timeTilDisconnectHeader.isEmpty()) {
                timeTilDisconnectHeader = Optional.ofNullable(this.request().getParam("hono-ttd"));
            }
            if (timeTilDisconnectHeader.isPresent()) {
                return Integer.parseInt(timeTilDisconnectHeader.get());
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public MetricsTags.TtdStatus getTtdStatus() {
        return Optional.ofNullable((MetricsTags.TtdStatus)((Object)this.routingContext.get(MetricsTags.TtdStatus.class.getName()))).orElse(MetricsTags.TtdStatus.NONE);
    }
}

