/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.service.auth.DeviceUser;
import org.eclipse.hono.service.auth.device.AuthHandler;
import org.eclipse.hono.service.auth.device.DeviceCredentialsAuthProvider;
import org.eclipse.hono.util.ExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutionContextAuthHandler<T extends ExecutionContext>
implements AuthHandler<T> {
    public static final String PROPERTY_CLIENT_IDENTIFIER = "client-id";
    static final String AUTH_PROVIDER_CONTEXT_KEY = ExecutionContextAuthHandler.class.getName() + ".provider";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DeviceCredentialsAuthProvider<?> authProvider;

    protected ExecutionContextAuthHandler(DeviceCredentialsAuthProvider<?> authProvider) {
        this.authProvider = authProvider;
    }

    @Override
    public final DeviceCredentialsAuthProvider<?> getAuthProvider() {
        return this.authProvider;
    }

    @Override
    public Future<DeviceUser> authenticateDevice(T context) {
        Objects.requireNonNull(context);
        return this.parseCredentials(context).compose(authInfo -> {
            Promise authResult = Promise.promise();
            this.getAuthProvider(context).authenticate((JsonObject)authInfo, (ExecutionContext)context, (Handler<AsyncResult<DeviceUser>>)authResult);
            return authResult.future();
        });
    }

    private DeviceCredentialsAuthProvider<?> getAuthProvider(T ctx) {
        Object obj = ctx.get(AUTH_PROVIDER_CONTEXT_KEY);
        if (obj instanceof DeviceCredentialsAuthProvider) {
            this.log.debug("using auth provider found in context [type: {}]", (Object)obj.getClass().getName());
            return (DeviceCredentialsAuthProvider)obj;
        }
        return this.authProvider;
    }
}

