/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.ReplyException;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import org.eclipse.hono.auth.Authorities;
import org.eclipse.hono.auth.AuthoritiesImpl;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.StatusCodeMapper;
import org.eclipse.hono.service.auth.AbstractHonoAuthenticationService;
import org.eclipse.hono.service.auth.AuthTokenHelper;
import org.eclipse.hono.service.auth.AuthenticationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventBusAuthenticationService
implements AuthenticationService {
    private static final int AUTH_REQUEST_TIMEOUT_MILLIS = 3000;
    private final Logger log = LoggerFactory.getLogger(EventBusAuthenticationService.class);
    private final Vertx vertx;
    private final AuthTokenHelper tokenValidator;
    private final String[] supportedSASLMechanisms;

    public EventBusAuthenticationService(Vertx vertx, AuthTokenHelper validator) {
        this(vertx, validator, AbstractHonoAuthenticationService.DEFAULT_SASL_MECHANISMS);
    }

    public EventBusAuthenticationService(Vertx vertx, AuthTokenHelper validator, String[] supportedSASLMechanisms) {
        this.vertx = Objects.requireNonNull(vertx);
        this.tokenValidator = Objects.requireNonNull(validator);
        this.supportedSASLMechanisms = Objects.requireNonNull(supportedSASLMechanisms);
    }

    @Override
    public String[] getSupportedSaslMechanisms() {
        return this.supportedSASLMechanisms;
    }

    @Override
    public void authenticate(JsonObject authRequest, Handler<AsyncResult<HonoUser>> authenticationResultHandler) {
        DeliveryOptions options = new DeliveryOptions().setSendTimeout(3000L);
        this.vertx.eventBus().request("authentication.in", (Object)authRequest, options, reply -> {
            if (reply.succeeded()) {
                JsonObject result = (JsonObject)((Message)reply.result()).body();
                String token = result.getString("token");
                this.log.debug("received token [length: {}] in response to authentication request", (Object)token.length());
                try {
                    Jws<Claims> expandedToken = this.tokenValidator.expand(result.getString("token"));
                    authenticationResultHandler.handle((Object)Future.succeededFuture((Object)new HonoUserImpl(expandedToken, token)));
                }
                catch (JwtException e) {
                    authenticationResultHandler.handle((Object)Future.failedFuture((Throwable)new ServerErrorException(500, (Throwable)e)));
                }
            } else {
                ServerErrorException resultException;
                if (reply.cause() instanceof ReplyException) {
                    switch (((ReplyException)reply.cause()).failureType()) {
                        case TIMEOUT: {
                            this.log.debug("timeout processing authentication request", reply.cause());
                            resultException = new ServerErrorException(503, reply.cause());
                            break;
                        }
                        case NO_HANDLERS: {
                            this.log.debug("could not process authentication request", reply.cause());
                            resultException = new ServerErrorException(500, reply.cause());
                            break;
                        }
                        case RECIPIENT_FAILURE: {
                            int statusCode = ((ReplyException)reply.cause()).failureCode();
                            if (statusCode < 400 || statusCode >= 600) {
                                this.log.error("got illegal status code in authentication response exception: {}", (Object)statusCode);
                                resultException = new ServerErrorException(500, reply.cause().getMessage());
                                break;
                            }
                            resultException = StatusCodeMapper.from((int)statusCode, (String)reply.cause().getMessage());
                            break;
                        }
                        default: {
                            resultException = new ServerErrorException(500, reply.cause());
                            break;
                        }
                    }
                } else {
                    resultException = new ServerErrorException(500, reply.cause());
                }
                authenticationResultHandler.handle((Object)Future.failedFuture((Throwable)resultException));
            }
        });
    }

    public static final class HonoUserImpl
    implements HonoUser {
        private static Duration expirationLeeway = Duration.ofMinutes(2L);
        private final String token;
        private final Jws<Claims> expandedToken;
        private final Authorities authorities;

        private HonoUserImpl(Jws<Claims> expandedToken, String token) {
            Objects.requireNonNull(expandedToken);
            Objects.requireNonNull(token);
            if (expandedToken.getBody() == null) {
                throw new IllegalArgumentException("token has no claims");
            }
            this.token = token;
            this.expandedToken = expandedToken;
            this.authorities = AuthoritiesImpl.from((Claims)((Claims)expandedToken.getBody()));
        }

        public String getName() {
            return ((Claims)this.expandedToken.getBody()).getSubject();
        }

        public Authorities getAuthorities() {
            return this.authorities;
        }

        public String getToken() {
            return this.token;
        }

        public boolean isExpired() {
            return !Instant.now().isBefore(this.getExpirationTime().plus(expirationLeeway));
        }

        public Instant getExpirationTime() {
            return ((Claims)this.expandedToken.getBody()).getExpiration().toInstant();
        }
    }
}

