/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.monitoring;

import java.util.Objects;

public final class ConnectionEventProducerConfig {
    public static final String DEFAULT_LOG_LEVEL = "info";
    public static final ConnectionEventProducerType DEFAULT_TYPE = ConnectionEventProducerType.logging;
    private ConnectionEventProducerType type = DEFAULT_TYPE;
    private String logLevel = "info";
    private boolean debugLogLevel = false;

    public void setProducer(ConnectionEventProducerType type) {
        this.type = Objects.requireNonNull(type);
    }

    public ConnectionEventProducerType getType() {
        return this.type;
    }

    public void setLogLevel(String level) {
        String levelToUse;
        Objects.requireNonNull(level);
        switch (levelToUse = level.toLowerCase()) {
            case "debug": {
                this.debugLogLevel = true;
            }
            case "info": {
                this.logLevel = levelToUse;
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported log level");
            }
        }
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public boolean isDebugLogLevel() {
        return this.debugLogLevel;
    }

    public static enum ConnectionEventProducerType {
        none,
        logging,
        events;


        public static ConnectionEventProducerType from(String name) {
            String nameToCheck = Objects.requireNonNull(name).toLowerCase();
            for (ConnectionEventProducerType type : ConnectionEventProducerType.values()) {
                if (!type.name().equals(nameToCheck)) continue;
                return type;
            }
            return none;
        }
    }
}

