/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.limiting;

import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.hono.config.ProtocolAdapterProperties;
import org.eclipse.hono.service.limiting.ConnectionLimitAutoConfigException;
import org.eclipse.hono.service.limiting.ConnectionLimitManager;
import org.eclipse.hono.service.limiting.ConnectionLimitStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConnectionLimitManager
implements ConnectionLimitManager {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultConnectionLimitManager.class);
    private final ConnectionLimitStrategy strategy;
    private final Supplier<Integer> currentConnections;
    private final int limit;

    public DefaultConnectionLimitManager(ConnectionLimitStrategy strategy, Supplier<Integer> currentConnections, ProtocolAdapterProperties config) {
        this.strategy = Objects.requireNonNull(strategy);
        this.currentConnections = Objects.requireNonNull(currentConnections);
        this.limit = config == null || !config.isConnectionLimitConfigured() ? this.autoconfigureConnectionLimit() : this.checkConnectionLimit(config.getMaxConnections());
    }

    private int autoconfigureConnectionLimit() {
        int recommendedLimit = this.strategy.getRecommendedLimit();
        if (recommendedLimit == 0) {
            throw new ConnectionLimitAutoConfigException("The connection limit would be auto-configured to 0 (based on " + this.strategy.getResourcesDescription() + "). To override this check, configure a connection limit.");
        }
        LOG.info("Setting connection limit to {} (based on {})", (Object)recommendedLimit, (Object)this.strategy.getResourcesDescription());
        return recommendedLimit;
    }

    private int checkConnectionLimit(int configuredLimit) {
        int recommendedLimit = this.strategy.getRecommendedLimit();
        if (configuredLimit > recommendedLimit) {
            LOG.warn("Configured connection limit {} is too high: Recommended is maximum {} (based on {})", new Object[]{configuredLimit, recommendedLimit, this.strategy.getResourcesDescription()});
        } else {
            LOG.debug("Configured connection limit: {}", (Object)configuredLimit);
        }
        return configuredLimit;
    }

    @Override
    public boolean isLimitExceeded() {
        boolean exceeded;
        boolean bl = exceeded = this.currentConnections.get() >= this.limit;
        if (exceeded) {
            LOG.debug("Connection limit ({}) exceeded", (Object)this.limit);
        }
        return exceeded;
    }
}

