/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import java.util.HashMap;
import java.util.Map;

public interface WebSpanDecorator {
    public void onRequest(HttpServerRequest var1, Span var2);

    public void onReroute(HttpServerRequest var1, Span var2);

    public void onResponse(HttpServerRequest var1, Span var2);

    public void onFailure(Throwable var1, HttpServerResponse var2, Span var3);

    public static class StandardTags
    implements WebSpanDecorator {
        @Override
        public void onRequest(HttpServerRequest request, Span span) {
            Tags.COMPONENT.set(span, "vertx");
            Tags.HTTP_METHOD.set(span, request.method().toString());
            Tags.HTTP_URL.set(span, request.absoluteURI());
        }

        @Override
        public void onReroute(HttpServerRequest request, Span span) {
            HashMap<String, String> logs = new HashMap<String, String>(2);
            logs.put("event", "reroute");
            logs.put(Tags.HTTP_URL.getKey(), request.absoluteURI());
            logs.put(Tags.HTTP_METHOD.getKey(), request.method().toString());
            span.log(logs);
        }

        @Override
        public void onResponse(HttpServerRequest request, Span span) {
            Tags.HTTP_STATUS.set(span, Integer.valueOf(request.response().getStatusCode()));
        }

        @Override
        public void onFailure(Throwable throwable, HttpServerResponse response, Span span) {
            Tags.ERROR.set(span, Boolean.TRUE);
            if (throwable != null) {
                span.log(StandardTags.exceptionLogs(throwable));
            }
        }

        public static Map<String, Object> exceptionLogs(Throwable throwable) {
            HashMap<String, Object> errorLog = new HashMap<String, Object>(2);
            errorLog.put("event", Tags.ERROR.getKey());
            errorLog.put("error.object", throwable);
            return errorLog;
        }
    }
}

