/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.opentracing.SpanContext;
import io.vertx.core.Future;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.RoutingContext;
import java.util.Base64;
import java.util.Objects;
import javax.net.ssl.SSLSession;
import org.eclipse.hono.client.TenantClientFactory;
import org.eclipse.hono.config.ProtocolAdapterProperties;
import org.eclipse.hono.service.BaseExecutionContextTenantAndAuthIdProvider;
import org.eclipse.hono.service.http.HttpContext;
import org.eclipse.hono.util.TenantObjectWithAuthId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpContextTenantAndAuthIdProvider
extends BaseExecutionContextTenantAndAuthIdProvider<HttpContext> {
    private static final Logger LOG = LoggerFactory.getLogger(HttpContextTenantAndAuthIdProvider.class);
    private final String tenantIdContextParamName;
    private final String deviceIdContextParamName;

    public HttpContextTenantAndAuthIdProvider(ProtocolAdapterProperties config, TenantClientFactory tenantClientFactory) {
        super(config, tenantClientFactory);
        this.tenantIdContextParamName = null;
        this.deviceIdContextParamName = null;
    }

    public HttpContextTenantAndAuthIdProvider(ProtocolAdapterProperties config, TenantClientFactory tenantClientFactory, String tenantIdContextParamName, String deviceIdContextParamName) {
        super(config, tenantClientFactory);
        this.tenantIdContextParamName = Objects.requireNonNull(tenantIdContextParamName);
        this.deviceIdContextParamName = Objects.requireNonNull(deviceIdContextParamName);
    }

    @Override
    public Future<TenantObjectWithAuthId> get(HttpContext context, SpanContext spanContext) {
        if (this.config.isAuthenticationRequired()) {
            return this.getFromClientCertificate(context.getRoutingContext(), spanContext).recover(thr -> this.getFromAuthHeader(context.getRoutingContext(), spanContext));
        }
        if (this.tenantIdContextParamName != null && this.deviceIdContextParamName != null) {
            String tenantId = (String)context.get(this.tenantIdContextParamName);
            String deviceId = (String)context.get(this.deviceIdContextParamName);
            if (tenantId != null && deviceId != null) {
                return this.tenantClientFactory.getOrCreateTenantClient().compose(tenantClient -> tenantClient.get(tenantId, spanContext)).map(tenantObject -> new TenantObjectWithAuthId(tenantObject, deviceId));
            }
        }
        return Future.failedFuture((String)"tenant could not be determined");
    }

    protected final Future<TenantObjectWithAuthId> getFromClientCertificate(RoutingContext ctx, SpanContext spanContext) {
        if (!ctx.request().isSSL()) {
            return Future.failedFuture((String)"no cert found (not SSL/TLS encrypted)");
        }
        SSLSession sslSession = ctx.request().sslSession();
        return this.getFromClientCertificate(sslSession, spanContext);
    }

    protected final Future<TenantObjectWithAuthId> getFromAuthHeader(RoutingContext ctx, SpanContext spanContext) {
        String authorizationHeader = ctx.request().headers().get(HttpHeaders.AUTHORIZATION);
        if (authorizationHeader == null) {
            return Future.failedFuture((String)"no auth header found");
        }
        String userName = null;
        try {
            int idx = authorizationHeader.indexOf(32);
            if (idx > 0 && "Basic".equalsIgnoreCase(authorizationHeader.substring(0, idx))) {
                String authorization = authorizationHeader.substring(idx + 1);
                String decoded = new String(Base64.getDecoder().decode(authorization));
                int colonIdx = decoded.indexOf(":");
                userName = colonIdx != -1 ? decoded.substring(0, colonIdx) : decoded;
            }
        }
        catch (RuntimeException e) {
            LOG.debug("error parsing auth header: {}", (Object)e.getMessage());
        }
        if (userName == null) {
            return Future.failedFuture((String)"unsupported auth header value");
        }
        return this.getFromUserName(userName, spanContext);
    }
}

