/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.micrometer.core.instrument.Timer;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tags;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.TrustOptions;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.healthchecks.Status;
import io.vertx.proton.ProtonDelivery;
import io.vertx.proton.ProtonHelper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.auth.Device;
import org.eclipse.hono.client.BasicDeviceConnectionClientFactory;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.CommandContext;
import org.eclipse.hono.client.CommandResponse;
import org.eclipse.hono.client.CommandResponseSender;
import org.eclipse.hono.client.CommandTargetMapper;
import org.eclipse.hono.client.ConnectionLifecycle;
import org.eclipse.hono.client.CredentialsClientFactory;
import org.eclipse.hono.client.DeviceConnectionClient;
import org.eclipse.hono.client.DeviceConnectionClientFactory;
import org.eclipse.hono.client.DisconnectListener;
import org.eclipse.hono.client.DownstreamSender;
import org.eclipse.hono.client.DownstreamSenderFactory;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.ProtocolAdapterCommandConsumer;
import org.eclipse.hono.client.ProtocolAdapterCommandConsumerFactory;
import org.eclipse.hono.client.ReconnectListener;
import org.eclipse.hono.client.RegistrationClient;
import org.eclipse.hono.client.RegistrationClientFactory;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.client.TenantClient;
import org.eclipse.hono.client.TenantClientFactory;
import org.eclipse.hono.config.ProtocolAdapterProperties;
import org.eclipse.hono.service.AbstractServiceBase;
import org.eclipse.hono.service.auth.ValidityBasedTrustOptions;
import org.eclipse.hono.service.limiting.ConnectionLimitManager;
import org.eclipse.hono.service.monitoring.ConnectionEventProducer;
import org.eclipse.hono.service.resourcelimits.NoopResourceLimitChecks;
import org.eclipse.hono.service.resourcelimits.ResourceLimitChecks;
import org.eclipse.hono.service.util.ServiceBaseUtils;
import org.eclipse.hono.util.Constants;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.QoS;
import org.eclipse.hono.util.ResourceIdentifier;
import org.eclipse.hono.util.Strings;
import org.eclipse.hono.util.TenantObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractProtocolAdapterBase<T extends ProtocolAdapterProperties>
extends AbstractServiceBase<T> {
    protected static final String CONTENT_TYPE_OCTET_STREAM = "application/octet-stream";
    protected static final String KEY_MICROMETER_SAMPLE = "micrometer.sample";
    private DownstreamSenderFactory downstreamSenderFactory;
    private RegistrationClientFactory registrationClientFactory;
    private TenantClientFactory tenantClientFactory;
    private BasicDeviceConnectionClientFactory deviceConnectionClientFactory;
    private CredentialsClientFactory credentialsClientFactory;
    private ProtocolAdapterCommandConsumerFactory commandConsumerFactory;
    private CommandTargetMapper commandTargetMapper;
    private ConnectionLimitManager connectionLimitManager;
    private ConnectionEventProducer connectionEventProducer;
    private ResourceLimitChecks resourceLimitChecks = new NoopResourceLimitChecks();
    private final ConnectionEventProducer.Context connectionEventProducerContext = new ConnectionEventProducer.Context(){

        @Override
        public DownstreamSenderFactory getMessageSenderClient() {
            return AbstractProtocolAdapterBase.this.downstreamSenderFactory;
        }

        @Override
        public TenantClientFactory getTenantClientFactory() {
            return AbstractProtocolAdapterBase.this.tenantClientFactory;
        }
    };

    protected static final void addMicrometerSample(CommandContext ctx, Timer.Sample sample) {
        Objects.requireNonNull(ctx);
        ctx.put(KEY_MICROMETER_SAMPLE, (Object)sample);
    }

    protected static final Timer.Sample getMicrometerSample(CommandContext ctx) {
        Objects.requireNonNull(ctx);
        return (Timer.Sample)ctx.get(KEY_MICROMETER_SAMPLE);
    }

    @Autowired
    public void setConfig(T configuration) {
        this.setSpecificConfig(configuration);
    }

    @Qualifier(value="tenant")
    @Autowired
    public final void setTenantClientFactory(TenantClientFactory factory) {
        this.tenantClientFactory = Objects.requireNonNull(factory);
    }

    public final TenantClientFactory getTenantClientFactory() {
        return this.tenantClientFactory;
    }

    protected final Future<TenantClient> getTenantClient() {
        return this.getTenantClientFactory().getOrCreateTenantClient();
    }

    @Qualifier(value="device_con")
    @Autowired
    public final void setDeviceConnectionClientFactory(BasicDeviceConnectionClientFactory factory) {
        this.deviceConnectionClientFactory = Objects.requireNonNull(factory);
    }

    @Deprecated(forRemoval=true)
    public final DeviceConnectionClientFactory getDeviceConnectionClientFactory() {
        if (this.deviceConnectionClientFactory instanceof DeviceConnectionClientFactory) {
            return (DeviceConnectionClientFactory)this.deviceConnectionClientFactory;
        }
        return null;
    }

    protected final Future<DeviceConnectionClient> getDeviceConnectionClient(String tenantId) {
        if (this.deviceConnectionClientFactory == null) {
            throw new IllegalStateException("Device Connection client factory is not set");
        }
        return this.deviceConnectionClientFactory.getOrCreateDeviceConnectionClient(tenantId);
    }

    @Qualifier(value="messaging")
    @Autowired
    public final void setDownstreamSenderFactory(DownstreamSenderFactory factory) {
        this.downstreamSenderFactory = Objects.requireNonNull(factory);
    }

    public final DownstreamSenderFactory getDownstreamSenderFactory() {
        return this.downstreamSenderFactory;
    }

    @Qualifier(value="registration")
    @Autowired
    public final void setRegistrationClientFactory(RegistrationClientFactory factory) {
        this.registrationClientFactory = Objects.requireNonNull(factory);
    }

    public final RegistrationClientFactory getRegistrationClientFactory() {
        return this.registrationClientFactory;
    }

    @Qualifier(value="credentials")
    @Autowired
    public final void setCredentialsClientFactory(CredentialsClientFactory factory) {
        this.credentialsClientFactory = Objects.requireNonNull(factory);
    }

    public final CredentialsClientFactory getCredentialsClientFactory() {
        return this.credentialsClientFactory;
    }

    @Autowired(required=false)
    public void setConnectionEventProducer(ConnectionEventProducer connectionEventProducer) {
        this.connectionEventProducer = Objects.requireNonNull(connectionEventProducer);
        this.log.info("using [{}] for reporting connection events, if applicable for device protocol", (Object)connectionEventProducer);
    }

    public ConnectionEventProducer getConnectionEventProducer() {
        return this.connectionEventProducer;
    }

    protected abstract String getTypeName();

    protected Future<Integer> getTimeUntilDisconnect(TenantObject tenant, Integer deviceTtd) {
        Objects.requireNonNull(tenant);
        if (deviceTtd == null) {
            return Future.succeededFuture();
        }
        return Future.succeededFuture((Object)Math.min(tenant.getMaxTimeUntilDisconnect(this.getTypeName()), deviceTtd));
    }

    @Autowired
    public final void setCommandConsumerFactory(ProtocolAdapterCommandConsumerFactory factory) {
        this.commandConsumerFactory = Objects.requireNonNull(factory);
    }

    public final ProtocolAdapterCommandConsumerFactory getCommandConsumerFactory() {
        return this.commandConsumerFactory;
    }

    @Autowired
    public final void setCommandTargetMapper(CommandTargetMapper commandTargetMapper) {
        this.commandTargetMapper = Objects.requireNonNull(commandTargetMapper);
    }

    @Autowired(required=false)
    public final void setResourceLimitChecks(ResourceLimitChecks resourceLimitChecks) {
        this.resourceLimitChecks = Objects.requireNonNull(resourceLimitChecks);
    }

    protected final ResourceLimitChecks getResourceLimitChecks() {
        return this.resourceLimitChecks;
    }

    @Override
    protected final Future<Void> startInternal() {
        Promise result = Promise.promise();
        if (Strings.isNullOrEmpty((Object)this.getTypeName())) {
            result.fail((Throwable)new IllegalStateException("adapter does not define a typeName"));
        } else if (this.tenantClientFactory == null) {
            result.fail((Throwable)new IllegalStateException("Tenant client factory must be set"));
        } else if (this.downstreamSenderFactory == null) {
            result.fail((Throwable)new IllegalStateException("AMQP Messaging Network client must be set"));
        } else if (this.registrationClientFactory == null) {
            result.fail((Throwable)new IllegalStateException("Device Registration client factory must be set"));
        } else if (this.credentialsClientFactory == null) {
            result.fail((Throwable)new IllegalStateException("Credentials client factory must be set"));
        } else if (this.commandConsumerFactory == null) {
            result.fail((Throwable)new IllegalStateException("Command & Control client factory must be set"));
        } else if (this.deviceConnectionClientFactory == null) {
            result.fail((Throwable)new IllegalStateException("Device Connection client factory must be set"));
        } else {
            this.log.info("using ResourceLimitChecks [{}]", (Object)this.resourceLimitChecks.getClass().getName());
            this.connectToService((ConnectionLifecycle)this.tenantClientFactory, "Tenant service");
            this.connectToService((ConnectionLifecycle)this.downstreamSenderFactory, "AMQP Messaging Network");
            this.connectToService((ConnectionLifecycle)this.registrationClientFactory, "Device Registration service");
            this.connectToService((ConnectionLifecycle)this.credentialsClientFactory, "Credentials service");
            if (this.deviceConnectionClientFactory instanceof ConnectionLifecycle) {
                this.connectToService((ConnectionLifecycle)this.deviceConnectionClientFactory, "Device Connection service");
            }
            this.connectToService((ConnectionLifecycle)this.commandConsumerFactory, "Command & Control", (DisconnectListener)this::onCommandConnectionLost, (ReconnectListener)this::onCommandConnectionEstablished).onComplete(c -> {
                if (c.succeeded()) {
                    this.onCommandConnectionEstablished((HonoConnection)c.result());
                }
            });
            this.commandTargetMapper.initialize(this.registrationClientFactory, this.deviceConnectionClientFactory);
            this.commandConsumerFactory.initialize(this.commandTargetMapper, this.deviceConnectionClientFactory);
            this.doStart((Promise<Void>)result);
        }
        return result.future();
    }

    protected void doStart(Promise<Void> startPromise) {
        startPromise.complete();
    }

    @Override
    protected final Future<Void> stopInternal() {
        this.log.info("stopping protocol adapter");
        Promise result = Promise.promise();
        this.doStop((Promise<Void>)result);
        return result.future().compose(s -> this.closeServiceClients()).recover(t -> {
            this.log.info("error while stopping protocol adapter", t);
            return Future.failedFuture((Throwable)t);
        }).map(ok -> {
            this.log.info("successfully stopped protocol adapter");
            return null;
        });
    }

    private Future<?> closeServiceClients() {
        ArrayList<Future<Void>> results = new ArrayList<Future<Void>>();
        results.add(this.disconnectFromService((ConnectionLifecycle<?>)this.downstreamSenderFactory));
        results.add(this.disconnectFromService((ConnectionLifecycle<?>)this.tenantClientFactory));
        results.add(this.disconnectFromService((ConnectionLifecycle<?>)this.registrationClientFactory));
        results.add(this.disconnectFromService((ConnectionLifecycle<?>)this.credentialsClientFactory));
        results.add(this.disconnectFromService((ConnectionLifecycle<?>)this.commandConsumerFactory));
        if (this.deviceConnectionClientFactory instanceof ConnectionLifecycle) {
            results.add(this.disconnectFromService((ConnectionLifecycle)this.deviceConnectionClientFactory));
        }
        return CompositeFuture.all(results);
    }

    private Future<Void> disconnectFromService(ConnectionLifecycle<?> connection) {
        Promise disconnectTracker = Promise.promise();
        if (connection == null) {
            disconnectTracker.complete();
        } else {
            connection.disconnect((Handler)disconnectTracker);
        }
        return disconnectTracker.future();
    }

    protected void doStop(Promise<Void> stopPromise) {
        stopPromise.complete();
    }

    protected final Future<TenantObject> isAdapterEnabled(TenantObject tenantConfig) {
        Objects.requireNonNull(tenantConfig);
        if (tenantConfig.isAdapterEnabled(this.getTypeName())) {
            this.log.debug("protocol adapter [{}] is enabled for tenant [{}]", (Object)this.getTypeName(), (Object)tenantConfig.getTenantId());
            return Future.succeededFuture((Object)tenantConfig);
        }
        this.log.debug("protocol adapter [{}] is disabled for tenant [{}]", (Object)this.getTypeName(), (Object)tenantConfig.getTenantId());
        return Future.failedFuture((Throwable)new ClientErrorException(403, "adapter disabled for tenant"));
    }

    protected Future<Void> checkConnectionLimit(TenantObject tenantConfig, SpanContext spanContext) {
        Objects.requireNonNull(tenantConfig);
        Future connectionLimitCheckResult = this.resourceLimitChecks.isConnectionLimitReached(tenantConfig, spanContext).recover(t -> Future.succeededFuture((Object)Boolean.FALSE)).compose(isExceeded -> {
            if (isExceeded.booleanValue()) {
                return Future.failedFuture((Throwable)new ClientErrorException(403));
            }
            return Future.succeededFuture();
        });
        Future messageLimitCheckResult = this.checkMessageLimit(tenantConfig, 1L, spanContext).recover(t -> {
            if (t instanceof ClientErrorException) {
                return Future.failedFuture((Throwable)new ClientErrorException(403));
            }
            return Future.failedFuture((Throwable)t);
        });
        return CompositeFuture.all((Future)connectionLimitCheckResult, this.checkConnectionDurationLimit(tenantConfig, spanContext), (Future)messageLimitCheckResult).map(ok -> null);
    }

    protected Future<Void> checkMessageLimit(TenantObject tenantConfig, long payloadSize, SpanContext spanContext) {
        Objects.requireNonNull(tenantConfig);
        return this.resourceLimitChecks.isMessageLimitReached(tenantConfig, ServiceBaseUtils.calculatePayloadSize(payloadSize, tenantConfig), spanContext).recover(t -> Future.succeededFuture((Object)Boolean.FALSE)).compose(isExceeded -> {
            if (isExceeded.booleanValue()) {
                return Future.failedFuture((Throwable)new ClientErrorException(HttpResponseStatus.TOO_MANY_REQUESTS.code()));
            }
            return Future.succeededFuture();
        });
    }

    protected Future<Void> checkConnectionDurationLimit(TenantObject tenantConfig, SpanContext spanContext) {
        Objects.requireNonNull(tenantConfig);
        return this.resourceLimitChecks.isConnectionDurationLimitReached(tenantConfig, spanContext).recover(t -> Future.succeededFuture((Object)Boolean.FALSE)).compose(isExceeded -> {
            if (isExceeded.booleanValue()) {
                return Future.failedFuture((Throwable)new ClientErrorException(403));
            }
            return Future.succeededFuture();
        });
    }

    protected final Future<ResourceIdentifier> validateAddress(ResourceIdentifier address, Device authenticatedDevice) {
        Objects.requireNonNull(address);
        Promise result = Promise.promise();
        if (authenticatedDevice == null) {
            if (Strings.isNullOrEmpty((Object)address.getTenantId()) || Strings.isNullOrEmpty((Object)address.getResourceId())) {
                result.fail((Throwable)new ClientErrorException(400, "unauthenticated client must provide tenant and device ID in message address"));
            } else {
                result.complete((Object)address);
            }
        } else if (!Strings.isNullOrEmpty((Object)address.getTenantId()) && Strings.isNullOrEmpty((Object)address.getResourceId())) {
            result.fail((Throwable)new ClientErrorException(400, "message address must not contain tenant ID only"));
        } else if (!Strings.isNullOrEmpty((Object)address.getTenantId()) && !address.getTenantId().equals(authenticatedDevice.getTenantId())) {
            result.fail((Throwable)new ClientErrorException(403, "can only publish for device of same tenant"));
        } else if (Strings.isNullOrEmpty((Object)address.getTenantId()) && Strings.isNullOrEmpty((Object)address.getResourceId())) {
            ResourceIdentifier resource = ResourceIdentifier.from((ResourceIdentifier)address, (String)authenticatedDevice.getTenantId(), (String)authenticatedDevice.getDeviceId());
            result.complete((Object)resource);
        } else if (Strings.isNullOrEmpty((Object)address.getTenantId())) {
            ResourceIdentifier resource = ResourceIdentifier.from((ResourceIdentifier)address, (String)authenticatedDevice.getTenantId(), (String)address.getResourceId());
            result.complete((Object)resource);
        } else {
            result.complete((Object)address);
        }
        return result.future().recover(t -> {
            this.log.debug("validation failed for address [{}], device [{}]: {}", new Object[]{address, authenticatedDevice, t.getMessage()});
            return Future.failedFuture((Throwable)t);
        });
    }

    protected final Future<Void> checkDeviceRegistration(Device device, SpanContext context) {
        Objects.requireNonNull(device);
        return this.getRegistrationAssertion(device.getTenantId(), device.getDeviceId(), null, context).map(assertion -> null);
    }

    protected final <C> Future<C> connectToService(ConnectionLifecycle<C> factory, String serviceName) {
        return this.connectToService(factory, serviceName, null, null);
    }

    protected final <C> Future<C> connectToService(ConnectionLifecycle<C> factory, String serviceName, DisconnectListener<C> disconnectListener, ReconnectListener<C> reconnectListener) {
        Objects.requireNonNull(factory);
        factory.addDisconnectListener(c -> {
            this.log.info("lost connection to {}", (Object)serviceName);
            if (disconnectListener != null) {
                disconnectListener.onDisconnect(c);
            }
        });
        factory.addReconnectListener(c -> {
            this.log.info("connection to {} re-established", (Object)serviceName);
            if (reconnectListener != null) {
                reconnectListener.onReconnect(c);
            }
        });
        return factory.connect().map(c -> {
            this.log.info("connected to {}", (Object)serviceName);
            return c;
        }).recover(t -> {
            this.log.warn("failed to connect to {}", (Object)serviceName, t);
            return Future.failedFuture((Throwable)t);
        });
    }

    protected void onCommandConnectionLost(HonoConnection commandConnection) {
    }

    protected void onCommandConnectionEstablished(HonoConnection commandConnection) {
    }

    protected Future<Void> isConnected() {
        ArrayList<Future> connections = new ArrayList<Future>();
        connections.add(Optional.ofNullable(this.tenantClientFactory).map(client -> client.isConnected()).orElse(Future.failedFuture((Throwable)new ServerErrorException(503, "Tenant client factory is not set"))));
        connections.add(Optional.ofNullable(this.registrationClientFactory).map(client -> client.isConnected()).orElse(Future.failedFuture((Throwable)new ServerErrorException(503, "Device Registration client factory is not set"))));
        connections.add(Optional.ofNullable(this.credentialsClientFactory).map(client -> client.isConnected()).orElse(Future.failedFuture((Throwable)new ServerErrorException(503, "Credentials client factory is not set"))));
        connections.add(Optional.ofNullable(this.downstreamSenderFactory).map(client -> client.isConnected()).orElse(Future.failedFuture((Throwable)new ServerErrorException(503, "Messaging client is not set"))));
        connections.add(Optional.ofNullable(this.commandConsumerFactory).map(client -> client.isConnected()).orElse(Future.failedFuture((Throwable)new ServerErrorException(503, "Command & Control client factory is not set"))));
        connections.add(Optional.ofNullable(this.deviceConnectionClientFactory).map(client -> {
            if (this.deviceConnectionClientFactory instanceof ConnectionLifecycle) {
                return ((ConnectionLifecycle)client).isConnected();
            }
            return Future.succeededFuture();
        }).orElse(Future.failedFuture((Throwable)new ServerErrorException(503, "Device Connection client factory is not set"))));
        return CompositeFuture.all(connections).mapEmpty();
    }

    protected final Future<ProtocolAdapterCommandConsumer> createCommandConsumer(String tenantId, String deviceId, Handler<CommandContext> commandConsumer, SpanContext context) {
        return this.commandConsumerFactory.createCommandConsumer(tenantId, deviceId, commandContext -> {
            Tags.COMPONENT.set(commandContext.getCurrentSpan(), this.getTypeName());
            commandConsumer.handle(commandContext);
        }, null, context);
    }

    protected final Future<CommandResponseSender> createCommandResponseSender(String tenantId, String replyId) {
        return this.commandConsumerFactory.getCommandResponseSender(tenantId, replyId);
    }

    protected final Future<ProtonDelivery> sendCommandResponse(String tenantId, CommandResponse response, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(response);
        Future<CommandResponseSender> senderTracker = this.createCommandResponseSender(tenantId, response.getReplyToId());
        return senderTracker.compose(sender -> sender.sendCommandResponse(response, context)).map(delivery -> {
            ((CommandResponseSender)senderTracker.result()).close(c -> {});
            return delivery;
        }).recover(t -> {
            if (senderTracker.succeeded()) {
                ((CommandResponseSender)senderTracker.result()).close(c -> {});
            }
            return Future.failedFuture((Throwable)t);
        });
    }

    protected final Future<DownstreamSender> getTelemetrySender(String tenantId) {
        return this.getDownstreamSenderFactory().getOrCreateTelemetrySender(tenantId);
    }

    protected final Future<DownstreamSender> getEventSender(String tenantId) {
        return this.getDownstreamSenderFactory().getOrCreateEventSender(tenantId);
    }

    protected final Future<RegistrationClient> getRegistrationClient(String tenantId) {
        return this.getRegistrationClientFactory().getOrCreateRegistrationClient(tenantId);
    }

    protected final Future<JsonObject> getRegistrationAssertion(String tenantId, String deviceId, Device authenticatedDevice, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Future<String> gatewayId = this.getGatewayId(tenantId, deviceId, authenticatedDevice);
        return gatewayId.compose(gwId -> this.getRegistrationClient(tenantId)).compose(client -> client.assertRegistration(deviceId, (String)gatewayId.result(), context)).compose(registrationAssertion -> {
            this.updateLastGateway((JsonObject)registrationAssertion, tenantId, deviceId, authenticatedDevice, context).otherwise(t -> {
                this.log.warn("failed to update last gateway [tenantId: {}, deviceId: {}]", new Object[]{tenantId, deviceId, t});
                return null;
            });
            return Future.succeededFuture((Object)registrationAssertion);
        });
    }

    protected final Future<JsonObject> updateLastGateway(JsonObject registrationAssertion, String tenantId, String deviceId, Device authenticatedDevice, SpanContext context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        if (!this.isGatewaySupportedForDevice(registrationAssertion)) {
            return Future.succeededFuture((Object)registrationAssertion);
        }
        Future<String> gatewayIdFuture = this.getGatewayId(tenantId, deviceId, authenticatedDevice);
        return gatewayIdFuture.compose(gwId -> this.getDeviceConnectionClient(tenantId)).compose(client -> client.setLastKnownGatewayForDevice(deviceId, Optional.ofNullable((String)gatewayIdFuture.result()).orElse(deviceId), context)).map((Object)registrationAssertion);
    }

    private boolean isGatewaySupportedForDevice(JsonObject registrationAssertion) {
        Object viaObj = registrationAssertion.getValue("via");
        return viaObj instanceof JsonArray && !((JsonArray)viaObj).isEmpty();
    }

    private Future<String> getGatewayId(String tenantId, String deviceId, Device authenticatedDevice) {
        Promise result = Promise.promise();
        if (authenticatedDevice == null) {
            result.complete(null);
        } else if (tenantId.equals(authenticatedDevice.getTenantId())) {
            if (deviceId.equals(authenticatedDevice.getDeviceId())) {
                result.complete(null);
            } else {
                result.complete((Object)authenticatedDevice.getDeviceId());
            }
        } else {
            result.fail((Throwable)new ClientErrorException(403, "cannot publish data for device of other tenant"));
        }
        return result.future();
    }

    protected final Future<TenantObject> getTenantConfiguration(String tenantId, SpanContext context) {
        Objects.requireNonNull(tenantId);
        return this.getTenantClient().compose(client -> client.get(tenantId, context));
    }

    protected final Message newMessage(QoS qos, ResourceIdentifier target, String publishAddress, String contentType, Buffer payload, TenantObject tenant, JsonObject registrationInfo, Integer timeUntilDisconnect) {
        return this.newMessage(qos, target, publishAddress, contentType, payload, tenant, registrationInfo, timeUntilDisconnect, null);
    }

    protected final Message newMessage(QoS qos, ResourceIdentifier target, String publishAddress, String contentType, Buffer payload, TenantObject tenant, JsonObject registrationInfo, Integer timeUntilDisconnect, Duration timeToLive) {
        Objects.requireNonNull(registrationInfo);
        return MessageHelper.newMessage((QoS)qos, (ResourceIdentifier)target, (String)publishAddress, (String)contentType, (Buffer)payload, (TenantObject)tenant, (JsonObject)registrationInfo.getJsonObject("defaults"), (Integer)timeUntilDisconnect, (Duration)timeToLive, (String)this.getTypeName(), (boolean)((ProtocolAdapterProperties)this.getConfig()).isDefaultsEnabled(), (boolean)((ProtocolAdapterProperties)this.getConfig()).isJmsVendorPropsEnabled());
    }

    protected final Message addProperties(Message msg, QoS qos, ResourceIdentifier target, String publishAddress, TenantObject tenant, JsonObject registrationInfo, Integer timeUntilDisconnect) {
        return this.addProperties(msg, qos, target, publishAddress, tenant, registrationInfo, timeUntilDisconnect, null);
    }

    protected final Message addProperties(Message msg, QoS qos, ResourceIdentifier target, String publishAddress, TenantObject tenant, JsonObject registrationInfo, Integer timeUntilDisconnect, Duration timeToLive) {
        Objects.requireNonNull(msg);
        Objects.requireNonNull(target);
        Objects.requireNonNull(registrationInfo);
        return MessageHelper.addProperties((Message)msg, (QoS)qos, (ResourceIdentifier)target, (String)publishAddress, (TenantObject)tenant, (JsonObject)registrationInfo.getJsonObject("defaults"), (Integer)timeUntilDisconnect, (Duration)timeToLive, (String)this.getTypeName(), (boolean)((ProtocolAdapterProperties)this.getConfig()).isDefaultsEnabled(), (boolean)((ProtocolAdapterProperties)this.getConfig()).isJmsVendorPropsEnabled());
    }

    @Override
    public void registerReadinessChecks(HealthCheckHandler handler) {
        handler.register("connection-to-services", 2000L, status -> this.isConnected().map(connected -> {
            status.tryComplete((Object)Status.OK());
            return null;
        }).otherwise(t -> {
            status.tryComplete((Object)Status.KO());
            return null;
        }));
    }

    @Override
    public void registerLivenessChecks(HealthCheckHandler handler) {
        this.registerEventLoopBlockedCheck(handler);
    }

    protected Future<?> sendConnectedEvent(String remoteId, Device authenticatedDevice) {
        if (this.connectionEventProducer != null) {
            return this.connectionEventProducer.connected(this.connectionEventProducerContext, remoteId, this.getTypeName(), authenticatedDevice, null);
        }
        return Future.succeededFuture();
    }

    protected Future<?> sendDisconnectedEvent(String remoteId, Device authenticatedDevice) {
        if (this.connectionEventProducer != null) {
            return this.connectionEventProducer.disconnected(this.connectionEventProducerContext, remoteId, this.getTypeName(), authenticatedDevice, null);
        }
        return Future.succeededFuture();
    }

    protected final Future<ProtonDelivery> sendConnectedTtdEvent(String tenant, String deviceId, Device authenticatedDevice, SpanContext context) {
        return this.sendTtdEvent(tenant, deviceId, authenticatedDevice, -1, context);
    }

    protected final Future<ProtonDelivery> sendDisconnectedTtdEvent(String tenant, String deviceId, Device authenticatedDevice, SpanContext context) {
        return this.sendTtdEvent(tenant, deviceId, authenticatedDevice, 0, context);
    }

    protected final Future<ProtonDelivery> sendTtdEvent(String tenant, String deviceId, Device authenticatedDevice, Integer ttd, SpanContext context) {
        Objects.requireNonNull(tenant);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(ttd);
        Future<JsonObject> tokenTracker = this.getRegistrationAssertion(tenant, deviceId, authenticatedDevice, context);
        Future<TenantObject> tenantConfigTracker = this.getTenantConfiguration(tenant, context);
        Future<DownstreamSender> senderTracker = this.getEventSender(tenant);
        return CompositeFuture.all(tokenTracker, tenantConfigTracker, senderTracker).compose(ok -> {
            if (((TenantObject)tenantConfigTracker.result()).isAdapterEnabled(this.getTypeName())) {
                DownstreamSender sender = (DownstreamSender)senderTracker.result();
                Message msg = this.newMessage(QoS.AT_LEAST_ONCE, ResourceIdentifier.from((String)"event", (String)tenant, (String)deviceId), "event", "application/vnd.eclipse-hono-empty-notification", null, (TenantObject)tenantConfigTracker.result(), (JsonObject)tokenTracker.result(), ttd);
                return sender.sendAndWaitForOutcome(msg, context);
            }
            return Future.failedFuture((Throwable)new ClientErrorException(403));
        });
    }

    protected boolean isPayloadOfIndicatedType(Buffer payload, String contentType) {
        if (payload == null || payload.length() == 0) {
            return "application/vnd.eclipse-hono-empty-notification".equals(contentType);
        }
        return !"application/vnd.eclipse-hono-empty-notification".equals(contentType);
    }

    protected void registerEventLoopBlockedCheck(HealthCheckHandler handler) {
        handler.register("event-loop-blocked-check", ((ProtocolAdapterProperties)this.getConfig()).getEventLoopBlockedCheckTimeout(), procedure -> {
            Context currentContext = Vertx.currentContext();
            if (currentContext != this.context) {
                this.context.runOnContext(action -> procedure.tryComplete((Object)Status.OK()));
            } else {
                this.log.debug("Protocol Adapter - HealthCheck Server context match. Assume protocol adapter is alive.");
                procedure.tryComplete((Object)Status.OK());
            }
        });
    }

    @Override
    protected TrustOptions getServerTrustOptions() {
        return Optional.ofNullable(((ProtocolAdapterProperties)this.getConfig()).getTrustOptions()).orElseGet(() -> {
            if (((ProtocolAdapterProperties)this.getConfig()).isAuthenticationRequired()) {
                return new ValidityBasedTrustOptions();
            }
            return null;
        });
    }

    protected final ErrorCondition getErrorCondition(Throwable t) {
        if (ServiceInvocationException.class.isInstance(t)) {
            ServiceInvocationException error = (ServiceInvocationException)t;
            switch (error.getErrorCode()) {
                case 400: {
                    return ProtonHelper.condition((Symbol)Constants.AMQP_BAD_REQUEST, (String)error.getMessage());
                }
                case 403: {
                    return ProtonHelper.condition((Symbol)AmqpError.UNAUTHORIZED_ACCESS, (String)error.getMessage());
                }
                case 429: {
                    return ProtonHelper.condition((Symbol)AmqpError.RESOURCE_LIMIT_EXCEEDED, (String)error.getMessage());
                }
            }
            return ProtonHelper.condition((Symbol)AmqpError.PRECONDITION_FAILED, (String)error.getMessage());
        }
        return ProtonHelper.condition((Symbol)AmqpError.PRECONDITION_FAILED, (String)t.getMessage());
    }

    public final ConnectionLimitManager getConnectionLimitManager() {
        return this.connectionLimitManager;
    }

    public final void setConnectionLimitManager(ConnectionLimitManager connectionLimitManager) {
        this.connectionLimitManager = connectionLimitManager;
    }
}

