/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.noop.NoopTracerFactory;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.ext.web.client.WebClient;
import io.vertx.ext.web.client.WebClientOptions;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.cache.CacheProvider;
import org.eclipse.hono.client.BasicDeviceConnectionClientFactory;
import org.eclipse.hono.client.CommandTargetMapper;
import org.eclipse.hono.client.CredentialsClientFactory;
import org.eclipse.hono.client.DeviceConnectionClientFactory;
import org.eclipse.hono.client.DownstreamSenderFactory;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.ProtocolAdapterCommandConsumerFactory;
import org.eclipse.hono.client.RegistrationClientFactory;
import org.eclipse.hono.client.RequestResponseClientConfigProperties;
import org.eclipse.hono.client.TenantClientFactory;
import org.eclipse.hono.config.ApplicationConfigProperties;
import org.eclipse.hono.config.AuthenticatingClientConfigProperties;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.config.ServerConfig;
import org.eclipse.hono.config.VertxProperties;
import org.eclipse.hono.service.HealthCheckServer;
import org.eclipse.hono.service.VertxBasedHealthCheckServer;
import org.eclipse.hono.service.cache.SpringCacheProvider;
import org.eclipse.hono.service.monitoring.ConnectionEventProducer;
import org.eclipse.hono.service.monitoring.ConnectionEventProducerConfig;
import org.eclipse.hono.service.monitoring.HonoEventConnectionEventProducer;
import org.eclipse.hono.service.monitoring.LoggingConnectionEventProducer;
import org.eclipse.hono.service.resourcelimits.LimitedResource;
import org.eclipse.hono.service.resourcelimits.PrometheusBasedResourceLimitChecks;
import org.eclipse.hono.service.resourcelimits.PrometheusBasedResourceLimitChecksConfig;
import org.eclipse.hono.service.resourcelimits.ResourceLimitChecks;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;

public abstract class AbstractAdapterConfig {
    @Bean
    public Tracer getTracer() {
        return Optional.ofNullable(TracerResolver.resolveTracer()).orElse((Tracer)NoopTracerFactory.create());
    }

    @Bean
    public Vertx vertx() {
        return Vertx.vertx((VertxOptions)this.vertxProperties().configureVertx(new VertxOptions()));
    }

    protected abstract String getAdapterName();

    @Bean
    @ConfigurationProperties(value="hono.connection-events")
    public ConnectionEventProducerConfig connectionEventProducerConfig() {
        return new ConnectionEventProducerConfig();
    }

    @Bean
    public ConnectionEventProducer connectionEventProducer(ConnectionEventProducerConfig config) {
        switch (config.getType()) {
            case logging: {
                return new LoggingConnectionEventProducer(config);
            }
            case events: {
                return new HonoEventConnectionEventProducer();
            }
        }
        return null;
    }

    @Qualifier(value="messaging")
    @ConfigurationProperties(prefix="hono.messaging")
    @Bean
    public ClientConfigProperties downstreamSenderFactoryConfig() {
        ClientConfigProperties config = Optional.ofNullable(this.getDownstreamSenderFactoryConfigDefaults()).orElseGet(ClientConfigProperties::new);
        AbstractAdapterConfig.setConfigServerRoleIfUnknown((AuthenticatingClientConfigProperties)config, "AMQP Messaging Network");
        this.setDefaultConfigNameIfNotSet(config);
        return config;
    }

    protected ClientConfigProperties getDownstreamSenderFactoryConfigDefaults() {
        return new ClientConfigProperties();
    }

    @Qualifier(value="messaging")
    @Bean
    @Scope(value="prototype")
    public DownstreamSenderFactory downstreamSenderFactory() {
        return DownstreamSenderFactory.create((HonoConnection)this.downstreamConnection());
    }

    @Qualifier(value="messaging")
    @Bean
    @Scope(value="prototype")
    public HonoConnection downstreamConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.downstreamSenderFactoryConfig());
    }

    @Qualifier(value="registration")
    @ConfigurationProperties(prefix="hono.registration")
    @Bean
    public RequestResponseClientConfigProperties registrationClientFactoryConfig() {
        RequestResponseClientConfigProperties config = Optional.ofNullable(this.getRegistrationClientFactoryConfigDefaults()).orElseGet(RequestResponseClientConfigProperties::new);
        AbstractAdapterConfig.setConfigServerRoleIfUnknown((AuthenticatingClientConfigProperties)config, "Device Registration");
        this.setDefaultConfigNameIfNotSet((ClientConfigProperties)config);
        return config;
    }

    protected RequestResponseClientConfigProperties getRegistrationClientFactoryConfigDefaults() {
        return new RequestResponseClientConfigProperties();
    }

    @Bean
    @Qualifier(value="registration")
    @Scope(value="prototype")
    public RegistrationClientFactory registrationClientFactory() {
        return RegistrationClientFactory.create((HonoConnection)this.registrationServiceConnection(), (CacheProvider)this.registrationCacheProvider());
    }

    @Bean
    @Qualifier(value="registration")
    @Scope(value="prototype")
    public HonoConnection registrationServiceConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.registrationClientFactoryConfig());
    }

    @Bean
    @Qualifier(value="registration")
    @Scope(value="prototype")
    public CacheProvider registrationCacheProvider() {
        return AbstractAdapterConfig.newCaffeineCache(this.registrationClientFactoryConfig());
    }

    @Qualifier(value="credentials")
    @ConfigurationProperties(prefix="hono.credentials")
    @Bean
    public RequestResponseClientConfigProperties credentialsClientFactoryConfig() {
        RequestResponseClientConfigProperties config = Optional.ofNullable(this.getCredentialsClientFactoryConfigDefaults()).orElseGet(RequestResponseClientConfigProperties::new);
        AbstractAdapterConfig.setConfigServerRoleIfUnknown((AuthenticatingClientConfigProperties)config, "Credentials");
        this.setDefaultConfigNameIfNotSet((ClientConfigProperties)config);
        return config;
    }

    protected RequestResponseClientConfigProperties getCredentialsClientFactoryConfigDefaults() {
        return new RequestResponseClientConfigProperties();
    }

    @Bean
    @Qualifier(value="credentials")
    @Scope(value="prototype")
    public CredentialsClientFactory credentialsClientFactory() {
        return CredentialsClientFactory.create((HonoConnection)this.credentialsServiceConnection(), (CacheProvider)this.credentialsCacheProvider());
    }

    @Bean
    @Qualifier(value="credentials")
    @Scope(value="prototype")
    public HonoConnection credentialsServiceConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.credentialsClientFactoryConfig());
    }

    @Bean
    @Qualifier(value="credentials")
    @Scope(value="prototype")
    public CacheProvider credentialsCacheProvider() {
        return AbstractAdapterConfig.newCaffeineCache(this.credentialsClientFactoryConfig());
    }

    @Qualifier(value="tenant")
    @ConfigurationProperties(prefix="hono.tenant")
    @Bean
    public RequestResponseClientConfigProperties tenantServiceClientConfig() {
        RequestResponseClientConfigProperties config = Optional.ofNullable(this.getTenantClientFactoryConfigDefaults()).orElseGet(RequestResponseClientConfigProperties::new);
        AbstractAdapterConfig.setConfigServerRoleIfUnknown((AuthenticatingClientConfigProperties)config, "Tenant");
        this.setDefaultConfigNameIfNotSet((ClientConfigProperties)config);
        return config;
    }

    protected RequestResponseClientConfigProperties getTenantClientFactoryConfigDefaults() {
        return new RequestResponseClientConfigProperties();
    }

    @Bean
    @Qualifier(value="tenant")
    @Scope(value="prototype")
    public TenantClientFactory tenantClientFactory() {
        return TenantClientFactory.create((HonoConnection)this.tenantServiceConnection(), (CacheProvider)this.tenantCacheProvider());
    }

    @Bean
    @Qualifier(value="tenant")
    @Scope(value="prototype")
    public HonoConnection tenantServiceConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.tenantServiceClientConfig());
    }

    @Bean
    @Qualifier(value="tenant")
    @Scope(value="prototype")
    public CacheProvider tenantCacheProvider() {
        return AbstractAdapterConfig.newCaffeineCache(this.tenantServiceClientConfig());
    }

    @Bean
    @Qualifier(value="device_con")
    @ConfigurationProperties(prefix="hono.device-connection")
    @ConditionalOnProperty(prefix="hono.device-connection", name={"host"})
    public RequestResponseClientConfigProperties deviceConnectionServiceClientConfig() {
        RequestResponseClientConfigProperties config = Optional.ofNullable(this.getDeviceConnectionClientFactoryConfigDefaults()).orElseGet(RequestResponseClientConfigProperties::new);
        AbstractAdapterConfig.setConfigServerRoleIfUnknown((AuthenticatingClientConfigProperties)config, "Device Connection");
        this.setDefaultConfigNameIfNotSet((ClientConfigProperties)config);
        return config;
    }

    protected RequestResponseClientConfigProperties getDeviceConnectionClientFactoryConfigDefaults() {
        return new RequestResponseClientConfigProperties();
    }

    @Bean
    @Qualifier(value="device_con")
    @Scope(value="prototype")
    @ConditionalOnProperty(prefix="hono.device-connection", name={"host"})
    public HonoConnection deviceConnectionServiceConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.deviceConnectionServiceClientConfig());
    }

    @Bean
    @Qualifier(value="device_con")
    @Scope(value="prototype")
    @ConditionalOnProperty(prefix="hono.device-connection", name={"host"})
    public BasicDeviceConnectionClientFactory deviceConnectionClientFactory() {
        return DeviceConnectionClientFactory.create((HonoConnection)this.deviceConnectionServiceConnection());
    }

    @Qualifier(value="command")
    @ConfigurationProperties(prefix="hono.command")
    @Bean
    public ClientConfigProperties commandConsumerFactoryConfig() {
        ClientConfigProperties config = Optional.ofNullable(this.getCommandConsumerFactoryConfigDefaults()).orElseGet(ClientConfigProperties::new);
        AbstractAdapterConfig.setConfigServerRoleIfUnknown((AuthenticatingClientConfigProperties)config, "Command & Control");
        this.setDefaultConfigNameIfNotSet(config);
        return config;
    }

    protected ClientConfigProperties getCommandConsumerFactoryConfigDefaults() {
        return new ClientConfigProperties();
    }

    @Bean
    @Scope(value="prototype")
    public HonoConnection commandConsumerConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.commandConsumerFactoryConfig());
    }

    @Bean
    @Scope(value="prototype")
    public ProtocolAdapterCommandConsumerFactory commandConsumerFactory() {
        return ProtocolAdapterCommandConsumerFactory.create((HonoConnection)this.commandConsumerConnection());
    }

    @Bean
    @Scope(value="prototype")
    public CommandTargetMapper commandTargetMapper() {
        return CommandTargetMapper.create((Tracer)this.getTracer());
    }

    @ConfigurationProperties(value="hono.vertx")
    @Bean
    public VertxProperties vertxProperties() {
        return new VertxProperties();
    }

    private static void setConfigServerRoleIfUnknown(AuthenticatingClientConfigProperties config, String serverRole) {
        if (config.getServerRole().equals("unknown")) {
            config.setServerRole(serverRole);
        }
    }

    private void setDefaultConfigNameIfNotSet(ClientConfigProperties config) {
        if (config.getName() == null && this.getAdapterName() != null) {
            config.setName(this.getAdapterName());
        }
    }

    private static CacheProvider newCaffeineCache(RequestResponseClientConfigProperties config) {
        return AbstractAdapterConfig.newCaffeineCache(config.getResponseCacheMinSize(), config.getResponseCacheMaxSize());
    }

    private static CacheProvider newCaffeineCache(int minCacheSize, long maxCacheSize) {
        if (maxCacheSize <= 0L) {
            return null;
        }
        Caffeine caffeine = Caffeine.newBuilder().initialCapacity(minCacheSize).maximumSize(Math.max((long)minCacheSize, maxCacheSize));
        CaffeineCacheManager manager = new CaffeineCacheManager();
        manager.setAllowNullValues(false);
        manager.setCaffeine(caffeine);
        return new SpringCacheProvider((CacheManager)manager);
    }

    @Bean
    @ConfigurationProperties(prefix="hono.app")
    public ApplicationConfigProperties applicationConfigProperties() {
        return new ApplicationConfigProperties();
    }

    @Bean
    @ConfigurationProperties(prefix="hono.health-check")
    public ServerConfig healthCheckConfigProperties() {
        return new ServerConfig();
    }

    @Bean
    public HealthCheckServer healthCheckServer() {
        return new VertxBasedHealthCheckServer(this.vertx(), this.healthCheckConfigProperties());
    }

    @Bean
    @ConfigurationProperties(prefix="hono.resource-limits.prometheus-based")
    @ConditionalOnClass(name={"io.micrometer.prometheus.PrometheusMeterRegistry"})
    @ConditionalOnProperty(name={"hono.resource-limits.prometheus-based.host"})
    public PrometheusBasedResourceLimitChecksConfig resourceLimitChecksConfig() {
        return new PrometheusBasedResourceLimitChecksConfig();
    }

    @Bean
    @ConditionalOnBean(value={PrometheusBasedResourceLimitChecksConfig.class})
    public ResourceLimitChecks resourceLimitChecks(PrometheusBasedResourceLimitChecksConfig config) {
        Objects.requireNonNull(config);
        Caffeine builder = Caffeine.newBuilder().initialCapacity(config.getCacheMinSize()).maximumSize(config.getCacheMaxSize()).expireAfterWrite(Duration.ofSeconds(config.getCacheTimeout()));
        WebClientOptions webClientOptions = new WebClientOptions();
        webClientOptions.setDefaultHost(config.getHost());
        webClientOptions.setDefaultPort(config.getPort());
        webClientOptions.setTrustOptions(config.getTrustOptions());
        webClientOptions.setKeyCertOptions(config.getKeyCertOptions());
        webClientOptions.setSsl(config.isTlsEnabled());
        return new PrometheusBasedResourceLimitChecks(WebClient.create((Vertx)this.vertx(), (WebClientOptions)webClientOptions), config, (AsyncCache<String, LimitedResource<Long>>)builder.buildAsync(), (AsyncCache<String, LimitedResource<Duration>>)builder.buildAsync(), (AsyncCache<String, LimitedResource<Long>>)builder.buildAsync(), this.getTracer());
    }
}

