/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.opentracing.SpanContext;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import org.eclipse.hono.util.ExecutionContext;

public class HttpContext
implements ExecutionContext {
    private final RoutingContext routingContext;
    private SpanContext spanContext;

    public HttpContext(RoutingContext routingContext) {
        this.routingContext = Objects.requireNonNull(routingContext);
    }

    public RoutingContext getRoutingContext() {
        return this.routingContext;
    }

    public <T> T get(String key) {
        return (T)this.routingContext.get(key);
    }

    public <T> T get(String key, T defaultValue) {
        Object value = this.routingContext.get(key);
        return (T)(value != null ? value : defaultValue);
    }

    public void put(String key, Object value) {
        this.routingContext.put(key, value);
    }

    public void setTracingContext(SpanContext spanContext) {
        this.spanContext = spanContext;
    }

    public SpanContext getTracingContext() {
        return this.spanContext;
    }
}

