/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.amqp;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.net.NetServerOptions;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.proton.ProtonConnection;
import io.vertx.proton.ProtonHelper;
import io.vertx.proton.ProtonLink;
import io.vertx.proton.ProtonReceiver;
import io.vertx.proton.ProtonSender;
import io.vertx.proton.ProtonServer;
import io.vertx.proton.ProtonServerOptions;
import io.vertx.proton.ProtonSession;
import io.vertx.proton.sasl.ProtonSaslAuthenticatorFactory;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.transport.AmqpError;
import org.apache.qpid.proton.amqp.transport.Source;
import org.eclipse.hono.auth.Activity;
import org.eclipse.hono.auth.HonoUser;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.AbstractServiceBase;
import org.eclipse.hono.service.amqp.AmqpEndpoint;
import org.eclipse.hono.service.auth.AuthorizationService;
import org.eclipse.hono.service.auth.ClaimsBasedAuthorizationService;
import org.eclipse.hono.util.Constants;
import org.eclipse.hono.util.HonoProtonHelper;
import org.eclipse.hono.util.ResourceIdentifier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AmqpServiceBase<T extends ServiceConfigProperties>
extends AbstractServiceBase<T> {
    private final Map<String, AmqpEndpoint> endpoints = new HashMap<String, AmqpEndpoint>();
    private ProtonServer server;
    private ProtonServer insecureServer;
    private ProtonSaslAuthenticatorFactory saslAuthenticatorFactory;
    private AuthorizationService authorizationService;

    protected abstract String getServiceName();

    @Autowired
    @Qualifier(value="amqp")
    public void setConfig(T configuration) {
        this.setSpecificConfig(configuration);
    }

    @Override
    public int getPortDefaultValue() {
        return 5671;
    }

    @Override
    public int getInsecurePortDefaultValue() {
        return 5672;
    }

    @Autowired(required=false)
    public void addEndpoints(List<AmqpEndpoint> definedEndpoints) {
        Objects.requireNonNull(definedEndpoints);
        for (AmqpEndpoint ep : definedEndpoints) {
            this.addEndpoint(ep);
        }
    }

    public final void addEndpoint(AmqpEndpoint ep) {
        if (this.endpoints.putIfAbsent(ep.getName(), ep) != null) {
            this.log.warn("multiple endpoints defined with name [{}]", (Object)ep.getName());
        } else {
            this.log.debug("registering endpoint [{}]", (Object)ep.getName());
        }
    }

    protected final AmqpEndpoint getEndpoint(ResourceIdentifier targetAddress) {
        return this.getEndpoint(targetAddress.getEndpoint());
    }

    protected final AmqpEndpoint getEndpoint(String endpointName) {
        return this.endpoints.get(endpointName);
    }

    protected final Iterable<AmqpEndpoint> endpoints() {
        return this.endpoints.values();
    }

    @Autowired(required=false)
    public void setSaslAuthenticatorFactory(ProtonSaslAuthenticatorFactory factory) {
        this.saslAuthenticatorFactory = Objects.requireNonNull(factory);
    }

    public final void setAuthorizationService(AuthorizationService authService) {
        this.authorizationService = authService;
    }

    protected final AuthorizationService getAuthorizationService() {
        return this.authorizationService;
    }

    @Override
    public Future<Void> startInternal() {
        if (this.authorizationService == null) {
            this.authorizationService = new ClaimsBasedAuthorizationService();
        }
        return this.preStartServers().compose(s -> this.checkPortConfiguration()).compose(s -> this.startEndpoints()).compose(s -> this.startSecureServer()).compose(s -> this.startInsecureServer());
    }

    protected final void closeExpiredConnection(ProtonConnection con) {
        HonoUser clientPrincipal;
        if (!con.isDisconnected() && (clientPrincipal = Constants.getClientPrincipal((ProtonConnection)con)) != null) {
            this.log.debug("client's [{}] access token has expired, closing connection", (Object)clientPrincipal.getName());
            con.disconnectHandler(null);
            con.closeHandler(null);
            con.setCondition(ProtonHelper.condition((Symbol)AmqpError.UNAUTHORIZED_ACCESS, (String)"access token expired"));
            con.close();
            con.disconnect();
            this.publishConnectionClosedEvent(con);
        }
    }

    protected Future<Void> preStartServers() {
        return Future.succeededFuture();
    }

    private Future<Void> startEndpoints() {
        ArrayList<Future<Void>> endpointFutures = new ArrayList<Future<Void>>(this.endpoints.size());
        for (AmqpEndpoint ep : this.endpoints.values()) {
            this.log.info("starting endpoint [name: {}, class: {}]", (Object)ep.getName(), (Object)ep.getClass().getName());
            endpointFutures.add(ep.start());
        }
        return CompositeFuture.all(endpointFutures).map(ok -> null).recover(t -> Future.failedFuture((Throwable)t));
    }

    private Future<Void> stopEndpoints() {
        ArrayList<Future<Void>> endpointFutures = new ArrayList<Future<Void>>(this.endpoints.size());
        for (AmqpEndpoint ep : this.endpoints.values()) {
            this.log.info("stopping endpoint [name: {}, class: {}]", (Object)ep.getName(), (Object)ep.getClass().getName());
            endpointFutures.add(ep.stop());
        }
        return CompositeFuture.all(endpointFutures).map(ok -> null).recover(t -> Future.failedFuture((Throwable)t));
    }

    private Future<Void> startInsecureServer() {
        if (this.isInsecurePortEnabled()) {
            int insecurePort = this.determineInsecurePort();
            Promise result = Promise.promise();
            ProtonServerOptions options = this.createInsecureServerOptions();
            this.insecureServer = this.createProtonServer(options).connectHandler(this::onRemoteConnectionOpenInsecurePort).listen(insecurePort, ((ServiceConfigProperties)this.getConfig()).getInsecurePortBindAddress(), bindAttempt -> {
                if (bindAttempt.succeeded()) {
                    if (this.getInsecurePort() == this.getInsecurePortDefaultValue()) {
                        this.log.info("server listens on standard insecure port [{}:{}]", (Object)this.getInsecurePortBindAddress(), (Object)this.getInsecurePort());
                    } else {
                        this.log.warn("server listens on non-standard insecure port [{}:{}], default is {}", new Object[]{this.getInsecurePortBindAddress(), this.getInsecurePort(), this.getInsecurePortDefaultValue()});
                    }
                    result.complete();
                } else {
                    this.log.error("cannot bind to insecure port", bindAttempt.cause());
                    result.fail(bindAttempt.cause());
                }
            });
            return result.future();
        }
        this.log.info("insecure port is not enabled");
        return Future.succeededFuture();
    }

    private Future<Void> startSecureServer() {
        if (this.isSecurePortEnabled()) {
            int securePort = this.determineSecurePort();
            Promise result = Promise.promise();
            ProtonServerOptions options = this.createServerOptions();
            this.server = this.createProtonServer(options).connectHandler(this::onRemoteConnectionOpen).listen(securePort, ((ServiceConfigProperties)this.getConfig()).getBindAddress(), bindAttempt -> {
                if (bindAttempt.succeeded()) {
                    if (this.getPort() == this.getPortDefaultValue()) {
                        this.log.info("server listens on standard secure port [{}:{}]", (Object)this.getBindAddress(), (Object)this.getPort());
                    } else {
                        this.log.warn("server listens on non-standard secure port [{}:{}], default is {}", new Object[]{this.getBindAddress(), this.getPort(), this.getPortDefaultValue()});
                    }
                    result.complete();
                } else {
                    this.log.error("cannot bind to secure port", bindAttempt.cause());
                    result.fail(bindAttempt.cause());
                }
            });
            return result.future();
        }
        this.log.info("secure port is not enabled");
        return Future.succeededFuture();
    }

    private ProtonServer createProtonServer(ProtonServerOptions options) {
        return ProtonServer.create((Vertx)this.vertx, (ProtonServerOptions)options).saslAuthenticatorFactory(this.saslAuthenticatorFactory);
    }

    protected ProtonServerOptions createServerOptions() {
        ProtonServerOptions options = this.createInsecureServerOptions();
        this.addTlsKeyCertOptions((NetServerOptions)options);
        this.addTlsTrustOptions((NetServerOptions)options);
        return options;
    }

    protected ProtonServerOptions createInsecureServerOptions() {
        ProtonServerOptions options = new ProtonServerOptions();
        options.setHeartbeat(10000);
        options.setMaxFrameSize(16384);
        options.setLogActivity(((ServiceConfigProperties)this.getConfig()).isNetworkDebugLoggingEnabled());
        return options;
    }

    @Override
    public final Future<Void> stopInternal() {
        return CompositeFuture.all(this.stopServer(), this.stopInsecureServer()).compose(s -> this.stopEndpoints());
    }

    private Future<Void> stopServer() {
        Promise secureTracker = Promise.promise();
        if (this.server != null) {
            this.log.info("stopping secure AMQP server [{}:{}]", (Object)this.getBindAddress(), (Object)this.getActualPort());
            this.server.close((Handler)secureTracker);
        } else {
            secureTracker.complete();
        }
        return secureTracker.future();
    }

    private Future<Void> stopInsecureServer() {
        Promise insecureTracker = Promise.promise();
        if (this.insecureServer != null) {
            this.log.info("stopping insecure AMQP server [{}:{}]", (Object)this.getInsecurePortBindAddress(), (Object)this.getActualInsecurePort());
            this.insecureServer.close((Handler)insecureTracker);
        } else {
            insecureTracker.complete();
        }
        return insecureTracker.future();
    }

    @Override
    protected final int getActualPort() {
        return this.server != null ? this.server.actualPort() : -1;
    }

    @Override
    protected final int getActualInsecurePort() {
        return this.insecureServer != null ? this.insecureServer.actualPort() : -1;
    }

    protected void onRemoteConnectionOpen(ProtonConnection connection) {
        connection.setContainer(String.format("%s-%s:%d", this.getServiceName(), this.getBindAddress(), this.getPort()));
        this.setRemoteConnectionOpenHandler(connection);
    }

    protected void onRemoteConnectionOpenInsecurePort(ProtonConnection connection) {
        connection.setContainer(String.format("%s-%s:%d", this.getServiceName(), this.getInsecurePortBindAddress(), this.getInsecurePort()));
        this.setRemoteConnectionOpenHandler(connection);
    }

    protected final void handleUnknownEndpoint(ProtonConnection con, ProtonLink<?> link, ResourceIdentifier address) {
        this.log.info("client [container: {}] wants to establish link for unknown endpoint [address: {}]", (Object)con.getRemoteContainer(), (Object)address);
        link.setCondition(ProtonHelper.condition((Symbol)AmqpError.NOT_FOUND, (String)String.format("no endpoint registered for address %s", address)));
        link.close();
    }

    protected final ResourceIdentifier getResourceIdentifier(String address) {
        if (((ServiceConfigProperties)this.getConfig()).isSingleTenant()) {
            return ResourceIdentifier.fromStringAssumingDefaultTenant((String)address);
        }
        return ResourceIdentifier.fromString((String)address);
    }

    protected void handleReceiverOpen(ProtonConnection con, ProtonReceiver receiver) {
        if (receiver.getRemoteTarget().getAddress() == null) {
            this.log.debug("client [container: {}] wants to open an anonymous link for sending messages to arbitrary addresses, closing link ...", (Object)con.getRemoteContainer());
            receiver.setCondition(ProtonHelper.condition((Symbol)AmqpError.NOT_ALLOWED, (String)"anonymous relay not supported"));
            receiver.close();
        } else {
            this.log.debug("client [container: {}] wants to open a link [address: {}] for sending messages", (Object)con.getRemoteContainer(), (Object)receiver.getRemoteTarget());
            try {
                ResourceIdentifier targetResource = this.getResourceIdentifier(receiver.getRemoteTarget().getAddress());
                AmqpEndpoint endpoint = this.getEndpoint(targetResource);
                if (endpoint == null) {
                    this.handleUnknownEndpoint(con, (ProtonLink<?>)receiver, targetResource);
                } else {
                    HonoUser user = Constants.getClientPrincipal((ProtonConnection)con);
                    this.getAuthorizationService().isAuthorized(user, targetResource, Activity.WRITE).onComplete(authAttempt -> {
                        if (authAttempt.succeeded() && ((Boolean)authAttempt.result()).booleanValue()) {
                            Constants.copyProperties((ProtonConnection)con, (ProtonLink)receiver);
                            receiver.setSource(receiver.getRemoteSource());
                            receiver.setTarget(receiver.getRemoteTarget());
                            endpoint.onLinkAttach(con, receiver, targetResource);
                        } else {
                            this.log.debug("subject [{}] is not authorized to WRITE to [{}]", (Object)user.getName(), (Object)targetResource);
                            receiver.setCondition(ProtonHelper.condition((String)AmqpError.UNAUTHORIZED_ACCESS.toString(), (String)"unauthorized"));
                            receiver.close();
                        }
                    });
                }
            }
            catch (IllegalArgumentException e) {
                this.log.debug("client has provided invalid resource identifier as target address", (Throwable)e);
                receiver.setCondition(ProtonHelper.condition((Symbol)AmqpError.NOT_FOUND, (String)"no such address"));
                receiver.close();
            }
        }
    }

    protected void handleSenderOpen(ProtonConnection con, ProtonSender sender) {
        Source remoteSource = sender.getRemoteSource();
        this.log.debug("client [container: {}] wants to open a link [address: {}] for receiving messages", (Object)con.getRemoteContainer(), (Object)remoteSource);
        try {
            ResourceIdentifier targetResource = this.getResourceIdentifier(remoteSource.getAddress());
            AmqpEndpoint endpoint = this.getEndpoint(targetResource);
            if (endpoint == null) {
                this.handleUnknownEndpoint(con, (ProtonLink<?>)sender, targetResource);
            } else {
                HonoUser user = Constants.getClientPrincipal((ProtonConnection)con);
                this.getAuthorizationService().isAuthorized(user, targetResource, Activity.READ).onComplete(authAttempt -> {
                    if (authAttempt.succeeded() && ((Boolean)authAttempt.result()).booleanValue()) {
                        Constants.copyProperties((ProtonConnection)con, (ProtonLink)sender);
                        sender.setSource(sender.getRemoteSource());
                        sender.setTarget(sender.getRemoteTarget());
                        endpoint.onLinkAttach(con, sender, targetResource);
                    } else {
                        this.log.debug("subject [{}] is not authorized to READ from [{}]", (Object)user.getName(), (Object)targetResource);
                        sender.setCondition(ProtonHelper.condition((String)AmqpError.UNAUTHORIZED_ACCESS.toString(), (String)"unauthorized"));
                        sender.close();
                    }
                });
            }
        }
        catch (IllegalArgumentException e) {
            this.log.debug("client has provided invalid resource identifier as target address", (Throwable)e);
            sender.setCondition(ProtonHelper.condition((Symbol)AmqpError.NOT_FOUND, (String)"no such address"));
            sender.close();
        }
    }

    protected void setRemoteConnectionOpenHandler(ProtonConnection connection) {
        this.log.debug("received connection request from client");
        connection.sessionOpenHandler(session -> {
            HonoProtonHelper.setDefaultCloseHandler((ProtonSession)session);
            this.handleSessionOpen(connection, (ProtonSession)session);
        });
        connection.receiverOpenHandler(receiver -> {
            HonoProtonHelper.setDefaultCloseHandler((ProtonLink)receiver);
            this.handleReceiverOpen(connection, (ProtonReceiver)receiver);
        });
        connection.senderOpenHandler(sender -> {
            HonoProtonHelper.setDefaultCloseHandler((ProtonLink)sender);
            this.handleSenderOpen(connection, (ProtonSender)sender);
        });
        connection.disconnectHandler(this::handleRemoteDisconnect);
        connection.closeHandler(remoteClose -> this.handleRemoteConnectionClose(connection, (AsyncResult<ProtonConnection>)remoteClose));
        connection.openHandler(remoteOpen -> {
            if (remoteOpen.failed()) {
                this.log.debug("ignoring peer's open frame containing error", remoteOpen.cause());
            } else {
                this.processRemoteOpen((ProtonConnection)remoteOpen.result());
            }
        });
    }

    protected void processRemoteOpen(ProtonConnection connection) {
        this.log.debug("processing open frame from client container [{}]", (Object)connection.getRemoteContainer());
        HonoUser clientPrincipal = Constants.getClientPrincipal((ProtonConnection)connection);
        connection.attachments().set((Object)"CONNECTION_ID", String.class, (Object)UUID.randomUUID().toString());
        this.processDesiredCapabilities(connection, connection.getRemoteDesiredCapabilities());
        Duration delay = Duration.between(Instant.now(), clientPrincipal.getExpirationTime());
        WeakReference<ProtonConnection> conRef = new WeakReference<ProtonConnection>(connection);
        this.vertx.setTimer(delay.toMillis(), timerId -> {
            if (conRef.get() != null) {
                this.closeExpiredConnection((ProtonConnection)conRef.get());
            }
        });
        connection.open();
        this.log.info("client connected [container: {}, user: {}, token valid until: {}]", new Object[]{connection.getRemoteContainer(), clientPrincipal.getName(), clientPrincipal.getExpirationTime().toString()});
    }

    protected void processDesiredCapabilities(ProtonConnection connection, Symbol[] desiredCapabilities) {
    }

    protected void handleSessionOpen(ProtonConnection con, ProtonSession session) {
        this.log.debug("opening new session with client [container: {}]", (Object)con.getRemoteContainer());
        session.open();
    }

    protected void publishConnectionClosedEvent(ProtonConnection con) {
        this.endpoints.values().forEach(endpoint -> endpoint.onConnectionClosed(con));
    }

    protected void handleRemoteConnectionClose(ProtonConnection con, AsyncResult<ProtonConnection> res) {
        if (res.succeeded()) {
            this.log.debug("client [container: {}] closed connection", (Object)con.getRemoteContainer());
        } else {
            this.log.debug("client [container: {}] closed connection with error", (Object)con.getRemoteContainer(), (Object)res.cause());
        }
        con.close();
        con.disconnect();
        this.publishConnectionClosedEvent(con);
    }

    protected void handleRemoteDisconnect(ProtonConnection con) {
        this.log.debug("client [container: {}] disconnected", (Object)con.getRemoteContainer());
        con.disconnect();
        this.publishConnectionClosedEvent(con);
    }

    @Override
    public void registerReadinessChecks(HealthCheckHandler handler) {
        for (AmqpEndpoint ep : this.endpoints()) {
            ep.registerReadinessChecks(handler);
        }
    }

    @Override
    public void registerLivenessChecks(HealthCheckHandler handler) {
        for (AmqpEndpoint ep : this.endpoints()) {
            ep.registerLivenessChecks(handler);
        }
    }
}

