/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.MIMEHeader;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.CorsHandler;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.AbstractEndpoint;
import org.eclipse.hono.service.http.HttpEndpoint;
import org.eclipse.hono.service.http.HttpUtils;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractHttpEndpoint<T extends ServiceConfigProperties>
extends AbstractEndpoint
implements HttpEndpoint {
    protected static final String KEY_REQUEST_BODY = "KEY_REQUEST_BODY";
    protected static final String PARAM_TENANT_ID = "tenant_id";
    protected static final String PARAM_DEVICE_ID = "device_id";
    protected static final String KEY_RESOURCE_VERSION = "KEY_RESOURCE_VERSION";
    protected T config;

    public AbstractHttpEndpoint(Vertx vertx) {
        super(vertx);
    }

    @Qualifier(value="rest")
    @Autowired(required=false)
    public final void setConfiguration(T props) {
        this.config = (ServiceConfigProperties)Objects.requireNonNull(props);
    }

    protected final void extractRequiredJson(RoutingContext ctx, Function<RoutingContext, Object> payloadExtractor) {
        Objects.requireNonNull(payloadExtractor);
        MIMEHeader contentType = ctx.parsedHeaders().contentType();
        if (contentType == null) {
            ctx.fail((Throwable)new ClientErrorException(400, "Missing Content-Type header"));
        } else if (!"application/json".equalsIgnoreCase(contentType.value())) {
            ctx.fail((Throwable)new ClientErrorException(400, "Unsupported Content-Type"));
        } else {
            try {
                if (ctx.getBody() != null) {
                    Object payload = payloadExtractor.apply(ctx);
                    if (payload != null) {
                        ctx.put(KEY_REQUEST_BODY, payload);
                        ctx.next();
                    } else {
                        ctx.fail((Throwable)new ClientErrorException(400, "Null body"));
                    }
                } else {
                    ctx.fail((Throwable)new ClientErrorException(400, "Empty body"));
                }
            }
            catch (DecodeException e) {
                ctx.fail((Throwable)new ClientErrorException(400, "Invalid JSON", (Throwable)e));
            }
        }
    }

    protected final void extractRequiredJsonPayload(RoutingContext ctx) {
        this.extractRequiredJson(ctx, RoutingContext::getBodyAsJson);
    }

    protected final void extractOptionalJsonPayload(RoutingContext ctx) {
        if (ctx.getBody().length() != 0) {
            this.extractRequiredJson(ctx, RoutingContext::getBodyAsJson);
        } else {
            ctx.put(KEY_REQUEST_BODY, (Object)new JsonObject());
            ctx.next();
        }
    }

    protected final void extractRequiredJsonArrayPayload(RoutingContext ctx) {
        this.extractRequiredJson(ctx, body -> body.getBodyAsJsonArray());
    }

    protected final String getTenantParam(RoutingContext ctx) {
        return ctx.request().getParam(PARAM_TENANT_ID);
    }

    protected final String getDeviceIdParam(RoutingContext ctx) {
        return ctx.request().getParam(PARAM_DEVICE_ID);
    }

    protected final String getMandatoryIdRequestParam(String paramName, RoutingContext ctx, Span span) {
        return this.getRequestIdParam(paramName, ctx, span, false);
    }

    protected final String getRequestIdParam(String paramName, RoutingContext ctx, Span span, boolean optional) {
        String msg;
        String regex;
        String value = ctx.request().getParam(paramName);
        switch (paramName) {
            case "tenant_id": {
                regex = this.config.getTenantIdRegex();
                break;
            }
            case "device_id": {
                regex = this.config.getDeviceIdRegex();
                break;
            }
            default: {
                regex = ".+";
            }
        }
        if (value != null) {
            if (value.matches(regex)) {
                span.setTag(paramName, value);
                return value;
            }
            msg = String.format("%s does not match allowed pattern: %s", value, regex);
            HttpUtils.badRequest(ctx, msg);
            this.finishSpanWithError(span, 400, msg);
            return null;
        }
        if (!optional) {
            msg = String.format("Missing request parameter: %s", paramName);
            HttpUtils.badRequest(ctx, msg);
            this.finishSpanWithError(span, 400, msg);
            return null;
        }
        span.setTag(paramName, value);
        return value;
    }

    protected final void finishSpanWithError(Span span, int httpErrorCode, String errorMessage) {
        TracingHelper.logError((Span)span, (String)errorMessage);
        Tags.HTTP_STATUS.set(span, Integer.valueOf(httpErrorCode));
        span.finish();
    }

    protected void extractIfMatchVersionParam(RoutingContext ctx) {
        String ifMatchHeader = ctx.request().getHeader(HttpHeaders.IF_MATCH);
        if (!Strings.isNullOrEmpty((Object)ifMatchHeader)) {
            ctx.put(KEY_RESOURCE_VERSION, (Object)ifMatchHeader);
        }
        ctx.next();
    }

    protected final CorsHandler createDefaultCorsHandler(String allowedOrigin) {
        return this.createCorsHandler(allowedOrigin, EnumSet.of(HttpMethod.POST, HttpMethod.GET, HttpMethod.PUT, HttpMethod.DELETE));
    }

    protected final CorsHandler createCorsHandler(String allowedOrigin, Set<HttpMethod> methods) {
        return CorsHandler.create((String)allowedOrigin).allowedMethods(methods).allowedHeader(HttpHeaders.CONTENT_TYPE.toString()).allowedHeader(HttpHeaders.AUTHORIZATION.toString()).allowedHeader(HttpHeaders.IF_MATCH.toString()).exposedHeader(HttpHeaders.ETAG.toString());
    }
}

