/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PreDestroy;
import org.eclipse.hono.config.ApplicationConfigProperties;
import org.eclipse.hono.service.HealthCheckProvider;
import org.eclipse.hono.service.HealthCheckServer;
import org.eclipse.hono.service.NoopHealthCheckServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;

public abstract class AbstractBaseApplication
implements ApplicationRunner {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private ApplicationConfigProperties config = new ApplicationConfigProperties();
    private Vertx vertx;
    private HealthCheckServer healthCheckServer = new NoopHealthCheckServer();

    @Autowired
    public final void setVertx(Vertx vertx) {
        this.vertx = Objects.requireNonNull(vertx);
    }

    protected final Vertx getVertx() {
        return this.vertx;
    }

    @Autowired(required=false)
    public final void setApplicationConfiguration(ApplicationConfigProperties config) {
        this.config = Objects.requireNonNull(config);
    }

    protected final ApplicationConfigProperties getConfig() {
        return this.config;
    }

    @Autowired(required=false)
    public final void setHealthCheckServer(HealthCheckServer healthCheckServer) {
        this.healthCheckServer = Objects.requireNonNull(healthCheckServer);
    }

    protected void preFlightCheck() throws IllegalStateException {
    }

    public void run(ApplicationArguments args) {
        if (this.vertx == null) {
            throw new IllegalStateException("no Vert.x instance has been configured");
        }
        this.preFlightCheck();
        if (this.log.isInfoEnabled()) {
            this.log.info("running on Java VM [version: {}, name: {}, vendor: {}, max memory: {}MB, processors: {}]", new Object[]{System.getProperty("java.version"), System.getProperty("java.vm.name"), System.getProperty("java.vm.vendor"), Runtime.getRuntime().maxMemory() >> 20, Runtime.getRuntime().availableProcessors()});
        }
        CompletableFuture started = new CompletableFuture();
        this.deployVerticles().compose(s -> this.postRegisterServiceVerticles()).compose(s -> this.healthCheckServer.start()).onComplete(result -> {
            if (result.failed()) {
                started.completeExceptionally(result.cause());
            } else {
                started.complete(null);
            }
        });
        int startupTimeoutSeconds = this.config.getStartupTimeout();
        try {
            this.log.debug("Waiting {} seconds for application to start up", (Object)startupTimeoutSeconds);
            started.get(startupTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            this.log.error("startup timed out after {} seconds, shutting down ...", (Object)startupTimeoutSeconds);
            this.shutdown();
        }
        catch (InterruptedException e) {
            this.log.error("startup process has been interrupted, shutting down ...");
            Thread.currentThread().interrupt();
            this.shutdown();
        }
        catch (ExecutionException e) {
            this.log.error("exception occurred during startup, shutting down ...", (Throwable)e);
            this.shutdown();
        }
    }

    protected Future<?> deployVerticles() {
        return Future.succeededFuture();
    }

    @PreDestroy
    public final void shutdown() {
        int shutdownTimeoutSeconds = this.config.getStartupTimeout();
        this.shutdown(shutdownTimeoutSeconds, (Handler<Boolean>)((Handler)succeeded -> {}));
    }

    public final void shutdown(long maxWaitTime, Handler<Boolean> shutdownHandler) {
        try {
            this.log.info("shutting down application...");
            this.preShutdown();
            CountDownLatch latch = new CountDownLatch(1);
            this.stopHealthCheckServer().onComplete(result -> {
                if (this.vertx != null) {
                    this.log.info("closing vert.x instance ...");
                    this.vertx.close(r -> {
                        if (r.failed()) {
                            this.log.error("could not close vert.x instance", r.cause());
                        }
                        latch.countDown();
                    });
                } else {
                    latch.countDown();
                }
            });
            if (latch.await(maxWaitTime, TimeUnit.SECONDS)) {
                this.log.info("application has been shut down successfully");
                shutdownHandler.handle((Object)Boolean.TRUE);
            } else {
                this.log.error("shut down timed out, aborting...");
                shutdownHandler.handle((Object)Boolean.FALSE);
            }
        }
        catch (InterruptedException e) {
            this.log.error("application shut down has been interrupted, aborting...");
            Thread.currentThread().interrupt();
            shutdownHandler.handle((Object)Boolean.FALSE);
        }
    }

    private Future<Void> stopHealthCheckServer() {
        return this.healthCheckServer.stop();
    }

    protected Future<?> postRegisterServiceVerticles() {
        return Future.succeededFuture();
    }

    protected void preShutdown() {
    }

    protected final void registerHealthchecks(HealthCheckProvider provider) {
        Optional.ofNullable(provider).ifPresent(p -> {
            this.log.debug("registering health checks [provider: {}]", (Object)p.getClass().getName());
            this.healthCheckServer.registerHealthCheckResources((HealthCheckProvider)p);
        });
    }
}

