/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.registration;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import java.util.Objects;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.amqp.AbstractRequestResponseEndpoint;
import org.eclipse.hono.service.registration.RegistrationMessageFilter;
import org.eclipse.hono.service.registration.RegistrationService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.RegistrationConstants;
import org.eclipse.hono.util.RegistrationResult;
import org.eclipse.hono.util.RequestResponseResult;
import org.eclipse.hono.util.ResourceIdentifier;

public abstract class AbstractRegistrationAmqpEndpoint
extends AbstractRequestResponseEndpoint<ServiceConfigProperties> {
    private static final String SPAN_NAME_ASSERT_DEVICE_REGISTRATION = "assert Device Registration";

    public AbstractRegistrationAmqpEndpoint(Vertx vertx) {
        super(vertx);
    }

    @Override
    public final String getName() {
        return "registration";
    }

    protected abstract RegistrationService getService();

    @Override
    protected Future<Message> handleRequestMessage(Message requestMessage, ResourceIdentifier targetAddress) {
        String operation;
        Objects.requireNonNull(requestMessage);
        switch (operation = requestMessage.getSubject()) {
            case "assert": {
                return this.processAssertRequest(requestMessage, targetAddress);
            }
        }
        return this.processCustomRegistrationMessage(requestMessage);
    }

    private Future<Message> processAssertRequest(Message request, ResourceIdentifier targetAddress) {
        Future resultFuture;
        String tenantId = targetAddress.getTenantId();
        String deviceId = MessageHelper.getDeviceId((Message)request);
        String gatewayId = MessageHelper.getGatewayId((Message)request);
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)TracingHelper.extractSpanContext((Tracer)this.tracer, (Message)request), (String)SPAN_NAME_ASSERT_DEVICE_REGISTRATION, (String)this.getClass().getSimpleName()).start();
        if (tenantId == null || deviceId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant and/or device");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            Future<RegistrationResult> result;
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
            if (gatewayId == null) {
                this.log.debug("asserting registration of device [{}] with tenant [{}]", (Object)deviceId, (Object)tenantId);
                result = this.getService().assertRegistration(tenantId, deviceId, span);
            } else {
                TracingHelper.TAG_GATEWAY_ID.set(span, gatewayId);
                this.log.debug("asserting registration of device [{}] with tenant [{}] for gateway [{}]", new Object[]{deviceId, tenantId, gatewayId});
                result = this.getService().assertRegistration(tenantId, deviceId, gatewayId, span);
            }
            resultFuture = result.map(res -> RegistrationConstants.getAmqpReply((String)"registration", (String)tenantId, (Message)request, (RequestResponseResult)res));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<Message>)resultFuture);
    }

    protected Future<Message> processCustomRegistrationMessage(Message request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getSubject());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    @Override
    protected boolean passesFormalVerification(ResourceIdentifier linkTarget, Message msg) {
        return RegistrationMessageFilter.verify(linkTarget, msg);
    }
}

