/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.credentials;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.amqp.AbstractRequestResponseEndpoint;
import org.eclipse.hono.service.credentials.CredentialsMessageFilter;
import org.eclipse.hono.service.credentials.CredentialsService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CredentialsConstants;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.RequestResponseResult;
import org.eclipse.hono.util.ResourceIdentifier;

public abstract class AbstractCredentialsAmqpEndpoint
extends AbstractRequestResponseEndpoint<ServiceConfigProperties> {
    private static final String SPAN_NAME_GET_CREDENTIALS = "get Credentials";

    public AbstractCredentialsAmqpEndpoint(Vertx vertx) {
        super(vertx);
    }

    @Override
    public final String getName() {
        return "credentials";
    }

    protected abstract CredentialsService getService();

    @Override
    protected Future<Message> handleRequestMessage(Message requestMessage, ResourceIdentifier targetAddress) {
        Objects.requireNonNull(requestMessage);
        switch (CredentialsConstants.CredentialsAction.from((String)requestMessage.getSubject())) {
            case get: {
                return this.processGetRequest(requestMessage, targetAddress);
            }
        }
        return this.processCustomCredentialsMessage(requestMessage);
    }

    protected Future<Message> processGetRequest(Message request, ResourceIdentifier targetAddress) {
        Future resultFuture;
        JsonObject payload;
        String tenantId = targetAddress.getTenantId();
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)TracingHelper.extractSpanContext((Tracer)this.tracer, (Message)request), (String)SPAN_NAME_GET_CREDENTIALS, (String)this.getClass().getSimpleName()).start();
        try {
            payload = MessageHelper.getJsonPayload((Message)request);
        }
        catch (DecodeException e) {
            this.logger.debug("failed to decode AMQP request message", (Throwable)e);
            return this.finishSpanOnFutureCompletion(span, (Future<Message>)Future.failedFuture((Throwable)new ClientErrorException(400, "request message body contains malformed JSON")));
        }
        if (tenantId == null || payload == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant and/or payload");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            String type = AbstractCredentialsAmqpEndpoint.removeTypesafeValueForField(String.class, payload, "type");
            String authId = AbstractCredentialsAmqpEndpoint.removeTypesafeValueForField(String.class, payload, "auth-id");
            String deviceId = AbstractCredentialsAmqpEndpoint.removeTypesafeValueForField(String.class, payload, "device-id");
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            if (type == null) {
                TracingHelper.logError((Span)span, (String)"missing type");
                resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
            } else if (authId != null && deviceId == null) {
                resultFuture = this.processGetByAuthIdRequest(request, tenantId, payload, type, authId, span);
            } else if (deviceId != null && authId == null) {
                resultFuture = this.processGetByDeviceIdRequest(request, tenantId, type, deviceId, span);
            } else {
                TracingHelper.logError((Span)span, (String)String.format("invalid search criteria [type: %s, device-id: %s, auth-id: %s]", type, deviceId, authId));
                this.log.debug("get credentials request contains invalid search criteria [type: {}, device-id: {}, auth-id: {}]", new Object[]{type, deviceId, authId});
                resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
            }
        }
        return this.finishSpanOnFutureCompletion(span, (Future<Message>)resultFuture);
    }

    protected Future<Message> processGetByDeviceIdRequest(Message request, String tenantId, String type, String deviceId, Span span) {
        return Future.failedFuture((Throwable)new ClientErrorException(501));
    }

    private Future<Message> processGetByAuthIdRequest(Message request, String tenantId, JsonObject payload, String type, String authId, Span span) {
        this.log.debug("getting credentials [tenant: {}, type: {}, auth-id: {}]", new Object[]{tenantId, type, authId});
        TracingHelper.TAG_CREDENTIALS_TYPE.set(span, type);
        TracingHelper.TAG_AUTH_ID.set(span, authId);
        return this.getService().get(tenantId, type, authId, payload, span).map(res -> {
            String deviceIdFromPayload = Optional.ofNullable((JsonObject)res.getPayload()).map(p -> AbstractCredentialsAmqpEndpoint.getTypesafeValueForField(String.class, p, "device-id")).orElse(null);
            if (deviceIdFromPayload != null) {
                span.setTag("device_id", deviceIdFromPayload);
            }
            return CredentialsConstants.getAmqpReply((String)"credentials", (String)tenantId, (Message)request, (RequestResponseResult)res);
        });
    }

    protected Future<Message> processCustomCredentialsMessage(Message request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getSubject());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    @Override
    protected boolean passesFormalVerification(ResourceIdentifier linkTarget, Message msg) {
        return CredentialsMessageFilter.verify(linkTarget, msg);
    }
}

