/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopTracerFactory;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import java.util.Objects;
import org.eclipse.hono.service.Endpoint;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractEndpoint
implements Endpoint {
    protected final Vertx vertx;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Tracer tracer = NoopTracerFactory.create();

    protected AbstractEndpoint(Vertx vertx) {
        this.vertx = Objects.requireNonNull(vertx);
    }

    @Autowired(required=false)
    public final void setTracer(Tracer opentracingTracer) {
        this.logger.info("using OpenTracing Tracer implementation [{}]", (Object)opentracingTracer.getClass().getName());
        this.tracer = Objects.requireNonNull(opentracingTracer);
    }

    @Override
    public final Future<Void> start() {
        Promise result = Promise.promise();
        if (this.vertx == null) {
            result.fail((Throwable)new IllegalStateException("Vert.x instance must be set"));
        } else {
            this.doStart((Promise<Void>)result);
        }
        return result.future();
    }

    protected void doStart(Promise<Void> startPromise) {
        startPromise.complete();
    }

    @Override
    public final Future<Void> stop() {
        Promise result = Promise.promise();
        this.doStop((Promise<Void>)result);
        return result.future();
    }

    protected void doStop(Promise<Void> stopPromise) {
        stopPromise.complete();
    }

    @Override
    public void registerLivenessChecks(HealthCheckHandler handler) {
    }

    @Override
    public void registerReadinessChecks(HealthCheckHandler handler) {
    }

    protected final DeliveryOptions createEventBusMessageDeliveryOptions(long sendTimeOutInMs, SpanContext spanContext) {
        DeliveryOptions deliveryOptions = new DeliveryOptions();
        deliveryOptions.setSendTimeout(sendTimeOutInMs);
        TracingHelper.injectSpanContext((Tracer)this.tracer, (SpanContext)spanContext, (DeliveryOptions)deliveryOptions);
        return deliveryOptions;
    }
}

