/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.registration;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.EventBusService;
import org.eclipse.hono.service.registration.RegistrationService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.EventBusMessage;
import org.eclipse.hono.util.RegistrationResult;

@Deprecated
public abstract class EventBusRegistrationAdapter
extends EventBusService
implements Verticle {
    public static final int DEFAULT_MAX_AGE_SECONDS = 300;
    private static final String SPAN_NAME_ASSERT_DEVICE_REGISTRATION = "assert Device Registration";

    protected abstract RegistrationService getService();

    @Override
    protected String getEventBusAddress() {
        return "registration.in";
    }

    @Override
    public Future<EventBusMessage> processRequest(EventBusMessage requestMessage) {
        Objects.requireNonNull(requestMessage);
        switch (requestMessage.getOperation()) {
            case "assert": {
                return this.processAssertRequest(requestMessage);
            }
        }
        return this.processCustomRegistrationMessage(requestMessage);
    }

    private Future<EventBusMessage> processAssertRequest(EventBusMessage request) {
        Future resultFuture;
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        String gatewayId = request.getGatewayId();
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)request.getSpanContext(), (String)SPAN_NAME_ASSERT_DEVICE_REGISTRATION, (String)((Object)((Object)this)).getClass().getSimpleName()).start();
        if (tenantId == null || deviceId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant and/or device");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
            resultFuture = Optional.ofNullable(gatewayId).map(ok -> {
                this.log.debug("asserting registration of device [{}] with tenant [{}] for gateway [{}]", new Object[]{deviceId, tenantId, gatewayId});
                TracingHelper.TAG_GATEWAY_ID.set(span, gatewayId);
                return this.getService().assertRegistration(tenantId, deviceId, gatewayId, span);
            }).orElseGet(() -> {
                this.log.debug("asserting registration of device [{}] with tenant [{}]", (Object)deviceId, (Object)tenantId);
                return this.getService().assertRegistration(tenantId, deviceId, span);
            }).map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective()));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }

    protected Future<EventBusMessage> processCustomRegistrationMessage(EventBusMessage request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getOperation());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    protected boolean isGatewaySupportedForDevice(String tenantId, String deviceId, JsonObject registrationInfo) {
        Object viaObj = registrationInfo.getValue("via");
        return viaObj instanceof String && !((String)viaObj).isEmpty() || viaObj instanceof JsonArray && !((JsonArray)viaObj).isEmpty();
    }

    protected void handleUnimplementedOperation(Handler<AsyncResult<RegistrationResult>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)RegistrationResult.from((int)501)));
    }

    protected boolean isGatewayAuthorized(String gatewayId, JsonObject gatewayData, String deviceId, JsonObject deviceData) {
        Objects.requireNonNull(gatewayId);
        Objects.requireNonNull(gatewayData);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(deviceData);
        Object obj = deviceData.getValue("via");
        if (obj instanceof String) {
            return gatewayId.equals(obj);
        }
        if (obj instanceof JsonArray) {
            return ((JsonArray)obj).stream().filter(o -> o instanceof String).anyMatch(id -> gatewayId.equals(id));
        }
        return false;
    }

    protected CacheDirective getRegistrationAssertionCacheDirective(String deviceId, String tenantId) {
        return CacheDirective.maxAgeDirective((long)300L);
    }

    protected static final JsonObject getResultPayload(String deviceId, JsonObject data) {
        return new JsonObject().put("device-id", deviceId).put("data", data);
    }
}

