/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.tenant;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.http.AbstractHttpEndpoint;
import org.eclipse.hono.service.http.HttpUtils;
import org.eclipse.hono.service.http.TracingHandler;
import org.eclipse.hono.service.management.Id;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.service.management.Result;
import org.eclipse.hono.service.management.tenant.Tenant;
import org.eclipse.hono.service.management.tenant.TenantManagementService;
import org.eclipse.hono.tracing.TracingHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractTenantManagementHttpEndpoint
extends AbstractHttpEndpoint<ServiceConfigProperties> {
    private static final String SPAN_NAME_GET_TENANT = "get Tenant from management API";
    private static final String SPAN_NAME_CREATE_TENANT = "create Tenant from management API";
    private static final String SPAN_NAME_UPDATE_TENANT = "update Tenant from management API";
    private static final String SPAN_NAME_REMOVE_TENANT = "remove Tenant from management API";
    private static final String TENANT_MANAGEMENT_ENDPOINT_NAME = String.format("%s/%s", "v1", "tenants");

    @Autowired
    public AbstractTenantManagementHttpEndpoint(Vertx vertx) {
        super(Objects.requireNonNull(vertx));
    }

    @Override
    public String getName() {
        return TENANT_MANAGEMENT_ENDPOINT_NAME;
    }

    @Override
    public void addRoutes(Router router) {
        String path = String.format("/%s", this.getName());
        String pathWithTenant = String.format("/%s/:%s", this.getName(), "tenant_id");
        router.route(path).handler((Handler)this.createCorsHandler(this.config.getCorsAllowedOrigin(), EnumSet.of(HttpMethod.POST)));
        router.route(pathWithTenant).handler((Handler)this.createDefaultCorsHandler(this.config.getCorsAllowedOrigin()));
        BodyHandler bodyHandler = BodyHandler.create();
        bodyHandler.setBodyLimit((long)this.config.getMaxPayloadSize());
        router.post(path).handler((Handler)bodyHandler);
        router.post(path).handler(this::extractOptionalJsonPayload);
        router.post(path).handler(this::createTenant);
        router.post(pathWithTenant).handler((Handler)bodyHandler);
        router.post(pathWithTenant).handler(this::extractOptionalJsonPayload);
        router.post(pathWithTenant).handler(this::updatePayloadWithTenantId);
        router.post(pathWithTenant).handler(this::createTenant);
        router.get(pathWithTenant).handler(this::getTenant);
        router.put(pathWithTenant).handler((Handler)bodyHandler);
        router.put(pathWithTenant).handler(this::extractRequiredJsonPayload);
        router.put(pathWithTenant).handler(this::extractIfMatchVersionParam);
        router.put(pathWithTenant).handler(this::updateTenant);
        router.delete(pathWithTenant).handler(this::extractIfMatchVersionParam);
        router.delete(pathWithTenant).handler(this::deleteTenant);
    }

    protected abstract TenantManagementService getService();

    protected final void updatePayloadWithTenantId(RoutingContext ctx) {
        JsonObject payload = (JsonObject)ctx.get("KEY_REQUEST_BODY");
        String tenantId = this.getTenantIdFromContext(ctx);
        if (tenantId.isBlank()) {
            ctx.fail((Throwable)new ClientErrorException(400, String.format("'%s' param cannot be empty", "tenant-id")));
        }
        payload.put("tenant-id", tenantId);
        ctx.put("KEY_REQUEST_BODY", (Object)payload);
        ctx.next();
    }

    private String getTenantIdFromContext(RoutingContext ctx) {
        JsonObject payload = (JsonObject)ctx.get("KEY_REQUEST_BODY");
        return Optional.ofNullable(this.getTenantParam(ctx)).orElse(AbstractTenantManagementHttpEndpoint.getTenantParamFromPayload(payload));
    }

    private void createTenant(RoutingContext ctx) {
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)TracingHandler.serverSpanContext(ctx), (String)SPAN_NAME_CREATE_TENANT, (String)this.getClass().getSimpleName()).start();
        String tenantId = this.getRequestParam("tenant_id", ctx, span, true);
        JsonObject payload = this.getRequestPayload((JsonObject)ctx.get("KEY_REQUEST_BODY"));
        if (this.isValidRequestPayload(payload)) {
            this.logger.debug("creating tenant [{}]", (Object)Optional.ofNullable(tenantId).orElse("<auto>"));
            this.addNotPresentFieldsWithDefaultValuesForTenant(payload);
            this.getService().createTenant(Optional.ofNullable(tenantId), (Tenant)payload.mapTo(Tenant.class), span).setHandler(handler -> {
                OperationResult operationResult = (OperationResult)handler.result();
                String createdTenantId = Optional.ofNullable((Id)operationResult.getPayload()).map(Id::getId).orElse(null);
                this.writeOperationResponse(ctx, operationResult, (Handler<HttpServerResponse>)((Handler)response -> response.putHeader(HttpHeaders.LOCATION, (CharSequence)String.format("/%s/%s", this.getName(), createdTenantId))), span);
            });
        } else {
            String msg = "request contains malformed payload";
            this.logger.debug("request contains malformed payload");
            TracingHelper.logError((Span)span, (String)"request contains malformed payload");
            Tags.HTTP_STATUS.set(span, Integer.valueOf(400));
            HttpUtils.badRequest(ctx, "request contains malformed payload");
            span.finish();
        }
    }

    private void getTenant(RoutingContext ctx) {
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)TracingHandler.serverSpanContext(ctx), (String)SPAN_NAME_GET_TENANT, (String)this.getClass().getSimpleName()).start();
        String tenantId = this.getMandatoryRequestParam("tenant_id", ctx, span);
        HttpServerResponse response = ctx.response();
        this.logger.debug("retrieving tenant [id: {}]", (Object)tenantId);
        this.getService().readTenant(tenantId, span).setHandler(handler -> {
            OperationResult operationResult = (OperationResult)handler.result();
            int status = operationResult.getStatus();
            response.setStatusCode(status);
            switch (status) {
                case 200: {
                    operationResult.getResourceVersion().ifPresent(v -> response.putHeader(HttpHeaders.ETAG, (CharSequence)v));
                    HttpUtils.setResponseBody(response, JsonObject.mapFrom(operationResult.getPayload()));
                }
            }
            Tags.HTTP_STATUS.set(span, Integer.valueOf(status));
            span.finish();
            response.end();
        });
    }

    private void updateTenant(RoutingContext ctx) {
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)TracingHandler.serverSpanContext(ctx), (String)SPAN_NAME_UPDATE_TENANT, (String)this.getClass().getSimpleName()).start();
        String tenantId = this.getMandatoryRequestParam("tenant_id", ctx, span);
        JsonObject payload = this.getRequestPayload((JsonObject)ctx.get("KEY_REQUEST_BODY"));
        if (payload != null) {
            payload.remove("tenant-id");
        }
        if (this.isValidRequestPayload(payload)) {
            this.logger.debug("updating tenant [{}]", (Object)tenantId);
            this.addNotPresentFieldsWithDefaultValuesForTenant(payload);
            Optional<String> resourceVersion = Optional.ofNullable((String)ctx.get("KEY_RESOURCE_VERSION"));
            this.getService().updateTenant(tenantId, (Tenant)payload.mapTo(Tenant.class), resourceVersion, span).setHandler(handler -> this.writeOperationResponse(ctx, (OperationResult)handler.result(), null, span));
        } else {
            String msg = "request contains malformed payload";
            this.logger.debug("request contains malformed payload");
            TracingHelper.logError((Span)span, (String)"request contains malformed payload");
            Tags.HTTP_STATUS.set(span, Integer.valueOf(400));
            HttpUtils.badRequest(ctx, "request contains malformed payload");
            span.finish();
        }
    }

    private void deleteTenant(RoutingContext ctx) {
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)TracingHandler.serverSpanContext(ctx), (String)SPAN_NAME_REMOVE_TENANT, (String)this.getClass().getSimpleName()).start();
        String tenantId = this.getMandatoryRequestParam("tenant_id", ctx, span);
        this.logger.debug("removing tenant [{}]", (Object)tenantId);
        Optional<String> resourceVersion = Optional.ofNullable((String)ctx.get("KEY_RESOURCE_VERSION"));
        this.getService().deleteTenant(tenantId, resourceVersion, span).setHandler(handler -> this.writeResponse(ctx, (Result)handler.result(), null, span));
    }

    private static String getTenantParamFromPayload(JsonObject payload) {
        return payload != null ? (String)payload.remove("tenant-id") : null;
    }

    protected final boolean isValidRequestPayload(JsonObject payload) {
        Objects.requireNonNull(payload);
        try {
            return ((Tenant)payload.mapTo(Tenant.class)).isValid();
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("Error parsing payload of tenant request", (Throwable)e);
            return false;
        }
    }

    protected final void addNotPresentFieldsWithDefaultValuesForTenant(JsonObject checkedPayload) {
        JsonArray adapters = checkedPayload.getJsonArray("adapters");
        if (adapters != null) {
            adapters.forEach(elem -> this.addNotPresentFieldsWithDefaultValuesForAdapter((JsonObject)elem));
        }
    }

    private void addNotPresentFieldsWithDefaultValuesForAdapter(JsonObject adapter) {
        if (!adapter.containsKey("enabled")) {
            this.logger.trace("adding 'enabled' key to payload");
            adapter.put("enabled", Boolean.TRUE);
        }
        if (!adapter.containsKey("device-authentication-required")) {
            this.logger.trace("adding 'device-authentication-required' key to adapter payload");
            adapter.put("device-authentication-required", Boolean.TRUE);
        }
    }
}

