/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.device;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.EnumSet;
import java.util.Optional;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.http.AbstractHttpEndpoint;
import org.eclipse.hono.service.http.HttpUtils;
import org.eclipse.hono.service.http.TracingHandler;
import org.eclipse.hono.service.management.Id;
import org.eclipse.hono.service.management.OperationResult;
import org.eclipse.hono.service.management.Result;
import org.eclipse.hono.service.management.device.Device;
import org.eclipse.hono.service.management.device.DeviceManagementService;
import org.eclipse.hono.tracing.TracingHelper;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractDeviceManagementHttpEndpoint
extends AbstractHttpEndpoint<ServiceConfigProperties> {
    private static final String SPAN_NAME_CREATE_DEVICE = "create Device from management API";
    private static final String SPAN_NAME_GET_DEVICE = "get Device from management API";
    private static final String SPAN_NAME_UPDATE_DEVICE = "update Device from management API";
    private static final String SPAN_NAME_REMOVE_DEVICE = "remove Device from management API";
    private static final String DEVICE_MANAGEMENT_ENDPOINT_NAME = String.format("%s/%s", "v1", "devices");

    @Autowired
    public AbstractDeviceManagementHttpEndpoint(Vertx vertx) {
        super(vertx);
    }

    @Override
    public String getName() {
        return DEVICE_MANAGEMENT_ENDPOINT_NAME;
    }

    @Override
    public void addRoutes(Router router) {
        String pathWithTenant = String.format("/%s/:%s", this.getName(), "tenant_id");
        String pathWithTenantAndDeviceId = String.format("/%s/:%s/:%s", this.getName(), "tenant_id", "device_id");
        router.route(pathWithTenant).handler((Handler)this.createCorsHandler(this.config.getCorsAllowedOrigin(), EnumSet.of(HttpMethod.POST)));
        router.route(pathWithTenantAndDeviceId).handler((Handler)this.createDefaultCorsHandler(this.config.getCorsAllowedOrigin()));
        router.post(pathWithTenant).handler(this::extractOptionalJsonPayload).handler(this::doCreateDevice);
        router.post(pathWithTenantAndDeviceId).handler(this::extractOptionalJsonPayload).handler(this::doCreateDevice);
        router.get(pathWithTenantAndDeviceId).handler(this::doGetDevice);
        router.put(pathWithTenantAndDeviceId).handler(this::extractRequiredJsonPayload).handler(this::extractIfMatchVersionParam).handler(this::doUpdateDevice);
        router.delete(pathWithTenantAndDeviceId).handler(this::extractIfMatchVersionParam).handler(this::doDeleteDevice);
    }

    protected abstract DeviceManagementService getService();

    private void doGetDevice(RoutingContext ctx) {
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)TracingHandler.serverSpanContext(ctx), (String)SPAN_NAME_GET_DEVICE, (String)this.getClass().getSimpleName()).start();
        String deviceId = this.getMandatoryRequestParam("device_id", ctx, span);
        String tenantId = this.getMandatoryRequestParam("tenant_id", ctx, span);
        HttpServerResponse response = ctx.response();
        this.logger.debug("retrieving device [{}] of tenant [{}]", (Object)deviceId, (Object)tenantId);
        this.getService().readDevice(tenantId, deviceId, span).setHandler(handler -> {
            OperationResult operationResult = (OperationResult)handler.result();
            int status = operationResult.getStatus();
            response.setStatusCode(status);
            switch (status) {
                case 200: {
                    operationResult.getResourceVersion().ifPresent(v -> response.putHeader(HttpHeaders.ETAG, (CharSequence)v));
                    HttpUtils.setResponseBody(response, JsonObject.mapFrom(operationResult.getPayload()));
                }
            }
            Tags.HTTP_STATUS.set(span, Integer.valueOf(status));
            span.finish();
            response.end();
        });
    }

    private void doCreateDevice(RoutingContext ctx) {
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)TracingHandler.serverSpanContext(ctx), (String)SPAN_NAME_CREATE_DEVICE, (String)this.getClass().getSimpleName()).start();
        String tenantId = this.getMandatoryRequestParam("tenant_id", ctx, span);
        String deviceId = this.getRequestParam("device_id", ctx, span, true);
        JsonObject payload = (JsonObject)ctx.get("KEY_REQUEST_BODY");
        if (payload == null) {
            String msg = "Missing request body";
            TracingHelper.logError((Span)span, (String)"Missing request body");
            Tags.HTTP_STATUS.set(span, Integer.valueOf(400));
            HttpUtils.badRequest(ctx, "Missing request body");
            span.finish();
            return;
        }
        this.logger.debug("creating device [tenant: {}, device: {}, payload: {}]", new Object[]{tenantId, deviceId, payload});
        Device device = AbstractDeviceManagementHttpEndpoint.fromPayload(payload);
        this.getService().createDevice(tenantId, Optional.ofNullable(deviceId), device, span).setHandler(handler -> {
            OperationResult operationResult = (OperationResult)handler.result();
            String createdDeviceId = Optional.ofNullable((Id)operationResult.getPayload()).map(Id::getId).orElse(null);
            this.writeOperationResponse(ctx, operationResult, (Handler<HttpServerResponse>)((Handler)response -> response.putHeader(HttpHeaders.LOCATION, (CharSequence)String.format("/%s/%s/%s", this.getName(), tenantId, createdDeviceId))), span);
        });
    }

    private void doUpdateDevice(RoutingContext ctx) {
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)TracingHandler.serverSpanContext(ctx), (String)SPAN_NAME_UPDATE_DEVICE, (String)this.getClass().getSimpleName()).start();
        String deviceId = this.getMandatoryRequestParam("device_id", ctx, span);
        JsonObject payload = (JsonObject)ctx.get("KEY_REQUEST_BODY");
        if (payload != null) {
            payload.remove("device-id");
        }
        String tenantId = this.getMandatoryRequestParam("tenant_id", ctx, span);
        this.logger.debug("updating device [tenant: {}, device: {}, payload: {}]", new Object[]{tenantId, deviceId, payload});
        Optional<String> resourceVersion = Optional.ofNullable((String)ctx.get("KEY_RESOURCE_VERSION"));
        Device device = AbstractDeviceManagementHttpEndpoint.fromPayload(payload);
        this.getService().updateDevice(tenantId, deviceId, device, resourceVersion, span).setHandler(handler -> this.writeOperationResponse(ctx, (OperationResult)handler.result(), null, span));
    }

    private void doDeleteDevice(RoutingContext ctx) {
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)TracingHandler.serverSpanContext(ctx), (String)SPAN_NAME_REMOVE_DEVICE, (String)this.getClass().getSimpleName()).start();
        String deviceId = this.getMandatoryRequestParam("device_id", ctx, span);
        String tenantId = this.getMandatoryRequestParam("tenant_id", ctx, span);
        this.logger.debug("removing device [tenant: {}, device: {}]", (Object)tenantId, (Object)deviceId);
        Optional<String> resourceVersion = Optional.ofNullable((String)ctx.get("KEY_RESOURCE_VERSION"));
        this.getService().deleteDevice(tenantId, deviceId, resourceVersion, span).setHandler(handler -> this.writeResponse(ctx, (Result)handler.result(), null, span));
    }

    private static Device fromPayload(JsonObject payload) throws ClientErrorException {
        return Optional.ofNullable(payload).map(json -> (Device)json.mapTo(Device.class)).orElseGet(Device::new);
    }
}

