/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management.credentials;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.vertx.core.json.JsonObject;
import org.eclipse.hono.auth.HonoPasswordEncoder;
import org.eclipse.hono.service.management.credentials.CommonSecret;
import org.eclipse.hono.util.Strings;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PasswordSecret
extends CommonSecret {
    @JsonProperty(value="hash-function")
    private String hashFunction;
    @JsonProperty(value="pwd-hash")
    private String passwordHash;
    @JsonProperty(value="pwd-plain")
    private String passwordPlain;
    @JsonProperty(value="salt")
    private String salt;

    public String getHashFunction() {
        return this.hashFunction;
    }

    public PasswordSecret setHashFunction(String hashFunction) {
        this.hashFunction = hashFunction;
        return this;
    }

    public String getPasswordHash() {
        return this.passwordHash;
    }

    public PasswordSecret setPasswordHash(String passwordHash) {
        this.passwordHash = passwordHash;
        return this;
    }

    public String getPasswordPlain() {
        return this.passwordPlain;
    }

    public PasswordSecret setPasswordPlain(String passwordPlain) {
        this.passwordPlain = passwordPlain;
        return this;
    }

    public String getSalt() {
        return this.salt;
    }

    public PasswordSecret setSalt(String salt) {
        this.salt = salt;
        return this;
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("hashFunction", (Object)this.hashFunction).add("pwdHash", (Object)this.passwordHash).add("salt", (Object)this.salt);
    }

    @Override
    public void checkValidity() {
        super.checkValidity();
        if (this.containsOnlySecretId()) {
            return;
        }
        if (!Strings.isNullOrEmpty((Object)this.passwordPlain)) {
            throw new IllegalStateException(String.format("'%s' must be empty", "pwd-plain"));
        }
        if (Strings.isNullOrEmpty((Object)this.hashFunction)) {
            throw new IllegalStateException(String.format("'%s' must not be empty", "hash-function"));
        }
        if (Strings.isNullOrEmpty((Object)this.passwordHash)) {
            throw new IllegalStateException(String.format("'%s' must not be empty", "pwd-hash"));
        }
    }

    public boolean containsOnlySecretId() {
        return !Strings.isNullOrEmpty((Object)this.getId()) && Strings.isNullOrEmpty((Object)this.passwordPlain) && Strings.isNullOrEmpty((Object)this.hashFunction) && Strings.isNullOrEmpty((Object)this.passwordHash);
    }

    public PasswordSecret encode(HonoPasswordEncoder encoder) {
        if (!Strings.isNullOrEmpty((Object)this.passwordPlain)) {
            JsonObject hashedPassword = encoder.encode(this.passwordPlain);
            this.hashFunction = hashedPassword.getString("hash-function");
            this.passwordHash = hashedPassword.getString("pwd-hash");
            this.salt = hashedPassword.getString("salt");
            this.passwordPlain = null;
        }
        return this;
    }
}

