/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.management;

import com.google.common.base.MoreObjects;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import org.eclipse.hono.service.http.HttpUtils;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.EventBusMessage;

public class Result<T> {
    private final int status;
    private final T payload;
    private final Optional<CacheDirective> cacheDirective;

    protected Result(int status, T payload, Optional<CacheDirective> cacheDirective) {
        Objects.requireNonNull(cacheDirective);
        this.status = status;
        this.payload = payload;
        this.cacheDirective = cacheDirective;
    }

    public Optional<CacheDirective> getCacheDirective() {
        return this.cacheDirective;
    }

    public T getPayload() {
        return this.payload;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isError() {
        return HttpUtils.isError(this.status);
    }

    public static <T, R extends Result<T>> R from(int status, IntFunction<R> supplier) {
        return (R)((Result)supplier.apply(status));
    }

    public static <T> Result<T> from(int status) {
        return new Result<Object>(status, null, Optional.empty());
    }

    public EventBusMessage createResponse(EventBusMessage request, Function<T, JsonObject> payloadMapper) {
        EventBusMessage result = request.getResponse(this.getStatus());
        this.cacheDirective.ifPresent(arg_0 -> ((EventBusMessage)result).setCacheDirective(arg_0));
        if (this.payload != null) {
            result.setJsonPayload(payloadMapper.apply(this.payload));
        }
        return result;
    }

    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("status", this.status).add("cacheDirective", this.cacheDirective).add("payload", this.payload);
    }

    public String toString() {
        return this.toStringHelper().toString();
    }
}

