/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.opentracing.Span;
import io.opentracing.noop.NoopSpan;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import org.eclipse.hono.service.http.HttpContext;
import org.eclipse.hono.service.http.TracingHandler;
import org.eclipse.hono.service.tenant.ExecutionContextTenantAndAuthIdProvider;
import org.eclipse.hono.service.tenant.TenantTraceSamplingHelper;

public class TenantTraceSamplingHandler
implements Handler<RoutingContext> {
    private final ExecutionContextTenantAndAuthIdProvider<HttpContext> tenantObjectWithAuthIdProvider;

    public TenantTraceSamplingHandler(ExecutionContextTenantAndAuthIdProvider<HttpContext> tenantObjectWithAuthIdProvider) {
        this.tenantObjectWithAuthIdProvider = Objects.requireNonNull(tenantObjectWithAuthIdProvider);
    }

    public void handle(RoutingContext ctx) {
        if (ctx.failed()) {
            ctx.next();
            return;
        }
        Span span = this.getTracingHandlerServerSpan(ctx);
        this.tenantObjectWithAuthIdProvider.get(new HttpContext(ctx), span.context()).compose(tenantObjectWithAuthId -> {
            TenantTraceSamplingHelper.applyTraceSamplingPriority(tenantObjectWithAuthId, span);
            return Future.succeededFuture((Object)tenantObjectWithAuthId);
        }).setHandler(ar -> ctx.next());
    }

    private Span getTracingHandlerServerSpan(RoutingContext ctx) {
        Object spanObject = ctx.get(TracingHandler.CURRENT_SPAN);
        return spanObject instanceof Span ? (Span)spanObject : NoopSpan.INSTANCE;
    }
}

