/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.deviceconnection;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.Objects;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.EventBusService;
import org.eclipse.hono.service.deviceconnection.DeviceConnectionService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.DeviceConnectionConstants;
import org.eclipse.hono.util.EventBusMessage;

@Deprecated
public abstract class EventBusDeviceConnectionAdapter
extends EventBusService
implements Verticle {
    private static final String SPAN_NAME_GET_LAST_GATEWAY = "get last known gateway";
    private static final String SPAN_NAME_SET_LAST_GATEWAY = "set last known gateway";
    private static final String SPAN_NAME_GET_CMD_HANDLING_ADAPTER_INSTANCES = "get command handling adapter instances";
    private static final String SPAN_NAME_SET_CMD_HANDLING_ADAPTER_INSTANCE = "set command handling adapter instance";
    private static final String SPAN_NAME_REMOVE_CMD_HANDLING_ADAPTER_INSTANCE = "remove command handling adapter instance";

    protected abstract DeviceConnectionService getService();

    @Override
    protected final String getEventBusAddress() {
        return "devcon.in";
    }

    @Override
    public Future<EventBusMessage> processRequest(EventBusMessage request) {
        Objects.requireNonNull(request);
        switch (DeviceConnectionConstants.DeviceConnectionAction.from((String)request.getOperation())) {
            case GET_LAST_GATEWAY: {
                return this.processGetLastGatewayRequest(request);
            }
            case SET_LAST_GATEWAY: {
                return this.processSetLastGatewayRequest(request);
            }
            case GET_CMD_HANDLING_ADAPTER_INSTANCES: {
                return this.processGetCmdHandlingAdapterInstances(request);
            }
            case SET_CMD_HANDLING_ADAPTER_INSTANCE: {
                return this.processSetCmdHandlingAdapterInstance(request);
            }
            case REMOVE_CMD_HANDLING_ADAPTER_INSTANCE: {
                return this.processRemoveCmdHandlingAdapterInstance(request);
            }
        }
        return this.processCustomOperationMessage(request);
    }

    protected Future<EventBusMessage> processGetLastGatewayRequest(EventBusMessage request) {
        Future resultFuture;
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)request.getSpanContext(), (String)SPAN_NAME_GET_LAST_GATEWAY, (String)((Object)((Object)this)).getClass().getSimpleName()).start();
        if (tenantId == null || deviceId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant and/or device");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            this.log.debug("getting last known gateway for tenant [{}], device [{}]", (Object)tenantId, (Object)deviceId);
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
            resultFuture = this.getService().getLastKnownGatewayForDevice(tenantId, deviceId, span).map(res -> request.getResponse(res.getStatus()).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective()));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }

    protected Future<EventBusMessage> processSetLastGatewayRequest(EventBusMessage request) {
        Future resultFuture;
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        String gatewayId = request.getGatewayId();
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)request.getSpanContext(), (String)SPAN_NAME_SET_LAST_GATEWAY, (String)((Object)((Object)this)).getClass().getSimpleName()).start();
        if (tenantId == null || deviceId == null || gatewayId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant, device and/or gateway");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            this.log.debug("setting last known gateway for tenant [{}], device [{}] to {}", new Object[]{tenantId, deviceId, gatewayId});
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
            TracingHelper.TAG_GATEWAY_ID.set(span, gatewayId);
            resultFuture = this.getService().setLastKnownGatewayForDevice(tenantId, deviceId, gatewayId, span).map(res -> request.getResponse(res.getStatus()).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective()));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }

    protected Future<EventBusMessage> processGetCmdHandlingAdapterInstances(EventBusMessage request) {
        Future resultFuture;
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        JsonObject payload = request.getJsonPayload();
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)request.getSpanContext(), (String)SPAN_NAME_GET_CMD_HANDLING_ADAPTER_INSTANCES, (String)((Object)((Object)this)).getClass().getSimpleName()).start();
        if (tenantId == null || deviceId == null || payload == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant, device and/or payload");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
            Object gatewaysValue = payload.getValue("gateway-ids");
            if (!(gatewaysValue instanceof JsonArray)) {
                TracingHelper.logError((Span)span, (String)"payload JSON is missing valid 'gateway-ids' field value");
                resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
            } else {
                this.log.debug("getting command handling adapter instances for tenant [{}], device [{}]", (Object)tenantId, (Object)deviceId);
                List list = ((JsonArray)gatewaysValue).getList();
                resultFuture = this.getService().getCommandHandlingAdapterInstances(tenantId, deviceId, list, span).map(res -> request.getResponse(res.getStatus()).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective()));
            }
        }
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }

    protected Future<EventBusMessage> processSetCmdHandlingAdapterInstance(EventBusMessage request) {
        Future resultFuture;
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        String adapterInstanceId = (String)request.getProperty("adapter_instance_id");
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)request.getSpanContext(), (String)SPAN_NAME_SET_CMD_HANDLING_ADAPTER_INSTANCE, (String)((Object)((Object)this)).getClass().getSimpleName()).start();
        if (tenantId == null || deviceId == null || adapterInstanceId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant, device and/or adapter instance id");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
            span.setTag("adapter_instance_id", adapterInstanceId);
            this.log.debug("setting command handling adapter instance for tenant [{}], device [{}] to {}", new Object[]{tenantId, deviceId, adapterInstanceId});
            resultFuture = this.getService().setCommandHandlingAdapterInstance(tenantId, deviceId, adapterInstanceId, span).map(res -> request.getResponse(res.getStatus()).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective()));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }

    protected Future<EventBusMessage> processRemoveCmdHandlingAdapterInstance(EventBusMessage request) {
        Future resultFuture;
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        String adapterInstanceId = (String)request.getProperty("adapter_instance_id");
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)request.getSpanContext(), (String)SPAN_NAME_REMOVE_CMD_HANDLING_ADAPTER_INSTANCE, (String)((Object)((Object)this)).getClass().getSimpleName()).start();
        if (tenantId == null || deviceId == null || adapterInstanceId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant, device and/or adapter instance id");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
            span.setTag("adapter_instance_id", adapterInstanceId);
            this.log.debug("removing command handling adapter instance for tenant [{}], device [{}] with value {}", new Object[]{tenantId, deviceId, adapterInstanceId});
            resultFuture = this.getService().removeCommandHandlingAdapterInstance(tenantId, deviceId, adapterInstanceId, span).map(res -> request.getResponse(res.getStatus()).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective()));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<EventBusMessage>)resultFuture);
    }

    protected Future<EventBusMessage> processCustomOperationMessage(EventBusMessage request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getOperation());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }
}

