/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.commandrouter;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.amqp.AbstractDelegatingRequestResponseEndpoint;
import org.eclipse.hono.service.commandrouter.CommandRouterMessageFilter;
import org.eclipse.hono.service.commandrouter.CommandRouterResult;
import org.eclipse.hono.service.commandrouter.CommandRouterService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.CommandRouterConstants;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.RequestResponseResult;
import org.eclipse.hono.util.ResourceIdentifier;

public class DelegatingCommandRouterAmqpEndpoint<S extends CommandRouterService>
extends AbstractDelegatingRequestResponseEndpoint<S, ServiceConfigProperties> {
    private static final String SPAN_NAME_SET_LAST_GATEWAY = "set last known gateway";
    private static final String SPAN_NAME_REGISTER_COMMAND_CONSUMER = "register command consumer";
    private static final String SPAN_NAME_UNREGISTER_COMMAND_CONSUMER = "unregister command consumer";
    private static final String SPAN_NAME_ENABLE_COMMAND_ROUTING = "enable command routing";

    public DelegatingCommandRouterAmqpEndpoint(Vertx vertx, S service) {
        super(vertx, service);
    }

    @Override
    protected Future<Message> handleRequestMessage(Message requestMessage, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Objects.requireNonNull(requestMessage);
        Objects.requireNonNull(targetAddress);
        switch (CommandRouterConstants.CommandRouterAction.from((String)requestMessage.getSubject())) {
            case SET_LAST_KNOWN_GATEWAY: {
                return this.processSetLastKnownGatewayRequest(requestMessage, targetAddress, spanContext);
            }
            case REGISTER_COMMAND_CONSUMER: {
                return this.processRegisterCommandConsumer(requestMessage, targetAddress, spanContext);
            }
            case UNREGISTER_COMMAND_CONSUMER: {
                return this.processUnregisterCommandConsumer(requestMessage, targetAddress, spanContext);
            }
            case ENABLE_COMMAND_ROUTING: {
                return this.processEnableCommandRouting(requestMessage, targetAddress, spanContext);
            }
        }
        return this.processCustomOperationMessage(requestMessage, spanContext);
    }

    protected Future<Message> processSetLastKnownGatewayRequest(Message request, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Future<CommandRouterResult> resultFuture;
        String tenantId = targetAddress.getTenantId();
        String deviceIdAppProperty = MessageHelper.getDeviceId((Message)request);
        String gatewayIdAppProperty = MessageHelper.getGatewayId((Message)request);
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)SPAN_NAME_SET_LAST_GATEWAY, (String)this.getClass().getSimpleName()).start();
        if (tenantId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400, "missing tenant"));
        } else if (deviceIdAppProperty != null && gatewayIdAppProperty != null) {
            this.logger.debug("setting last known gateway for tenant [{}], device [{}] to {}", new Object[]{tenantId, deviceIdAppProperty, gatewayIdAppProperty});
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            TracingHelper.TAG_DEVICE_ID.set(span, deviceIdAppProperty);
            TracingHelper.TAG_GATEWAY_ID.set(span, gatewayIdAppProperty);
            if (MessageHelper.getPayloadSize((Message)request) != 0) {
                this.logger.debug("ignoring payload in last known gateway request containing device/gateway properties");
            }
            resultFuture = ((CommandRouterService)this.getService()).setLastKnownGatewayForDevice(tenantId, deviceIdAppProperty, gatewayIdAppProperty, span);
        } else if (MessageHelper.getPayloadSize((Message)request) != 0) {
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            Buffer payload = MessageHelper.getPayload((Message)request);
            resultFuture = this.parseSetLastKnownGatewayJson(payload).compose(deviceToGatewayMap -> {
                this.logger.debug("setting {} last known gateway entries for tenant [{}]", (Object)deviceToGatewayMap.size(), (Object)tenantId);
                span.log(Map.of("no_of_entries", deviceToGatewayMap.size()));
                return ((CommandRouterService)this.getService()).setLastKnownGatewayForDevice(tenantId, (Map<String, String>)deviceToGatewayMap, span);
            });
        } else {
            String error = "either device_id and gateway_id application properties or alternatively a JSON payload must be set";
            TracingHelper.logError((Span)span, (String)"either device_id and gateway_id application properties or alternatively a JSON payload must be set");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400, "either device_id and gateway_id application properties or alternatively a JSON payload must be set"));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<Message>)resultFuture.map(res -> CommandRouterConstants.getAmqpReply((String)"cmd_router", (String)tenantId, (Message)request, (RequestResponseResult)res)));
    }

    private Future<Map<String, String>> parseSetLastKnownGatewayJson(Buffer payload) {
        Promise result = Promise.promise();
        try {
            HashMap resultMap = new HashMap();
            JsonObject jsonObject = payload.toJsonObject();
            jsonObject.forEach(entry -> {
                if (entry.getValue() instanceof String) {
                    resultMap.put((String)entry.getKey(), (String)entry.getValue());
                }
            });
            result.complete(resultMap);
        }
        catch (DecodeException e) {
            result.fail((Throwable)new ClientErrorException(400, "payload must contain a JSON object if device_id and gateway_id application properties are not set"));
        }
        return result.future();
    }

    protected Future<Message> processRegisterCommandConsumer(Message request, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Future resultFuture;
        String tenantId = targetAddress.getTenantId();
        String deviceId = MessageHelper.getDeviceId((Message)request);
        String adapterInstanceId = (String)MessageHelper.getApplicationProperty((ApplicationProperties)request.getApplicationProperties(), (String)"adapter_instance_id", String.class);
        Integer lifespanSecondsOrNull = (Integer)MessageHelper.getApplicationProperty((ApplicationProperties)request.getApplicationProperties(), (String)"lifespan", Integer.class);
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)SPAN_NAME_REGISTER_COMMAND_CONSUMER, (String)this.getClass().getSimpleName()).start();
        if (tenantId == null || deviceId == null || adapterInstanceId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant, device and/or adapter instance id");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            Duration lifespan = lifespanSecondsOrNull != null ? Duration.ofSeconds(lifespanSecondsOrNull.intValue()) : Duration.ofSeconds(-1L);
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
            span.setTag("adapter_instance_id", adapterInstanceId);
            span.setTag("lifespan", (Number)lifespan.getSeconds());
            this.logger.debug("register command consumer [tenant-id: {}, device-id: {}, adapter-instance-id {}, lifespan: {}s]", new Object[]{tenantId, deviceId, adapterInstanceId, lifespan.getSeconds()});
            resultFuture = ((CommandRouterService)this.getService()).registerCommandConsumer(tenantId, deviceId, adapterInstanceId, lifespan, span).map(res -> CommandRouterConstants.getAmqpReply((String)"cmd_router", (String)tenantId, (Message)request, (RequestResponseResult)res));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<Message>)resultFuture);
    }

    protected Future<Message> processUnregisterCommandConsumer(Message request, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Future resultFuture;
        String tenantId = targetAddress.getTenantId();
        String deviceId = MessageHelper.getDeviceId((Message)request);
        String adapterInstanceId = (String)MessageHelper.getApplicationProperty((ApplicationProperties)request.getApplicationProperties(), (String)"adapter_instance_id", String.class);
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)SPAN_NAME_UNREGISTER_COMMAND_CONSUMER, (String)this.getClass().getSimpleName()).start();
        if (tenantId == null || deviceId == null || adapterInstanceId == null) {
            TracingHelper.logError((Span)span, (String)"missing tenant, device and/or adapter instance id");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else {
            TracingHelper.TAG_TENANT_ID.set(span, tenantId);
            TracingHelper.TAG_DEVICE_ID.set(span, deviceId);
            span.setTag("adapter_instance_id", adapterInstanceId);
            this.logger.debug("unregister command consumer [tenant-id: {}, device-id: {}, adapter-instance-id {}]", new Object[]{tenantId, deviceId, adapterInstanceId});
            resultFuture = ((CommandRouterService)this.getService()).unregisterCommandConsumer(tenantId, deviceId, adapterInstanceId, span).map(res -> CommandRouterConstants.getAmqpReply((String)"cmd_router", (String)tenantId, (Message)request, (RequestResponseResult)res));
        }
        return this.finishSpanOnFutureCompletion(span, (Future<Message>)resultFuture);
    }

    protected Future<Message> processEnableCommandRouting(Message request, ResourceIdentifier targetAddress, SpanContext spanContext) {
        Span span = TracingHelper.buildServerChildSpan((Tracer)this.tracer, (SpanContext)spanContext, (String)SPAN_NAME_ENABLE_COMMAND_ROUTING, (String)this.getClass().getSimpleName()).start();
        Future response = this.parseTenantIdentifiers(request).compose(tenantIds -> {
            span.log(Map.of("no_of_tenants", tenantIds.size()));
            return ((CommandRouterService)this.getService()).enableCommandRouting((List<String>)tenantIds, span);
        }).map(result -> CommandRouterConstants.getAmqpReply((String)targetAddress.getEndpoint(), null, (Message)request, (RequestResponseResult)result));
        return this.finishSpanOnFutureCompletion(span, (Future<Message>)response);
    }

    private Future<List<String>> parseTenantIdentifiers(Message request) {
        Buffer payload = MessageHelper.getPayload((Message)request);
        if (payload == null) {
            return Future.succeededFuture(List.of());
        }
        Promise result = Promise.promise();
        try {
            JsonArray array = payload.toJsonArray();
            List tenantIds = array.stream().filter(String.class::isInstance).map(String.class::cast).collect(Collectors.toList());
            result.complete(tenantIds);
        }
        catch (DecodeException e) {
            result.fail((Throwable)new ClientErrorException(400, "payload must contain JSON array of tenant identifiers"));
        }
        return result.future();
    }

    protected Future<Message> processCustomOperationMessage(Message request, SpanContext spanContext) {
        this.logger.debug("invalid operation in request message [{}]", (Object)request.getSubject());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    @Override
    protected boolean passesFormalVerification(ResourceIdentifier linkTarget, Message msg) {
        return CommandRouterMessageFilter.verify(linkTarget, msg);
    }

    @Override
    public final String getName() {
        return "cmd_router";
    }
}

