/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.hono.cache.CacheProvider;
import org.eclipse.hono.cache.ExpiringValueCache;
import org.eclipse.hono.service.cache.CaffeineBasedExpiringValueCache;

public class CaffeineCacheProvider
implements CacheProvider {
    private final Caffeine<Object, Object> cacheSpec;
    private final Map<String, ExpiringValueCache<Object, Object>> caches = new ConcurrentHashMap<String, ExpiringValueCache<Object, Object>>();

    public CaffeineCacheProvider(Caffeine<Object, Object> cacheSpec) {
        this.cacheSpec = Objects.requireNonNull(cacheSpec);
    }

    public <K, V> ExpiringValueCache<K, V> getCache(String cacheName) {
        Objects.requireNonNull(cacheName);
        return this.caches.computeIfAbsent(cacheName, name -> new CaffeineBasedExpiringValueCache((Cache<Object, Object>)this.cacheSpec.build()));
    }
}

