/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import java.time.Duration;
import java.util.Optional;
import org.eclipse.hono.client.RequestResponseClientConfigProperties;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.RequestResponseResult;

public final class Caches {
    private Caches() {
    }

    public static <V extends RequestResponseResult<?>> Cache<Object, V> newCaffeineCache(final RequestResponseClientConfigProperties config) {
        if (config.getResponseCacheMaxSize() <= 0L) {
            return null;
        }
        return Caffeine.newBuilder().initialCapacity(config.getResponseCacheMinSize()).maximumSize(Math.max((long)config.getResponseCacheMinSize(), config.getResponseCacheMaxSize())).expireAfter(new Expiry<Object, V>(){

            private long getMaxAge(CacheDirective directive) {
                return Optional.ofNullable(directive).map(d -> Duration.ofSeconds(Math.min(d.getMaxAge(), config.getResponseCacheDefaultTimeout())).toNanos()).orElse(Duration.ofSeconds(config.getResponseCacheDefaultTimeout()).toNanos());
            }

            public long expireAfterCreate(Object key, V value, long currentTime) {
                return this.getMaxAge(value.getCacheDirective());
            }

            public long expireAfterUpdate(Object key, V value, long currentTime, long currentDuration) {
                return this.getMaxAge(value.getCacheDirective());
            }

            public long expireAfterRead(Object key, V value, long currentTime, long currentDuration) {
                return currentDuration;
            }
        }).build();
    }
}

