/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.hono.service.http.WebSpanDecorator;
import org.eclipse.hono.tracing.TracingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingHandler
implements Handler<RoutingContext> {
    public static final String CURRENT_SPAN = TracingHandler.class.getName() + ".serverSpan";
    private static final Logger log = LoggerFactory.getLogger(TracingHandler.class);
    private final Tracer tracer;
    private final List<WebSpanDecorator> decorators;

    public TracingHandler(Tracer tracer) {
        this(tracer, Collections.singletonList(new WebSpanDecorator.StandardTags()));
    }

    public TracingHandler(Tracer tracer, List<WebSpanDecorator> decorators) {
        this.tracer = tracer;
        this.decorators = new ArrayList<WebSpanDecorator>(decorators);
    }

    public void handle(RoutingContext routingContext) {
        if (routingContext.failed()) {
            this.handlerFailure(routingContext);
        } else {
            this.handlerNormal(routingContext);
        }
    }

    protected void handlerNormal(RoutingContext routingContext) {
        Object object = routingContext.get(CURRENT_SPAN);
        if (object instanceof Span) {
            Span span = (Span)object;
            this.decorators.forEach(spanDecorator -> spanDecorator.onReroute(routingContext.request(), span));
            routingContext.addBodyEndHandler(this.finishEndHandler(routingContext, span));
            routingContext.next();
            return;
        }
        SpanContext extractedContext = TracingHelper.extractSpanContext((Tracer)this.tracer, (MultiMap)routingContext.request().headers());
        Span span = this.tracer.buildSpan(routingContext.request().method().toString()).asChildOf(extractedContext).withTag(Tags.SPAN_KIND.getKey(), "server").start();
        this.decorators.forEach(spanDecorator -> spanDecorator.onRequest(routingContext.request(), span));
        routingContext.put(CURRENT_SPAN, (Object)span);
        routingContext.addBodyEndHandler(this.finishEndHandler(routingContext, span));
        routingContext.next();
    }

    protected void handlerFailure(RoutingContext routingContext) {
        Object object = routingContext.get(CURRENT_SPAN);
        if (object instanceof Span) {
            Span span = (Span)object;
            routingContext.addBodyEndHandler(event -> this.decorators.forEach(spanDecorator -> spanDecorator.onFailure(routingContext.failure(), routingContext.response(), span)));
        }
        routingContext.next();
    }

    private Handler<Void> finishEndHandler(RoutingContext routingContext, Span span) {
        return handler -> {
            this.decorators.forEach(spanDecorator -> spanDecorator.onResponse(routingContext.request(), span));
            span.finish();
        };
    }

    public static SpanContext serverSpanContext(RoutingContext routingContext) {
        SpanContext serverContext = null;
        Object object = routingContext.get(CURRENT_SPAN);
        if (object instanceof Span) {
            Span span = (Span)object;
            serverContext = span.context();
        } else {
            log.warn("Server SpanContext is null or not an instance of SpanContext");
        }
        return serverContext;
    }
}

