/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.opentracing.tag.Tags;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.NetServerOptions;
import io.vertx.ext.healthchecks.HealthCheckHandler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.hono.config.ServiceConfigProperties;
import org.eclipse.hono.service.AbstractServiceBase;
import org.eclipse.hono.service.http.ComponentMetaDataDecorator;
import org.eclipse.hono.service.http.DefaultFailureHandler;
import org.eclipse.hono.service.http.HttpEndpoint;
import org.eclipse.hono.service.http.TracingHandler;
import org.eclipse.hono.service.http.WebSpanDecorator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class HttpServiceBase<T extends ServiceConfigProperties>
extends AbstractServiceBase<T> {
    protected static final String DEFAULT_UPLOADS_DIRECTORY = "/tmp";
    private final Map<String, HttpEndpoint> endpoints = new HashMap<String, HttpEndpoint>();
    private HttpServer server;
    private HttpServer insecureServer;
    private AuthenticationHandler authHandler;

    @Autowired(required=false)
    public final void addEndpoints(Set<HttpEndpoint> definedEndpoints) {
        Objects.requireNonNull(definedEndpoints);
        for (HttpEndpoint ep : definedEndpoints) {
            this.addEndpoint(ep);
        }
    }

    public final void addEndpoint(HttpEndpoint ep) {
        if (this.endpoints.putIfAbsent(ep.getName(), ep) != null) {
            this.log.warn("multiple endpoints defined with name [{}]", (Object)ep.getName());
        } else {
            this.log.debug("registering endpoint [{}]", (Object)ep.getName());
        }
    }

    protected final Iterable<HttpEndpoint> endpoints() {
        return this.endpoints.values();
    }

    @Autowired(required=false)
    public void setAuthHandler(AuthenticationHandler authHandler) {
        this.authHandler = authHandler;
    }

    @Autowired
    @Qualifier(value="http")
    public final void setConfig(T configuration) {
        this.setSpecificConfig(configuration);
    }

    @Override
    public int getPortDefaultValue() {
        return 8443;
    }

    @Override
    public int getInsecurePortDefaultValue() {
        return 8080;
    }

    @Override
    protected final int getActualPort() {
        return this.server != null ? this.server.actualPort() : -1;
    }

    @Override
    protected final int getActualInsecurePort() {
        return this.insecureServer != null ? this.insecureServer.actualPort() : -1;
    }

    protected Future<Void> preStartServers() {
        return Future.succeededFuture();
    }

    @Override
    protected final Future<Void> startInternal() {
        return this.preStartServers().compose(s -> this.checkPortConfiguration()).compose(s -> this.startEndpoints()).compose(router -> CompositeFuture.all(this.bindSecureHttpServer((Router)router), this.bindInsecureHttpServer((Router)router))).compose(s -> this.onStartupSuccess());
    }

    protected Future<Void> onStartupSuccess() {
        return Future.succeededFuture();
    }

    protected Router createRouter() {
        Router router = Router.router((Vertx)this.vertx);
        Route matchAllRoute = router.route();
        TracingHandler tracingHandler = this.createTracingHandler();
        matchAllRoute.handler((Handler)tracingHandler).failureHandler((Handler)tracingHandler);
        matchAllRoute.failureHandler((Handler)new DefaultFailureHandler());
        this.log.info("limiting size of inbound request body to {} bytes", (Object)((ServiceConfigProperties)this.getConfig()).getMaxPayloadSize());
        matchAllRoute.handler((Handler)BodyHandler.create().setUploadsDirectory(DEFAULT_UPLOADS_DIRECTORY).setBodyLimit((long)((ServiceConfigProperties)this.getConfig()).getMaxPayloadSize()));
        this.addAuthHandler(router);
        return router;
    }

    private TracingHandler createTracingHandler() {
        HashMap<String, String> customTags = new HashMap<String, String>();
        customTags.put(Tags.COMPONENT.getKey(), this.getClass().getSimpleName());
        this.addCustomTags(customTags);
        List<WebSpanDecorator> decorators = Collections.singletonList(new ComponentMetaDataDecorator(customTags));
        return new TracingHandler(this.tracer, decorators);
    }

    protected void addAuthHandler(Router router) {
        if (this.authHandler != null) {
            Route matchAllRoute = router.route();
            matchAllRoute.handler((Handler)this.authHandler);
        }
    }

    protected void addCustomTags(Map<String, String> customTags) {
    }

    private void addEndpointRoutes(Router router) {
        for (HttpEndpoint ep : this.endpoints()) {
            ep.addRoutes(router);
        }
    }

    protected void addCustomRoutes(Router router) {
    }

    protected HttpServerOptions getHttpServerOptions() {
        HttpServerOptions options = new HttpServerOptions();
        options.setHost(((ServiceConfigProperties)this.getConfig()).getBindAddress()).setPort(((ServiceConfigProperties)this.getConfig()).getPort(this.getPortDefaultValue())).setMaxChunkSize(4096);
        this.addTlsKeyCertOptions((NetServerOptions)options);
        this.addTlsTrustOptions((NetServerOptions)options);
        return options;
    }

    protected HttpServerOptions getInsecureHttpServerOptions() {
        HttpServerOptions options = new HttpServerOptions();
        options.setHost(((ServiceConfigProperties)this.getConfig()).getInsecurePortBindAddress()).setPort(((ServiceConfigProperties)this.getConfig()).getInsecurePort(this.getInsecurePortDefaultValue())).setMaxChunkSize(4096);
        return options;
    }

    private Future<HttpServer> bindSecureHttpServer(Router router) {
        if (this.isSecurePortEnabled()) {
            String bindAddress;
            Promise result = Promise.promise();
            String string = bindAddress = this.server == null ? ((ServiceConfigProperties)this.getConfig()).getBindAddress() : "?";
            if (this.server == null) {
                this.server = this.vertx.createHttpServer(this.getHttpServerOptions());
            }
            this.server.requestHandler((Handler)router).listen(bindAttempt -> {
                if (bindAttempt.succeeded()) {
                    if (this.getPort() == this.getPortDefaultValue()) {
                        this.log.info("server listens on standard secure port [{}:{}]", (Object)bindAddress, (Object)this.server.actualPort());
                    } else {
                        this.log.warn("server listens on non-standard secure port [{}:{}], default is {}", new Object[]{bindAddress, this.server.actualPort(), this.getPortDefaultValue()});
                    }
                    result.complete((Object)((HttpServer)bindAttempt.result()));
                } else {
                    this.log.error("cannot bind to secure port", bindAttempt.cause());
                    result.fail(bindAttempt.cause());
                }
            });
            return result.future();
        }
        return Future.succeededFuture();
    }

    private Future<HttpServer> bindInsecureHttpServer(Router router) {
        if (this.isInsecurePortEnabled()) {
            String bindAddress;
            Promise result = Promise.promise();
            String string = bindAddress = this.insecureServer == null ? ((ServiceConfigProperties)this.getConfig()).getInsecurePortBindAddress() : "?";
            if (this.insecureServer == null) {
                this.insecureServer = this.vertx.createHttpServer(this.getInsecureHttpServerOptions());
            }
            this.insecureServer.requestHandler((Handler)router).listen(bindAttempt -> {
                if (bindAttempt.succeeded()) {
                    if (this.getInsecurePort() == this.getInsecurePortDefaultValue()) {
                        this.log.info("server listens on standard insecure port [{}:{}]", (Object)bindAddress, (Object)this.insecureServer.actualPort());
                    } else {
                        this.log.warn("server listens on non-standard insecure port [{}:{}], default is {}", new Object[]{bindAddress, this.insecureServer.actualPort(), this.getInsecurePortDefaultValue()});
                    }
                    result.complete((Object)((HttpServer)bindAttempt.result()));
                } else {
                    this.log.error("cannot bind to insecure port", bindAttempt.cause());
                    result.fail(bindAttempt.cause());
                }
            });
            return result.future();
        }
        return Future.succeededFuture();
    }

    private Future<Router> startEndpoints() {
        Promise startPromise = Promise.promise();
        Router router = this.createRouter();
        if (router == null) {
            startPromise.fail("no router configured");
        } else {
            this.addEndpointRoutes(router);
            this.addCustomRoutes(router);
            ArrayList<Future> endpointFutures = new ArrayList<Future>(this.endpoints.size());
            for (HttpEndpoint ep : this.endpoints()) {
                this.log.info("starting endpoint [name: {}, class: {}]", (Object)ep.getName(), (Object)ep.getClass().getName());
                endpointFutures.add(ep.start());
            }
            CompositeFuture.all(endpointFutures).onComplete(startup -> {
                if (startup.succeeded()) {
                    startPromise.complete((Object)router);
                } else {
                    startPromise.fail(startup.cause());
                }
            });
        }
        return startPromise.future();
    }

    private Future<Void> stopEndpoints() {
        Promise stopPromise = Promise.promise();
        ArrayList<Future> endpointFutures = new ArrayList<Future>(this.endpoints.size());
        for (HttpEndpoint ep : this.endpoints()) {
            this.log.info("stopping endpoint [name: {}, class: {}]", (Object)ep.getName(), (Object)ep.getClass().getName());
            endpointFutures.add(ep.stop());
        }
        CompositeFuture.all(endpointFutures).onComplete(shutdown -> {
            if (shutdown.succeeded()) {
                stopPromise.complete();
            } else {
                stopPromise.fail(shutdown.cause());
            }
        });
        return stopPromise.future();
    }

    @Override
    protected final Future<Void> stopInternal() {
        return this.preShutdown().compose(s -> CompositeFuture.all(this.stopServer(), this.stopInsecureServer())).compose(s -> this.stopEndpoints()).compose(v -> this.postShutdown());
    }

    private Future<Void> stopServer() {
        Promise serverStopTracker = Promise.promise();
        if (this.server != null) {
            this.log.info("stopping secure HTTP server [{}:{}]", (Object)this.getBindAddress(), (Object)this.getActualPort());
            this.server.close((Handler)serverStopTracker);
        } else {
            serverStopTracker.complete();
        }
        return serverStopTracker.future();
    }

    private Future<Void> stopInsecureServer() {
        Promise insecureServerStopTracker = Promise.promise();
        if (this.insecureServer != null) {
            this.log.info("stopping insecure HTTP server [{}:{}]", (Object)this.getInsecurePortBindAddress(), (Object)this.getActualInsecurePort());
            this.insecureServer.close((Handler)insecureServerStopTracker);
        } else {
            insecureServerStopTracker.complete();
        }
        return insecureServerStopTracker.future();
    }

    protected Future<Void> preShutdown() {
        return Future.succeededFuture();
    }

    protected Future<Void> postShutdown() {
        return Future.succeededFuture();
    }

    @Override
    public void registerReadinessChecks(HealthCheckHandler handler) {
        for (HttpEndpoint ep : this.endpoints()) {
            ep.registerReadinessChecks(handler);
        }
    }

    @Override
    public void registerLivenessChecks(HealthCheckHandler handler) {
        for (HttpEndpoint ep : this.endpoints()) {
            ep.registerLivenessChecks(handler);
        }
    }
}

