/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.http;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.HttpException;
import java.util.Optional;
import org.eclipse.hono.client.ServiceInvocationException;
import org.eclipse.hono.service.http.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFailureHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultFailureHandler.class);
    private static final String ERROR_DETAIL_NOT_AVAILABLE = "N/A";

    public void handle(RoutingContext ctx) {
        if (ctx.failed()) {
            if (ctx.response().ended()) {
                LOG.debug("skipping processing of failed route, response already ended");
            } else {
                LOG.debug("handling failed route for request [method: {}, URI: {}, status: {}] - {}", new Object[]{ctx.request().method(), HttpUtils.getAbsoluteURI(ctx.request()), ctx.statusCode(), ctx.getBody(), ctx.failure()});
                if (ctx.failure() != null) {
                    if (ctx.failure() instanceof ServiceInvocationException) {
                        ServiceInvocationException e = (ServiceInvocationException)ctx.failure();
                        this.sendError(ctx.response(), e.getErrorCode(), e.getMessage());
                    } else if (ctx.failure() instanceof HttpException) {
                        HttpException e = (HttpException)ctx.failure();
                        this.sendError(ctx.response(), e.getStatusCode(), e.getMessage());
                    } else {
                        LOG.debug("unexpected internal failure", ctx.failure());
                        this.sendError(ctx.response(), 500, ctx.failure().getMessage());
                    }
                } else if (ctx.statusCode() != -1) {
                    this.sendError(ctx.response(), ctx.statusCode(), null);
                } else {
                    this.sendError(ctx.response(), 500, "Internal Server Error");
                }
            }
        } else {
            LOG.debug("skipping processing of non-failed route");
            ctx.next();
        }
    }

    protected Buffer createResponsePayload(String errorMessage) {
        return new JsonObject().put("error", (Object)Optional.ofNullable(errorMessage).orElse(ERROR_DETAIL_NOT_AVAILABLE)).toBuffer();
    }

    private void sendError(HttpServerResponse response, int errorCode, String errorMessage) {
        response.setStatusCode(errorCode);
        HttpUtils.setResponseBody(response, this.createResponsePayload(errorMessage), "application/json; charset=utf-8");
        response.end();
    }
}

