/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.tenant;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.noop.NoopSpan;
import io.opentracing.tag.Tags;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.ServerErrorException;
import org.eclipse.hono.service.EventBusService;
import org.eclipse.hono.service.tenant.TenantService;
import org.eclipse.hono.tracing.TracingHelper;
import org.eclipse.hono.util.EventBusMessage;
import org.eclipse.hono.util.TenantConstants;
import org.eclipse.hono.util.TenantResult;

public abstract class BaseTenantService<T>
extends EventBusService<T>
implements TenantService {
    private static final String SPAN_NAME_GET_TENANT = "get Tenant";
    private static final String TAG_SUBJECT_DN_NAME = "subject_dn_name";

    @Override
    protected final String getEventBusAddress() {
        return "tenant.in";
    }

    @Override
    public Future<EventBusMessage> processRequest(EventBusMessage request) {
        Objects.requireNonNull(request);
        switch (TenantConstants.TenantAction.from((String)request.getOperation())) {
            case get: {
                return this.processGetRequest(request);
            }
        }
        return this.processCustomTenantMessage(request);
    }

    Future<EventBusMessage> processGetRequest(EventBusMessage request) {
        Future<EventBusMessage> resultFuture;
        String tenantId = request.getTenant();
        JsonObject payload = request.getJsonPayload();
        Span span = this.newChildSpan(SPAN_NAME_GET_TENANT, request.getSpanContext(), tenantId);
        if (tenantId == null && payload == null) {
            TracingHelper.logError((Span)span, (String)"request does not contain any query parameters");
            this.log.debug("request does not contain any query parameters");
            resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
        } else if (tenantId != null) {
            this.log.debug("retrieving tenant [{}] using deprecated variant of get tenant request", (Object)tenantId);
            span.log("using deprecated variant of get tenant request");
            resultFuture = this.processGetByIdRequest(request, tenantId, span);
        } else {
            String tenantIdFromPayload = BaseTenantService.getTypesafeValueForField(String.class, payload, "tenant-id");
            String subjectDn = BaseTenantService.getTypesafeValueForField(String.class, payload, "subject-dn");
            if (tenantIdFromPayload == null && subjectDn == null) {
                TracingHelper.logError((Span)span, (String)"request does not contain any query parameters");
                this.log.debug("payload does not contain any query parameters");
                resultFuture = Future.failedFuture((Throwable)new ClientErrorException(400));
            } else if (tenantIdFromPayload != null) {
                this.log.debug("retrieving tenant [id: {}]", (Object)tenantIdFromPayload);
                span.setTag("tenant_id", tenantIdFromPayload);
                resultFuture = this.processGetByIdRequest(request, tenantIdFromPayload, span);
            } else {
                span.setTag(TAG_SUBJECT_DN_NAME, subjectDn);
                resultFuture = this.processGetByCaRequest(request, subjectDn, span);
            }
        }
        return this.finishSpanOnFutureCompletion(span, resultFuture);
    }

    private Future<EventBusMessage> processGetByIdRequest(EventBusMessage request, String tenantId, Span span) {
        Future getResult = Future.future();
        this.get(tenantId, span, (Handler<AsyncResult<TenantResult<JsonObject>>>)getResult.completer());
        return getResult.map(tr -> request.getResponse(tr.getStatus()).setJsonPayload((JsonObject)tr.getPayload()).setTenant(tenantId).setCacheDirective(tr.getCacheDirective()));
    }

    private Future<EventBusMessage> processGetByCaRequest(EventBusMessage request, String subjectDn, Span span) {
        try {
            X500Principal dn = new X500Principal(subjectDn);
            this.log.debug("retrieving tenant [subject DN: {}]", (Object)subjectDn);
            Future getResult = Future.future();
            this.get(dn, span, (Handler<AsyncResult<TenantResult<JsonObject>>>)getResult.completer());
            return getResult.map(tr -> {
                EventBusMessage response = request.getResponse(tr.getStatus()).setJsonPayload((JsonObject)tr.getPayload()).setCacheDirective(tr.getCacheDirective());
                if (tr.isOk() && tr.getPayload() != null) {
                    String tenantId = BaseTenantService.getTypesafeValueForField(String.class, (JsonObject)tr.getPayload(), "tenant-id");
                    span.setTag("tenant_id", tenantId);
                    response.setTenant(tenantId);
                }
                return response;
            });
        }
        catch (IllegalArgumentException e) {
            TracingHelper.logError((Span)span, (String)("illegal subject DN provided by client: " + subjectDn));
            this.log.debug("cannot parse subject DN [{}] provided by client", (Object)subjectDn);
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
    }

    protected final Span newChildSpan(String operationName, SpanContext spanContext, String tenantId) {
        Objects.requireNonNull(operationName);
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(operationName).addReference("child_of", spanContext).ignoreActiveSpan().withTag(Tags.COMPONENT.getKey(), this.getClass().getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "server");
        if (tenantId != null) {
            spanBuilder.withTag("tenant_id", tenantId);
        }
        return spanBuilder.start();
    }

    protected Future<EventBusMessage> processCustomTenantMessage(EventBusMessage request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getOperation());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    @Override
    public final void get(String tenantId, Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        this.get(tenantId, (Span)NoopSpan.INSTANCE, resultHandler);
    }

    @Override
    public void get(String tenantId, Span span, Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public final void get(X500Principal subjectDn, Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        this.get(subjectDn, (Span)NoopSpan.INSTANCE, resultHandler);
    }

    @Override
    public void get(X500Principal subjectDn, Span span, Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    protected void handleUnimplementedOperation(Handler<AsyncResult<TenantResult<JsonObject>>> resultHandler) {
        resultHandler.handle((Object)Future.failedFuture((Throwable)new ServerErrorException(501)));
    }
}

