/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.registration;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.client.StatusCodeMapper;
import org.eclipse.hono.service.registration.BaseRegistrationService;
import org.eclipse.hono.service.registration.CompleteRegistrationService;
import org.eclipse.hono.util.EventBusMessage;
import org.eclipse.hono.util.RegistrationResult;

public abstract class CompleteBaseRegistrationService<T>
extends BaseRegistrationService<T>
implements CompleteRegistrationService {
    @Override
    public final Future<EventBusMessage> processRequest(EventBusMessage requestMessage) {
        Objects.requireNonNull(requestMessage);
        switch (requestMessage.getOperation()) {
            case "register": {
                return this.processRegisterRequest(requestMessage);
            }
            case "assert": {
                return super.processRequest(requestMessage);
            }
            case "get": {
                return this.processGetRequest(requestMessage);
            }
            case "update": {
                return this.processUpdateRequest(requestMessage);
            }
            case "deregister": {
                return this.processDeregisterRequest(requestMessage);
            }
        }
        return this.processCustomRegistrationMessage(requestMessage);
    }

    private Future<EventBusMessage> processRegisterRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        JsonObject payload = this.getRequestPayload(request.getJsonPayload());
        if (tenantId == null || deviceId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        this.log.debug("registering device [{}] for tenant [{}]", (Object)deviceId, (Object)tenantId);
        Future result = Future.future();
        this.addDevice(tenantId, deviceId, payload, (Handler<AsyncResult<RegistrationResult>>)result.completer());
        return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setCacheDirective(res.getCacheDirective()));
    }

    private Future<EventBusMessage> processGetRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        if (tenantId == null || deviceId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        this.log.debug("retrieving device [{}] of tenant [{}]", (Object)deviceId, (Object)tenantId);
        Future result = Future.future();
        this.getDevice(tenantId, deviceId, (Handler<AsyncResult<RegistrationResult>>)result.completer());
        return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective()));
    }

    private Future<EventBusMessage> processUpdateRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        JsonObject payload = this.getRequestPayload(request.getJsonPayload());
        if (tenantId == null || deviceId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        this.log.debug("updating registration information for device [{}] of tenant [{}]", (Object)deviceId, (Object)tenantId);
        Future result = Future.future();
        this.updateDevice(tenantId, deviceId, payload, (Handler<AsyncResult<RegistrationResult>>)result.completer());
        return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setCacheDirective(res.getCacheDirective()));
    }

    private Future<EventBusMessage> processDeregisterRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        if (tenantId == null || deviceId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        this.log.debug("deregistering device [{}] of tenant [{}]", (Object)deviceId, (Object)tenantId);
        Future result = Future.future();
        this.removeDevice(tenantId, deviceId, (Handler<AsyncResult<RegistrationResult>>)result.completer());
        return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setCacheDirective(res.getCacheDirective()));
    }

    @Override
    protected Future<Void> updateDeviceLastVia(String tenantId, String deviceId, String gatewayId, JsonObject deviceData) {
        Future resultFuture = Future.future();
        deviceData.put("last-via", this.createLastViaObject(gatewayId));
        this.updateDevice(tenantId, deviceId, deviceData, (Handler<AsyncResult<RegistrationResult>>)((Handler)res -> {
            if (res.failed() || res.result() == null) {
                resultFuture.fail(res.cause());
            } else if (((RegistrationResult)res.result()).isError()) {
                resultFuture.fail((Throwable)StatusCodeMapper.from((RegistrationResult)((RegistrationResult)res.result())));
            } else {
                resultFuture.complete();
            }
        }));
        return resultFuture;
    }

    protected final JsonObject createLastViaObject(String gatewayId) {
        JsonObject lastViaObj = new JsonObject();
        lastViaObj.put("device-id", gatewayId);
        lastViaObj.put("update-date", ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT));
        return lastViaObj;
    }

    @Override
    public void addDevice(String tenantId, String deviceId, JsonObject otherKeys, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void updateDevice(String tenantId, String deviceId, JsonObject otherKeys, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void removeDevice(String tenantId, String deviceId, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }
}

