/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.auth.DeviceUser;
import org.eclipse.hono.service.auth.device.AuthHandler;
import org.eclipse.hono.util.ExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutionContextAuthHandler<T extends ExecutionContext>
implements AuthHandler<T> {
    static final String AUTH_PROVIDER_CONTEXT_KEY = ExecutionContextAuthHandler.class.getName() + ".provider";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AuthProvider authProvider;

    protected ExecutionContextAuthHandler(AuthProvider authProvider) {
        this.authProvider = authProvider;
    }

    @Override
    public final AuthProvider getAuthProvider() {
        return this.authProvider;
    }

    @Override
    public Future<DeviceUser> authenticateDevice(T context) {
        Future result = Future.future();
        this.parseCredentials(context).compose(authInfo -> {
            Future authResult = Future.future();
            this.getAuthProvider(context).authenticate(authInfo, (Handler)authResult);
            return authResult;
        }).setHandler(authAttempt -> {
            if (authAttempt.succeeded()) {
                if (authAttempt.result() instanceof DeviceUser) {
                    result.complete((Object)((DeviceUser)((Object)((Object)authAttempt.result()))));
                } else {
                    this.log.warn("configured AuthProvider does not return DeviceUser instances [type returned: {}", (Object)((User)authAttempt.result()).getClass().getName());
                    result.fail((Throwable)new ClientErrorException(401));
                }
            } else {
                result.fail(authAttempt.cause());
            }
        });
        return result;
    }

    private AuthProvider getAuthProvider(T ctx) {
        Object obj = ctx.get(AUTH_PROVIDER_CONTEXT_KEY);
        if (obj instanceof AuthProvider) {
            this.log.debug("using auth provider found in context [type: {}]", (Object)obj.getClass().getName());
            return (AuthProvider)obj;
        }
        return this.authProvider;
    }
}

