/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import com.google.common.cache.CacheBuilder;
import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.noop.NoopTracerFactory;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import java.util.Optional;
import org.eclipse.hono.cache.CacheProvider;
import org.eclipse.hono.client.CommandConsumerFactory;
import org.eclipse.hono.client.CredentialsClientFactory;
import org.eclipse.hono.client.DownstreamSenderFactory;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.client.RegistrationClientFactory;
import org.eclipse.hono.client.RequestResponseClientConfigProperties;
import org.eclipse.hono.client.TenantClientFactory;
import org.eclipse.hono.config.ApplicationConfigProperties;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.config.VertxProperties;
import org.eclipse.hono.service.HealthCheckServer;
import org.eclipse.hono.service.VertxBasedHealthCheckServer;
import org.eclipse.hono.service.cache.SpringCacheProvider;
import org.eclipse.hono.service.plan.PrometheusBasedResourceLimitChecks;
import org.eclipse.hono.service.plan.ResourceLimitChecks;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.guava.GuavaCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;

public abstract class AbstractAdapterConfig {
    @Bean
    public Tracer getTracer() {
        return Optional.ofNullable(TracerResolver.resolveTracer()).orElse((Tracer)NoopTracerFactory.create());
    }

    @Bean
    public Vertx vertx() {
        return Vertx.vertx((VertxOptions)this.vertxProperties().configureVertx(new VertxOptions()));
    }

    @Qualifier(value="messaging")
    @ConfigurationProperties(prefix="hono.messaging")
    @Bean
    public ClientConfigProperties downstreamSenderFactoryConfig() {
        ClientConfigProperties config = new ClientConfigProperties();
        this.customizeDownstreamSenderFactoryConfig(config);
        return config;
    }

    protected void customizeDownstreamSenderFactoryConfig(ClientConfigProperties config) {
    }

    @Qualifier(value="messaging")
    @Bean
    @Scope(value="prototype")
    public DownstreamSenderFactory downstreamSenderFactory() {
        return DownstreamSenderFactory.create((HonoConnection)this.downstreamConnection());
    }

    @Qualifier(value="messaging")
    @Bean
    @Scope(value="prototype")
    public HonoConnection downstreamConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.downstreamSenderFactoryConfig());
    }

    @Qualifier(value="registration")
    @ConfigurationProperties(prefix="hono.registration")
    @Bean
    public RequestResponseClientConfigProperties registrationClientFactoryConfig() {
        RequestResponseClientConfigProperties config = new RequestResponseClientConfigProperties();
        this.customizeRegistrationClientFactoryConfig(config);
        return config;
    }

    protected void customizeRegistrationClientFactoryConfig(RequestResponseClientConfigProperties config) {
    }

    @Bean
    @Qualifier(value="registration")
    @Scope(value="prototype")
    public RegistrationClientFactory registrationClientFactory() {
        return RegistrationClientFactory.create((HonoConnection)this.registrationServiceConnection(), (CacheProvider)this.registrationCacheProvider());
    }

    @Bean
    @Qualifier(value="registration")
    @Scope(value="prototype")
    public HonoConnection registrationServiceConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.registrationClientFactoryConfig());
    }

    @Bean
    @Qualifier(value="registration")
    @Scope(value="prototype")
    public CacheProvider registrationCacheProvider() {
        return AbstractAdapterConfig.newGuavaCache(this.registrationClientFactoryConfig());
    }

    @Qualifier(value="credentials")
    @ConfigurationProperties(prefix="hono.credentials")
    @Bean
    public ClientConfigProperties credentialsClientFactoryConfig() {
        RequestResponseClientConfigProperties config = new RequestResponseClientConfigProperties();
        this.customizeCredentialsClientFactoryConfig(config);
        return config;
    }

    protected void customizeCredentialsClientFactoryConfig(RequestResponseClientConfigProperties config) {
    }

    @Bean
    @Qualifier(value="credentials")
    @Scope(value="prototype")
    public CredentialsClientFactory credentialsClientFactory() {
        return CredentialsClientFactory.create((HonoConnection)this.credentialsServiceConnection());
    }

    @Bean
    @Qualifier(value="credentials")
    @Scope(value="prototype")
    public HonoConnection credentialsServiceConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.credentialsClientFactoryConfig());
    }

    @Qualifier(value="tenant")
    @ConfigurationProperties(prefix="hono.tenant")
    @Bean
    public RequestResponseClientConfigProperties tenantServiceClientConfig() {
        RequestResponseClientConfigProperties config = new RequestResponseClientConfigProperties();
        this.customizeTenantClientFactoryConfig(config);
        return config;
    }

    protected void customizeTenantClientFactoryConfig(RequestResponseClientConfigProperties config) {
    }

    @Bean
    @Qualifier(value="tenant")
    @Scope(value="prototype")
    public TenantClientFactory tenantClientFactory() {
        return TenantClientFactory.create((HonoConnection)this.tenantServiceConnection(), (CacheProvider)this.tenantCacheProvider());
    }

    @Bean
    @Qualifier(value="tenant")
    @Scope(value="prototype")
    public HonoConnection tenantServiceConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.tenantServiceClientConfig());
    }

    @Bean
    @Qualifier(value="tenant")
    @Scope(value="prototype")
    public CacheProvider tenantCacheProvider() {
        return AbstractAdapterConfig.newGuavaCache(this.tenantServiceClientConfig());
    }

    @Qualifier(value="control")
    @ConfigurationProperties(prefix="hono.command")
    @Bean
    public ClientConfigProperties commandConsumerFactoryConfig() {
        return new ClientConfigProperties();
    }

    @Bean
    @Scope(value="prototype")
    public CommandConsumerFactory commandConsumerFactory() {
        return CommandConsumerFactory.create((HonoConnection)this.commandConsumerConnection());
    }

    @Bean
    @Scope(value="prototype")
    public HonoConnection commandConsumerConnection() {
        return HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.commandConsumerFactoryConfig());
    }

    @ConfigurationProperties(value="hono.vertx")
    @Bean
    public VertxProperties vertxProperties() {
        return new VertxProperties();
    }

    private static CacheProvider newGuavaCache(RequestResponseClientConfigProperties config) {
        int minCacheSize = config.getResponseCacheMinSize();
        long maxCacheSize = config.getResponseCacheMaxSize();
        if (maxCacheSize <= 0L) {
            return null;
        }
        CacheBuilder builder = CacheBuilder.newBuilder().concurrencyLevel(1).initialCapacity(minCacheSize).maximumSize(Math.max((long)minCacheSize, maxCacheSize));
        GuavaCacheManager manager = new GuavaCacheManager();
        manager.setAllowNullValues(false);
        manager.setCacheBuilder(builder);
        return new SpringCacheProvider((CacheManager)manager);
    }

    @Bean
    @ConfigurationProperties(prefix="hono.app")
    public ApplicationConfigProperties applicationConfigProperties() {
        return new ApplicationConfigProperties();
    }

    @Bean
    public HealthCheckServer healthCheckServer() {
        return new VertxBasedHealthCheckServer(this.vertx(), this.applicationConfigProperties());
    }

    @Bean
    @ConfigurationProperties(prefix="hono.plan.prometheusBased")
    @ConditionalOnProperty(name={"hono.plan.prometheusBased.host"})
    public ResourceLimitChecks resourceLimitChecks() {
        return new PrometheusBasedResourceLimitChecks(this.vertx());
    }
}

