/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.registration;

import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonObject;
import java.util.Objects;
import org.eclipse.hono.client.ClientErrorException;
import org.eclipse.hono.service.EventBusService;
import org.eclipse.hono.service.registration.RegistrationAssertionHelper;
import org.eclipse.hono.service.registration.RegistrationService;
import org.eclipse.hono.util.CacheDirective;
import org.eclipse.hono.util.EventBusMessage;
import org.eclipse.hono.util.RegistrationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class BaseRegistrationService<T>
extends EventBusService<T>
implements RegistrationService {
    public static final String PROPERTY_VIA = "via";
    private RegistrationAssertionHelper assertionFactory;

    @Autowired
    @Qualifier(value="signing")
    public final void setRegistrationAssertionFactory(RegistrationAssertionHelper assertionFactory) {
        this.assertionFactory = Objects.requireNonNull(assertionFactory);
    }

    @Override
    protected void doStart(Future<Void> startFuture) {
        if (this.assertionFactory == null) {
            startFuture.fail((Throwable)new IllegalStateException("registration assertion factory must be set"));
        } else {
            startFuture.complete();
        }
    }

    @Override
    protected String getEventBusAddress() {
        return "registration.in";
    }

    @Override
    public final Future<EventBusMessage> processRequest(EventBusMessage requestMessage) {
        Objects.requireNonNull(requestMessage);
        switch (requestMessage.getOperation()) {
            case "register": {
                return this.processRegisterRequest(requestMessage);
            }
            case "assert": {
                return this.processAssertRequest(requestMessage);
            }
            case "get": {
                return this.processGetRequest(requestMessage);
            }
            case "update": {
                return this.processUpdateRequest(requestMessage);
            }
            case "deregister": {
                return this.processDeregisterRequest(requestMessage);
            }
        }
        return this.processCustomRegistrationMessage(requestMessage);
    }

    private Future<EventBusMessage> processRegisterRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        JsonObject payload = this.getRequestPayload(request.getJsonPayload());
        if (tenantId == null || deviceId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        this.log.debug("registering device [{}] for tenant [{}]", (Object)deviceId, (Object)tenantId);
        Future result = Future.future();
        this.addDevice(tenantId, deviceId, payload, (Handler<AsyncResult<RegistrationResult>>)result.completer());
        return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setCacheDirective(res.getCacheDirective()));
    }

    private Future<EventBusMessage> processGetRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        if (tenantId == null || deviceId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        this.log.debug("retrieving device [{}] of tenant [{}]", (Object)deviceId, (Object)tenantId);
        Future result = Future.future();
        this.getDevice(tenantId, deviceId, (Handler<AsyncResult<RegistrationResult>>)result.completer());
        return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective()));
    }

    private Future<EventBusMessage> processUpdateRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        JsonObject payload = this.getRequestPayload(request.getJsonPayload());
        if (tenantId == null || deviceId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        this.log.debug("updating registration information for device [{}] of tenant [{}]", (Object)deviceId, (Object)tenantId);
        Future result = Future.future();
        this.updateDevice(tenantId, deviceId, payload, (Handler<AsyncResult<RegistrationResult>>)result.completer());
        return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setCacheDirective(res.getCacheDirective()));
    }

    private Future<EventBusMessage> processDeregisterRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        if (tenantId == null || deviceId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        this.log.debug("deregistering device [{}] of tenant [{}]", (Object)deviceId, (Object)tenantId);
        Future result = Future.future();
        this.removeDevice(tenantId, deviceId, (Handler<AsyncResult<RegistrationResult>>)result.completer());
        return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setCacheDirective(res.getCacheDirective()));
    }

    private Future<EventBusMessage> processAssertRequest(EventBusMessage request) {
        String tenantId = request.getTenant();
        String deviceId = request.getDeviceId();
        String gatewayId = request.getGatewayId();
        if (tenantId == null || deviceId == null) {
            return Future.failedFuture((Throwable)new ClientErrorException(400));
        }
        if (gatewayId == null) {
            this.log.debug("asserting registration of device [{}] with tenant [{}]", (Object)deviceId, (Object)tenantId);
            Future result = Future.future();
            this.assertRegistration(tenantId, deviceId, (Handler<AsyncResult<RegistrationResult>>)result.completer());
            return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective()));
        }
        this.log.debug("asserting registration of device [{}] with tenant [{}] for gateway [{}]", new Object[]{deviceId, tenantId, gatewayId});
        Future result = Future.future();
        this.assertRegistration(tenantId, deviceId, gatewayId, (Handler<AsyncResult<RegistrationResult>>)result.completer());
        return result.map(res -> request.getResponse(res.getStatus()).setDeviceId(deviceId).setJsonPayload((JsonObject)res.getPayload()).setCacheDirective(res.getCacheDirective()));
    }

    protected Future<EventBusMessage> processCustomRegistrationMessage(EventBusMessage request) {
        this.log.debug("invalid operation in request message [{}]", (Object)request.getOperation());
        return Future.failedFuture((Throwable)new ClientErrorException(400));
    }

    @Override
    public void addDevice(String tenantId, String deviceId, JsonObject otherKeys, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void getDevice(String tenantId, String deviceId, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void updateDevice(String tenantId, String deviceId, JsonObject otherKeys, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void removeDevice(String tenantId, String deviceId, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        this.handleUnimplementedOperation(resultHandler);
    }

    @Override
    public void assertRegistration(String tenantId, String deviceId, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(resultHandler);
        Future getResultTracker = Future.future();
        this.getDevice(tenantId, deviceId, (Handler<AsyncResult<RegistrationResult>>)getResultTracker.completer());
        getResultTracker.map(result -> {
            if (this.isDeviceEnabled((RegistrationResult)result)) {
                return RegistrationResult.from((int)200, (JsonObject)this.getAssertionPayload(tenantId, deviceId, ((JsonObject)result.getPayload()).getJsonObject("data")), (CacheDirective)CacheDirective.maxAgeDirective((long)this.assertionFactory.getAssertionLifetime()));
            }
            return RegistrationResult.from((int)404);
        }).setHandler(resultHandler);
    }

    @Override
    public void assertRegistration(String tenantId, String deviceId, String gatewayId, Handler<AsyncResult<RegistrationResult>> resultHandler) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(gatewayId);
        Objects.requireNonNull(resultHandler);
        Future deviceInfoTracker = Future.future();
        Future gatewayInfoTracker = Future.future();
        this.getDevice(tenantId, deviceId, (Handler<AsyncResult<RegistrationResult>>)deviceInfoTracker.completer());
        this.getDevice(tenantId, gatewayId, (Handler<AsyncResult<RegistrationResult>>)gatewayInfoTracker.completer());
        CompositeFuture.all((Future)deviceInfoTracker, (Future)gatewayInfoTracker).compose(ok -> {
            RegistrationResult deviceResult = (RegistrationResult)deviceInfoTracker.result();
            RegistrationResult gatewayResult = (RegistrationResult)gatewayInfoTracker.result();
            if (!this.isDeviceEnabled(deviceResult)) {
                return Future.succeededFuture((Object)RegistrationResult.from((int)404));
            }
            if (!this.isDeviceEnabled(gatewayResult)) {
                return Future.succeededFuture((Object)RegistrationResult.from((int)403));
            }
            JsonObject deviceData = ((JsonObject)deviceResult.getPayload()).getJsonObject("data", new JsonObject());
            JsonObject gatewayData = ((JsonObject)gatewayResult.getPayload()).getJsonObject("data", new JsonObject());
            if (this.isGatewayAuthorized(gatewayId, gatewayData, deviceId, deviceData)) {
                return Future.succeededFuture((Object)RegistrationResult.from((int)200, (JsonObject)this.getAssertionPayload(tenantId, deviceId, deviceData), (CacheDirective)CacheDirective.maxAgeDirective((long)this.assertionFactory.getAssertionLifetime())));
            }
            return Future.succeededFuture((Object)RegistrationResult.from((int)403));
        }).setHandler(resultHandler);
    }

    protected void handleUnimplementedOperation(Handler<AsyncResult<RegistrationResult>> resultHandler) {
        resultHandler.handle((Object)Future.succeededFuture((Object)RegistrationResult.from((int)501)));
    }

    protected boolean isGatewayAuthorized(String gatewayId, JsonObject gatewayData, String deviceId, JsonObject deviceData) {
        return gatewayId.equals(deviceData.getString(PROPERTY_VIA));
    }

    private boolean isDeviceEnabled(RegistrationResult registrationResult) {
        return registrationResult.isOk() && this.isDeviceEnabled(((JsonObject)registrationResult.getPayload()).getJsonObject("data"));
    }

    private boolean isDeviceEnabled(JsonObject registrationData) {
        return registrationData.getBoolean("enabled", Boolean.TRUE);
    }

    protected final JsonObject getAssertionPayload(String tenantId, String deviceId, JsonObject registrationInfo) {
        JsonObject result = new JsonObject().put("device-id", deviceId).put("assertion", this.assertionFactory.getAssertion(tenantId, deviceId));
        JsonObject defaults = registrationInfo.getJsonObject("defaults");
        if (defaults != null) {
            result.put("defaults", defaults);
        }
        return result;
    }

    protected static final JsonObject getResultPayload(String deviceId, JsonObject data) {
        return new JsonObject().put("device-id", deviceId).put("data", data);
    }
}

