/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.metric;

import java.util.Objects;
import org.eclipse.hono.service.metric.MetricConfig;
import org.eclipse.hono.service.metric.NullCounterService;
import org.eclipse.hono.service.metric.NullGaugeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;

public abstract class Metrics {
    protected static final String METER_PREFIX = "meter.";
    protected static final String TIMER_PREFIX = "timer.";
    protected static final String HISTOGRAM_PREFIX = "histogram.";
    protected static final String MESSAGES = ".messages.";
    protected static final String PROCESSED = ".processed";
    protected static final String DISCARDED = ".discarded";
    protected static final String UNDELIVERABLE = ".undeliverable";
    protected static final String CONNECTIONS = ".connections.";
    protected static final String UNAUTHENTICATED_CONNECTIONS = ".unauthenticatedConnections.";
    protected GaugeService gaugeService = NullGaugeService.getInstance();
    protected CounterService counterService = NullCounterService.getInstance();

    @Autowired(required=false)
    public void setMetricConfig(MetricConfig metricConfig) {
        metricConfig.setPrefix(this.getPrefix());
    }

    protected abstract String getPrefix();

    @Autowired(required=false)
    public final void setGaugeService(GaugeService gaugeService) {
        this.gaugeService = gaugeService;
    }

    @Autowired(required=false)
    public final void setCounterService(CounterService counterService) {
        this.counterService = counterService;
    }

    protected String normalizeAddress(String address) {
        Objects.requireNonNull(address);
        return address.replace('/', '.');
    }

    protected String mergeAsMetric(String ... parts) {
        return String.join((CharSequence)".", parts);
    }
}

