/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.command;

import io.vertx.core.buffer.Buffer;
import java.util.function.Predicate;

public final class CommandResponse {
    private static final Predicate<Integer> INVALID_STATUS_CODE = code -> code == null || code < 200 || code >= 300 && code < 400 || code >= 600;
    private final Buffer payload;
    private final String contentType;
    private final int status;
    private final String replyTo;
    private final String correlationId;

    private CommandResponse(Buffer payload, String contentType, int status, String correlationId, String replyTo) {
        this.payload = payload;
        this.contentType = contentType;
        this.status = status;
        this.replyTo = replyTo;
        this.correlationId = correlationId;
    }

    public static CommandResponse from(String requestId, String deviceId, Integer status) {
        return CommandResponse.from(requestId, deviceId, null, null, status);
    }

    public static CommandResponse from(String requestId, String deviceId, Buffer payload, String contentType, Integer status) {
        if (requestId == null) {
            return null;
        }
        if (INVALID_STATUS_CODE.test(status)) {
            return null;
        }
        if (requestId.length() < 3) {
            return null;
        }
        try {
            boolean addDeviceIdToReply = "1".equals(requestId.substring(0, 1));
            int lengthStringOne = Integer.parseInt(requestId.substring(1, 3), 16);
            String replyId = requestId.substring(3 + lengthStringOne);
            return new CommandResponse(payload, contentType, status, requestId.substring(3, 3 + lengthStringOne), addDeviceIdToReply ? deviceId + "/" + replyId : replyId);
        }
        catch (NumberFormatException | StringIndexOutOfBoundsException se) {
            return null;
        }
    }

    public String getReplyToId() {
        return this.replyTo;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public Buffer getPayload() {
        return this.payload;
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getStatus() {
        return this.status;
    }
}

