/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.command;

import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.RoutingContext;
import io.vertx.proton.ProtonDelivery;
import java.util.Objects;
import java.util.Optional;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Released;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.message.Message;
import org.eclipse.hono.util.MessageHelper;
import org.eclipse.hono.util.ResourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Command {
    private static final Logger LOG = LoggerFactory.getLogger(Command.class);
    private static final String KEY_COMMAND = "command";
    private final ProtonDelivery delivery;
    private final Message message;
    private final String tenantId;
    private final String deviceId;
    private final String requestId;
    private final String correlationId;
    private final String replyToId;

    private Command(ProtonDelivery delivery, Message message, String tenantId, String deviceId, String correlationId, String replyToId) {
        this.delivery = delivery;
        this.message = message;
        this.tenantId = tenantId;
        this.deviceId = deviceId;
        this.replyToId = replyToId;
        this.correlationId = correlationId;
        this.requestId = Command.getRequestId(correlationId, replyToId, deviceId);
    }

    public static Command from(ProtonDelivery delivery, Message message, String tenantId, String deviceId) {
        Objects.requireNonNull(delivery);
        Objects.requireNonNull(message);
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        try {
            String correlationId = Optional.ofNullable(message.getCorrelationId()).map(obj -> {
                if (obj instanceof String) {
                    return (String)obj;
                }
                return null;
            }).orElseGet(() -> {
                Object obj = message.getMessageId();
                if (obj instanceof String) {
                    return (String)obj;
                }
                return null;
            });
            if (correlationId == null) {
                return null;
            }
            ResourceIdentifier replyTo = ResourceIdentifier.fromString((String)message.getReplyTo());
            if (!"control".equals(replyTo.getEndpoint())) {
                return null;
            }
            if (!tenantId.equals(replyTo.getTenantId())) {
                return null;
            }
            String replyToId = replyTo.getPathWithoutBase();
            if (replyToId == null) {
                return null;
            }
            return new Command(Objects.requireNonNull(delivery), Objects.requireNonNull(message), Objects.requireNonNull(tenantId), Objects.requireNonNull(deviceId), correlationId, replyToId);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static boolean isValidCommand(Message message, String tenantId, String deviceId) {
        Objects.requireNonNull(message);
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        try {
            String correlationId = Optional.ofNullable(message.getCorrelationId()).orElse(message.getMessageId()).toString();
            if (correlationId == null) {
                return false;
            }
            ResourceIdentifier replyTo = ResourceIdentifier.fromString((String)message.getReplyTo());
            if (!"control".equals(replyTo.getEndpoint())) {
                return false;
            }
            if (!tenantId.equals(replyTo.getTenantId()) || !deviceId.equals(replyTo.getResourceId())) {
                return false;
            }
            return replyTo.getResourcePath().length >= 4;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static Command get(RoutingContext ctx) {
        return (Command)Objects.requireNonNull(ctx).get(KEY_COMMAND);
    }

    public void put(RoutingContext ctx) {
        Objects.requireNonNull(ctx).put(KEY_COMMAND, (Object)this);
    }

    public String getName() {
        return this.message.getSubject();
    }

    public String getTenant() {
        return this.tenantId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Buffer getPayload() {
        return MessageHelper.getPayload((Message)this.message);
    }

    public String getReplyToId() {
        return this.replyToId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    static String getRequestId(String correlationId, String replyToId, String deviceId) {
        String stringOne = Optional.ofNullable(correlationId).orElse("");
        String stringTwo = Optional.ofNullable(replyToId).orElse("");
        boolean removeDeviceFromReplyTo = stringTwo.startsWith(deviceId + "/");
        if (removeDeviceFromReplyTo) {
            stringTwo = stringTwo.substring(deviceId.length() + 1);
        }
        return String.format("%s%02x%s%s", removeDeviceFromReplyTo ? "1" : "0", stringOne.length(), stringOne, stringTwo);
    }

    public void accept() {
        LOG.trace("accepting command message [name: {}, request-id: {}] for device [tenant-id: {}, device-id: {}]", new Object[]{this.getName(), this.getRequestId(), this.getTenant(), this.getDeviceId()});
        this.delivery.disposition((DeliveryState)new Accepted(), true);
    }

    public void release() {
        LOG.trace("releasing command message [name: {}, request-id: {}] for device [tenant-id: {}, device-id: {}]", new Object[]{this.getName(), this.getRequestId(), this.getTenant(), this.getDeviceId()});
        this.delivery.disposition((DeliveryState)new Released(), true);
    }
}

