/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.AuthHandler;
import io.vertx.ext.web.handler.impl.HttpStatusException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.hono.client.ServiceInvocationException;

public abstract class HonoAuthHandler
implements AuthHandler {
    protected static final String AUTH_PROVIDER_CONTEXT_KEY = "io.vertx.ext.web.handler.AuthHandler.provider";
    protected static final HttpStatusException FORBIDDEN = new HttpStatusException(403);
    protected static final HttpStatusException UNAUTHORIZED = new HttpStatusException(401);
    protected static final HttpStatusException BAD_REQUEST = new HttpStatusException(400);
    protected final String realm;
    protected final AuthProvider authProvider;
    protected final Set<String> authorities = new HashSet<String>();

    public HonoAuthHandler(AuthProvider authProvider) {
        this(authProvider, "");
    }

    public HonoAuthHandler(AuthProvider authProvider, String realm) {
        this.authProvider = authProvider;
        this.realm = realm;
    }

    public AuthHandler addAuthority(String authority) {
        this.authorities.add(authority);
        return this;
    }

    public AuthHandler addAuthorities(Set<String> authorities) {
        this.authorities.addAll(authorities);
        return this;
    }

    public void authorize(User user, Handler<AsyncResult<Void>> handler) {
        int requiredcount = this.authorities.size();
        if (requiredcount > 0) {
            if (user == null) {
                handler.handle((Object)Future.failedFuture((Throwable)FORBIDDEN));
                return;
            }
            AtomicInteger count = new AtomicInteger();
            AtomicBoolean sentFailure = new AtomicBoolean();
            Handler authHandler = res -> {
                if (res.succeeded()) {
                    if (((Boolean)res.result()).booleanValue()) {
                        if (count.incrementAndGet() == requiredcount) {
                            handler.handle((Object)Future.succeededFuture());
                        }
                    } else if (sentFailure.compareAndSet(false, true)) {
                        handler.handle((Object)Future.failedFuture((Throwable)FORBIDDEN));
                    }
                } else {
                    handler.handle((Object)Future.failedFuture((Throwable)res.cause()));
                }
            };
            for (String authority : this.authorities) {
                if (sentFailure.get()) continue;
                user.isAuthorized(authority, authHandler);
            }
        } else {
            handler.handle((Object)Future.succeededFuture());
        }
    }

    protected String authenticateHeader(RoutingContext context) {
        return null;
    }

    public void handle(RoutingContext ctx) {
        if (this.handlePreflight(ctx)) {
            return;
        }
        User user = ctx.user();
        if (user != null) {
            this.authorizeUser(ctx, user);
            return;
        }
        this.parseCredentials(ctx, res -> {
            if (res.failed()) {
                this.processException(ctx, res.cause());
                return;
            }
            User updatedUser = ctx.user();
            if (updatedUser != null) {
                Session session = ctx.session();
                if (session != null) {
                    session.regenerateId();
                }
                this.authorizeUser(ctx, updatedUser);
                return;
            }
            this.getAuthProvider(ctx).authenticate((JsonObject)res.result(), authN -> {
                if (authN.succeeded()) {
                    User authenticated = (User)authN.result();
                    ctx.setUser(authenticated);
                    Session session = ctx.session();
                    if (session != null) {
                        session.regenerateId();
                    }
                    this.authorizeUser(ctx, authenticated);
                } else {
                    String header = this.authenticateHeader(ctx);
                    if (header != null) {
                        ctx.response().putHeader("WWW-Authenticate", header);
                    }
                    this.processException(ctx, authN.cause());
                }
            });
        });
    }

    protected void processException(RoutingContext ctx, Throwable exception) {
        if (exception != null && (exception instanceof HttpStatusException || exception instanceof ServiceInvocationException)) {
            String payload;
            int statusCode;
            if (exception instanceof HttpStatusException) {
                statusCode = ((HttpStatusException)exception).getStatusCode();
                payload = ((HttpStatusException)exception).getPayload();
            } else {
                statusCode = ((ServiceInvocationException)exception).getErrorCode();
                payload = null;
            }
            switch (statusCode) {
                case 302: {
                    ctx.response().putHeader(HttpHeaders.LOCATION, (CharSequence)payload).setStatusCode(302).end("Redirecting to " + payload + ".");
                    return;
                }
                case 401: {
                    String header = this.authenticateHeader(ctx);
                    if (header != null) {
                        ctx.response().putHeader("WWW-Authenticate", header);
                    }
                    ctx.fail(exception);
                    return;
                }
            }
            ctx.fail(exception);
            return;
        }
        ctx.fail(exception);
    }

    private void authorizeUser(RoutingContext ctx, User user) {
        this.authorize(user, (Handler<AsyncResult<Void>>)((Handler)authZ -> {
            if (authZ.failed()) {
                this.processException(ctx, authZ.cause());
                return;
            }
            ctx.next();
        }));
    }

    private boolean handlePreflight(RoutingContext ctx) {
        String accessControlRequestHeader;
        HttpServerRequest request = ctx.request();
        if (request.method() == HttpMethod.OPTIONS && (accessControlRequestHeader = ctx.request().getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS)) != null) {
            for (String ctrlReq : accessControlRequestHeader.split(",")) {
                if (!ctrlReq.equalsIgnoreCase("Authorization")) continue;
                ctx.next();
                return true;
            }
        }
        return false;
    }

    private AuthProvider getAuthProvider(RoutingContext ctx) {
        try {
            AuthProvider provider = (AuthProvider)ctx.get(AUTH_PROVIDER_CONTEXT_KEY);
            if (provider != null) {
                return provider;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return this.authProvider;
    }
}

