/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service.auth.device;

import io.vertx.core.Future;
import java.security.GeneralSecurityException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.hono.service.auth.X509CertificateChainValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceCertificateValidator
implements X509CertificateChainValidator {
    private static final Logger LOG = LoggerFactory.getLogger(DeviceCertificateValidator.class);

    @Override
    public Future<Void> validate(List<X509Certificate> chain, TrustAnchor trustAnchor) {
        Objects.requireNonNull(chain);
        Objects.requireNonNull(trustAnchor);
        if (chain.isEmpty()) {
            throw new IllegalArgumentException("certificate chain must not be empty");
        }
        Future result = Future.future();
        try {
            PKIXParameters params = new PKIXParameters(Collections.singleton(trustAnchor));
            params.setRevocationEnabled(false);
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            CertPath path = factory.generateCertPath(chain);
            CertPathValidator validator = CertPathValidator.getInstance("PKIX");
            validator.validate(path, params);
            LOG.debug("validation of device certificate [subject DN: {}] succeeded", (Object)chain.get(0).getSubjectX500Principal().getName());
            result.complete();
        }
        catch (GeneralSecurityException e) {
            LOG.debug("validation of device certificate [subject DN: {}] failed", (Object)chain.get(0).getSubjectX500Principal().getName(), (Object)e);
            result.fail((Throwable)e);
        }
        return result;
    }
}

