/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.service;

import com.google.common.cache.CacheBuilder;
import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.noop.NoopTracerFactory;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.metrics.MetricsOptions;
import java.util.Optional;
import org.eclipse.hono.cache.CacheProvider;
import org.eclipse.hono.client.HonoClient;
import org.eclipse.hono.client.RequestResponseClientConfigProperties;
import org.eclipse.hono.client.impl.HonoClientImpl;
import org.eclipse.hono.config.ClientConfigProperties;
import org.eclipse.hono.service.cache.SpringCacheProvider;
import org.eclipse.hono.service.command.CommandConfigProperties;
import org.eclipse.hono.service.command.CommandConnection;
import org.eclipse.hono.service.command.CommandConnectionImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.guava.GuavaCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Scope;

public abstract class AbstractAdapterConfig {
    private MetricsOptions metricsOptions;

    @Bean
    public Tracer getTracer() {
        return Optional.ofNullable(TracerResolver.resolveTracer()).orElse((Tracer)NoopTracerFactory.create());
    }

    @Autowired(required=false)
    public void setMetricsOptions(MetricsOptions metricsOptions) {
        this.metricsOptions = metricsOptions;
    }

    @Bean
    public Vertx vertx() {
        VertxOptions options = new VertxOptions().setWarningExceptionTime(1500000000L).setAddressResolverOptions(new AddressResolverOptions().setCacheNegativeTimeToLive(0).setCacheMaxTimeToLive(0).setQueryTimeout(1000L));
        if (this.metricsOptions != null) {
            options.setMetricsOptions(this.metricsOptions);
        }
        return Vertx.vertx((VertxOptions)options);
    }

    @Qualifier(value="messaging")
    @ConfigurationProperties(prefix="hono.messaging")
    @Bean
    public ClientConfigProperties messagingClientConfig() {
        ClientConfigProperties config = new ClientConfigProperties();
        this.customizeMessagingClientConfig(config);
        return config;
    }

    protected void customizeMessagingClientConfig(ClientConfigProperties config) {
    }

    @Qualifier(value="messaging")
    @Bean
    @Scope(value="prototype")
    public HonoClient messagingClient() {
        return new HonoClientImpl(this.vertx(), this.messagingClientConfig());
    }

    @Qualifier(value="registration")
    @ConfigurationProperties(prefix="hono.registration")
    @Bean
    public RequestResponseClientConfigProperties registrationServiceClientConfig() {
        RequestResponseClientConfigProperties config = new RequestResponseClientConfigProperties();
        this.customizeRegistrationServiceClientConfig(config);
        return config;
    }

    protected void customizeRegistrationServiceClientConfig(RequestResponseClientConfigProperties config) {
    }

    @Bean
    @Qualifier(value="registration")
    @Scope(value="prototype")
    public HonoClient registrationServiceClient() {
        HonoClientImpl result = new HonoClientImpl(this.vertx(), (ClientConfigProperties)this.registrationServiceClientConfig());
        CacheProvider cacheProvider = this.registrationCacheProvider();
        if (cacheProvider != null) {
            result.setCacheProvider(cacheProvider);
        }
        return result;
    }

    @Bean
    @Qualifier(value="registration")
    @Scope(value="prototype")
    public CacheProvider registrationCacheProvider() {
        return AbstractAdapterConfig.newGuavaCache(this.registrationServiceClientConfig());
    }

    @Qualifier(value="credentials")
    @ConfigurationProperties(prefix="hono.credentials")
    @Bean
    public ClientConfigProperties credentialsServiceClientConfig() {
        RequestResponseClientConfigProperties config = new RequestResponseClientConfigProperties();
        this.customizeCredentialsServiceClientConfig(config);
        return config;
    }

    protected void customizeCredentialsServiceClientConfig(RequestResponseClientConfigProperties config) {
    }

    @Bean
    @Qualifier(value="credentials")
    @Scope(value="prototype")
    public HonoClient credentialsServiceClient() {
        return new HonoClientImpl(this.vertx(), this.credentialsServiceClientConfig());
    }

    @Qualifier(value="tenant")
    @ConfigurationProperties(prefix="hono.tenant")
    @Bean
    public RequestResponseClientConfigProperties tenantServiceClientConfig() {
        RequestResponseClientConfigProperties config = new RequestResponseClientConfigProperties();
        this.customizeTenantServiceClientConfig(config);
        return config;
    }

    protected void customizeTenantServiceClientConfig(RequestResponseClientConfigProperties config) {
    }

    @Bean
    @Qualifier(value="tenant")
    @Scope(value="prototype")
    public HonoClient tenantServiceClient() {
        HonoClientImpl result = new HonoClientImpl(this.vertx(), (ClientConfigProperties)this.tenantServiceClientConfig());
        CacheProvider cacheProvider = this.tenantCacheProvider();
        if (cacheProvider != null) {
            result.setCacheProvider(cacheProvider);
        }
        return result;
    }

    @Bean
    @Qualifier(value="tenant")
    @Scope(value="prototype")
    public CacheProvider tenantCacheProvider() {
        return AbstractAdapterConfig.newGuavaCache(this.tenantServiceClientConfig());
    }

    @Qualifier(value="control")
    @ConfigurationProperties(prefix="hono.command")
    @Bean
    public CommandConfigProperties commandConnectionClientConfig() {
        return new CommandConfigProperties();
    }

    @Bean
    @Scope(value="prototype")
    public CommandConnection commandConnection() {
        return new CommandConnectionImpl(this.vertx(), this.commandConnectionClientConfig());
    }

    private static CacheProvider newGuavaCache(RequestResponseClientConfigProperties config) {
        int minCacheSize = config.getResponseCacheMinSize();
        long maxCacheSize = config.getResponseCacheMaxSize();
        if (maxCacheSize <= 0L) {
            return null;
        }
        CacheBuilder builder = CacheBuilder.newBuilder().concurrencyLevel(1).initialCapacity(minCacheSize).maximumSize(Math.max((long)minCacheSize, maxCacheSize));
        GuavaCacheManager manager = new GuavaCacheManager();
        manager.setAllowNullValues(false);
        manager.setCacheBuilder(builder);
        return new SpringCacheProvider((CacheManager)manager);
    }
}

